# msys setup

* Mount windows home directory: Use included fstab file
* Bashrc for various SDKs and stuff: Use the bashrc end 
* Windows terminal: Use the JSON provided to add the profile
* VS code terminal: Use the settings.json snippet

Note: path inheritance: By default, msys does not inherit paths. You can pass the "-full-path" flag to the msys2_shell.cmd to re enable it. I enabled this so i can use windows installed programs like NVIM, which I think have better integration when they are not msys'd. Make sure to remove anything you dont want in msys from the windows PATH variable though.

## Visual studio

Download and install normally.
Build and install this program: https://gitlab.com/antekone/envdiff
Open a standard command prompt. Run ./envdiff thing.diff. 
Next, open a Visual studio command line tools prompt. Run ./envdiff thing.diff > settings.sh (same file thing.diff).
Add to bashrc or in a separate file you can source in a function (in my bashrc .vs_env_cmd.sh).

NOTE: BE VERY CAREFUL ABOUT 64-BIT! Your environment will correspond to the command line tools window you open. So, the PATH stuff that it extends is going to point to the 32-bit "cl.exe" if you open the standard visual studio command line tools window to do the envdiff. This is going to break stuff like Cuda, which will want the 64-bit compiler, but only when visual studio makefiles are not being used to configure the project (such as if you select the Ninja generator in cmake.) 
Best to just run the envdiff in the 64-bit tools window so that "cl" points to the 64 bit version by default.
Can make a differnt environment for the 32-bit version.

NOTE 2: "link.exe" in /usr/bin conflicts with the MSVC executable. Can rename it, or with the envdiff solution, the MSVC paths should normally come first.

NOTE 3: I'm not sure what the best way to manage cmake with this setup is, but what I have done for now is use neither the VS bundled CMake or the MSYS cmake, but the Cmake you can install directly from the kitware website for windows. This includes cmake-gui, which afaik neither the msys or vs versions have. I source the path only when the vs_env is called. 
One weird caveat about cmake in msys: make sure you install the one that belongs to your compiler environment, not the generic 'msys' one. The msys one has weird problems and doesnt set environment variables properly or something, I cant remember. just dont fucking install it

## Pico sdk

Don't use the windows pico sdk installer. Just clone pico sdk repo yourself. For the pico-tools, you can download the prebuilt releases here: https://github.com/raspberrypi/pico-sdk-tools/releases/tag/v2.2.0-2
The bashrc snippet sets the right variables so the pico CMAKE picks up on it.

## speed woes 

could try a ramdisk for /tmp folder (copium)
https://stackoverflow.com/questions/5630403/mingw-msys-slow-how-to-make-faster
http://www.ltr-data.se/opencode.html/#ImDisk
https://sourceforge.net/projects/aim-toolkit/ (newer version)

## STM32 enviroment

Use STCubeCLT, add the tools to path. Cygpath helps to correct path woes. Snippet in bashrc.

For debug, use the cortex-m debug extension. Point the st link as shown in settings.json snippet

# sshd
https://www.msys2.org/wiki/Setting-up-SSHd/
https://superuser.com/questions/1799896/how-to-configure-powershell-for-openssh-instead-of-cmd
https://superuser.com/questions/1342411/setting-ssh-keys-on-windows-10-openssh-server

If you want it to log onto MSYS, you can follow the above superuser link to set the registry values. Point it to the "sshd_msys_default.cmd". NOTE: If you do this, it will break VS Code SSH, because it gets confused that it is on windows but bash (line endings have problems.)

SSHD is the standard 

# rclone 

Download and install rclone and add the share according to the instructions: https://party.shitfest.club/?hc. 
Add the rclone service to the task scheduler in windows using the xml to import below.

# obs studio emuspy plugin

https://github.com/aglab2/OBSEmuSpy