#include "types.h"

#include "game/level_update.h"
#include "game/game_init.h"
#include "game/ingame_menu.h"

#include "action.h"
#include "checkpoint.h"
#include "cfg.h"
#include "custom_text.h"
#include "death.h"
#include "death_floor.h"
#include "distance.h"
#include "input_viewer.h"
#include "interaction.h"
#include "level_reset.h"
#include "levitate.h"
#include "music.h"
#include "savestate.h"
#include "shared.h"
#include "soft_reset.h"
#include "speed.h"
#include "status.h"
#include "text_manager.h"
#include "timer.h"
#include "version.h"
#include "wallkick_frame.h"
#include "strings.h"

#define PLAY_MODE_NORMAL 0
#define PLAY_MODE_PAUSED 2

extern u8 gMyStupidLastNodeId;
extern size_t gWarpSeqCtr;

extern int lastWarped;
extern int gWarpTimerOffset;
void Hacktice_onFrame()
{
    // SoftReset_onFrame();

    HackticeSetStatus(HACKTICE_STATUS_ACTIVE);
    if (PLAY_MODE_NORMAL == sCurrPlayMode)
    {
        Death_onNormal();
        Distance_onNormal();
        InputViewer_onNormal();
        LevelReset_onNormal();
        Levitate_onNormal();
        SaveState_onNormal();
        Speed_onNormal();
        WallkickFrame_onNormal();
        Interaction_onNormal();
        Music_onFrame();
        Version_onFrame();
        CustomText_onFrame();
        if (Config_enableWarpInfo) {
            char lvlinfo[16]; // 9
            sprintf(lvlinfo, "%02x %02x %02x %02x", gCurrLevelNum, gCurrAreaIndex, gMyStupidLastNodeId, gWarpSeqCtr);
            TextManager_addLine(lvlinfo, 1);
            /*char t1[9];
            char t2[9];
            char t3[9];
            sprintf(t1, "%08x", gGlobalTimer);
            sprintf(t2, "%08x", gWarpTimerOffset);
            sprintf(t3, "%08x", lastWarped);
            TextManager_addLine(t1, 1);
            TextManager_addLine(t2, 1);
            TextManager_addLine(t3, 1);*/
        }   

        Checkpoint_onNormal();

        Action_onNormal();
    }

    Timer_onFrame();
    TextManager_onFrame();
}

void Hacktice_onPause()
{
    SaveState_onPause();
    Config_onPause();
}

uintptr_t Hacktice_start[] = {
    (uintptr_t) Hacktice_onFrame,
    (uintptr_t) Hacktice_onPause,
    (uintptr_t) Music_setVolumeHook,
    (uintptr_t) DeathFloor_checkDeathBarrierHook,
    HACKTICE_CANARY,
#define HACKTICE_VERSION(maj, min, patch) (((maj) << 24) | ((min) << 16) | ((patch))),
#include "xversion.h"
#undef HACKTICE_VERSION
    HACKTICE_STATUS_INIT,
    (uintptr_t) &Hacktice_gConfig,
    // some version of hacktice UI assume this is valid vptr
    // on decomp this will be overwritten with an actual value
    0x80026000,
    (uintptr_t) LevelReset_onSpawnObjectsFromInfoHook,
#ifdef BINARY
    (uintptr_t) LevelReset_setObjectRespawnInfoBits,
#else
    (uintptr_t) 0 /*ignored*/,
#endif
    (uintptr_t) 0 /*reserved for future use*/,
};

#ifndef BINARY
bool Hacktice_gEnabled = true;
#endif
