#!/bin/bash
# run as root
WLAN="wlp4s0"
ETH="enp2s0"

ip addr del 10.0.0.1/24 dev $ETH
sysctl net.ipv4.ip_forward=0

iptables -t nat -D POSTROUTING -o $WLAN -j MASQUERADE
iptables -D FORWARD -i $WLAN -o $ETH -m state --state RELATED,ESTABLISHED -j ACCEPT
iptables -D FORWARD -i $ETH -o $WLAN -j ACCEPT
iptables -t nat -D PREROUTING -i $ETH -p tcp --dport 7777 -j DNAT --to-destination 10.0.0.1:22
iptables -t nat -D POSTROUTING -p tcp -d 10.0.1.1 --dport 22 -j SNAT --to-source 10.0.1.2

iptables -D FORWARD -i $WLAN -o wg0 -m state --state RELATED,ESTABLISHED -j ACCEPT
iptables -D FORWARD -i wg0 -o $WLAN -j ACCEPT
iptables -D FORWARD -i $ETH -o wg0 -j ACCEPT
iptables -D FORWARD -i wg0 -o $ETH -j ACCEPT
