#!/bin/bash
# run as root
WLAN="wlp4s0"
ETH="enp2s0"

ip link set dev $ETH up
ip addr add 10.0.0.1/24 dev $ETH
sysctl net.ipv4.ip_forward=1

iptables -t nat -A POSTROUTING -o $WLAN -j MASQUERADE
iptables -A FORWARD -i $WLAN -o $ETH -m state --state RELATED,ESTABLISHED -j ACCEPT
iptables -A FORWARD -i $ETH -o $WLAN -j ACCEPT
iptables -t nat -A PREROUTING -i $ETH -p tcp --dport 7777 -j DNAT --to-destination 10.0.1.1:22
#iptables -t nat -A POSTROUTING -p tcp -d 10.0.1.1 --dport 22 -j SNAT --to-source 10.0.1.2

iptables -A FORWARD -i $WLAN -o wg0 -m state --state RELATED,ESTABLISHED -j ACCEPT
iptables -A FORWARD -i wg0 -o $WLAN -j ACCEPT
iptables -A FORWARD -i $ETH -o wg0 -j ACCEPT
iptables -A FORWARD -i wg0 -o $ETH -j ACCEPT
