#include "includes.h"

void process_stick(analog_data_t *in, analog_data_t *out,
                   const bool gate_limiter_enable,
                   const calib_results_t *calib_results,
                   const stick_config_t *stick_config) {

    ax_t notch_remap_in_x = calib_results->fit_coeffs_x[1] * (in->ax1 - calib_results->fit_coeffs_x[0]);
    ax_t notch_remap_in_y = calib_results->fit_coeffs_y[1] * (in->ax2 - calib_results->fit_coeffs_y[0]);

    ax_t remapped_x, remapped_y;
    notch_remap(notch_remap_in_x, notch_remap_in_y, &remapped_x, &remapped_y,
                gate_limiter_enable, calib_results, stick_config);

    out->ax1 = fmin(1.0, fmax(-1.0, remapped_x));
    out->ax2 = fmin(1.0, fmax(-1.0, remapped_y));
}