#include <msp432p401r.h>

#define DEBUG

#include "includes.h"

typedef struct {
    int8_t x;
    int8_t y;
} vec2_t;


vec2_t calibration_points_in[] = {
    { 2, 0 },
    { 96, 0 },
    { 0, 1 },
    { 70, 74 },
    { 0, 1 },
    { -1, 85 },
    { 0, 0 },
    { -60, 80 },
    { 0, 2 },
    { -100, 0 },
    { 0, 1 }, 
    { -70, -70 },
    { 1, 1 },
    { 0, -82 },
    { 0, 0 },
    { 80, -80 }
};

calib_results_t g_calib_results = {
    .calibrated = false,
    .affine_coeffs = {0},
    .boundary_angles = {0},
    .fit_coeffs_x = {0},
    .fit_coeffs_y = {0},
    .notch_points_x_in = {0},
    .notch_points_y_in = {0}
};
stick_config_t g_stick_config = {
    .notch_points_x = {
        INT_N_TO_AX(85, 8), INT_N_TO_AX(70, 8), INT_N_TO_AX(0, 8),
        INT_N_TO_AX(-70, 8), INT_N_TO_AX(-85, 8), INT_N_TO_AX(-70, 8),
        INT_N_TO_AX(0, 8), INT_N_TO_AX(70, 8)
    },
    .notch_points_y = {
        INT_N_TO_AX(0, 8), INT_N_TO_AX(70, 8), INT_N_TO_AX(85, 8),
        INT_N_TO_AX(70, 8), INT_N_TO_AX(0, 8), INT_N_TO_AX(-70, 8),
        INT_N_TO_AX(-85, 8), INT_N_TO_AX(-70, 8)
    },
    .angle_deadzones = {0},
    .mag_threshold = .8 // 80% into the notch by default
};
int g_timer_wrap = 0;

int main(void) {
    // disable watchdog
    WDT_A->CTL = WDT_A_CTL_PW | WDT_A_CTL_HOLD;

    P1DIR |= BIT0;  // P1_0

    volatile int i;
    while(1){
        for (i = 0; i < 100000; i++);  // Delay
        P1OUT ^= BIT0;  // toggle the LED
        putchar('a');
    }
    return 0;

    _cal_step = 1;
    analog_data_t in;
    for (int i = 0; i < 16; i++) {
        in.ax1 = INT_N_TO_AX(calibration_points_in[0].x, 8);
        in.ax2 = INT_N_TO_AX(calibration_points_in[0].y, 8);
        calibration_advance(&in);
    }

    analog_data_t out;
    SysTick->CTRL = 0x05;     // CLKSRC | ENABLE, interrupt disable
    __enable_irq();
    while (1) {
        SysTick->LOAD = (1 << 24) - 1;
        SysTick->VAL = 1 - 1;     // clear value register
        g_timer_wrap = 0;
        // Time this loop
        for (volatile int i = 0; i < 100000; i++) {
            in.ax1 = INT_N_TO_AX((rand() & 255 - 128), 8);
            in.ax2 = INT_N_TO_AX((rand() & 255 - 128), 8);
            process_stick(&in, &out, false, &g_calib_results, &g_stick_config);
        }
        uint32_t duration = (SysTick->VAL) + (g_timer_wrap * ((1 << 24)-1));
        printf("Loop duration: %u cycles\n", duration);
    }

    /**/

    return 0;
}
void SysTick_Handler(void)
{
    g_timer_wrap++;
}