/*
 * Decompiled with CFR 0.152.
 */
package com.pam.harvestcraft;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.pam.harvestcraft.TrapRecipes;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandom;
import org.lwjgl.opengl.GL11;

public abstract class TrapRecipeHandler
extends TemplateRecipeHandler {
    protected final Map<Item, List<TrapRecipes.WeightedItemStack>> recipes;

    public TrapRecipeHandler(Map<Item, List<TrapRecipes.WeightedItemStack>> recipes) {
        this.recipes = recipes;
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)-2, (int)0, (int)3, (int)8, (int)170, (int)66);
    }

    public void drawExtras(int recipe) {
        TrapRecipe trapRecipe = (TrapRecipe)((Object)this.arecipes.get(recipe));
        for (int i = 0; i < trapRecipe.chances.size(); ++i) {
            int x = i % 6;
            int y = i / 6;
            String text = String.format(Locale.ROOT, "%.1f%%", trapRecipe.chances.get(i));
            int w = GuiDraw.getStringWidth((String)text);
            GL11.glTranslatef((float)(73 + 18 * x), (float)(21 + 18 * y), (float)0.0f);
            GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
            GuiDraw.drawString((String)text, (int)(-w), (int)0, (int)0xFFFFFF);
            GL11.glScalef((float)2.0f, (float)2.0f, (float)1.0f);
            GL11.glTranslatef((float)(-73 - 18 * x), (float)(-21 - 18 * y), (float)0.0f);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        block0: for (Map.Entry<Item, List<TrapRecipes.WeightedItemStack>> recipe : this.recipes.entrySet()) {
            List<TrapRecipes.WeightedItemStack> outputs = recipe.getValue();
            for (TrapRecipes.WeightedItemStack output : outputs) {
                if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)result, (ItemStack)output.stack)) continue;
                this.arecipes.add(new TrapRecipe(recipe.getKey(), outputs));
                continue block0;
            }
        }
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getOverlayIdentifier())) {
            for (Map.Entry<Item, List<TrapRecipes.WeightedItemStack>> recipe : this.recipes.entrySet()) {
                this.arecipes.add(new TrapRecipe(recipe.getKey(), recipe.getValue()));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(38, 26, 18, 18), this.getOverlayIdentifier(), new Object[0]));
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        Item bait = ingredient.func_77973_b();
        List<TrapRecipes.WeightedItemStack> outputs = this.recipes.get(bait);
        if (outputs != null) {
            this.arecipes.add(new TrapRecipe(bait, outputs));
        }
    }

    public class TrapRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        private final PositionedStack bait;
        private final List<PositionedStack> outputs;
        private final List<Float> chances;

        public TrapRecipe(Item bait, List<TrapRecipes.WeightedItemStack> outputs) {
            super((TemplateRecipeHandler)TrapRecipeHandler.this);
            this.bait = new PositionedStack((Object)new ItemStack(bait), 21, 27);
            this.outputs = new ArrayList<PositionedStack>(outputs.size());
            this.chances = new ArrayList<Float>(outputs.size());
            float totalWeight = WeightedRandom.func_76272_a(outputs);
            for (int i = 0; i < outputs.size(); ++i) {
                TrapRecipes.WeightedItemStack output = outputs.get(i);
                int x = i % 6;
                int y = i / 6;
                this.outputs.add(new PositionedStack((Object)output.stack, 57 + 18 * x, 9 + 18 * y));
                this.chances.add(Float.valueOf(100.0f * (float)output.field_76292_a / totalWeight));
            }
        }

        public PositionedStack getResult() {
            return null;
        }

        public PositionedStack getIngredient() {
            return this.bait;
        }

        public List<PositionedStack> getOtherStacks() {
            return this.outputs;
        }
    }
}

