/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.Base;

import Reika.ChromatiCraft.API.Interfaces.WorldRift;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import Reika.ReactorCraft.Base.TileEntityReactorBase;
import Reika.ReactorCraft.Registry.ReactorTiles;
import Reika.RotaryCraft.API.Interfaces.RCPipe;
import Reika.RotaryCraft.Auxiliary.Interfaces.PipeConnector;
import Reika.RotaryCraft.Auxiliary.Interfaces.PumpablePipe;
import Reika.RotaryCraft.Auxiliary.Interfaces.RenderableDuct;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPiping;
import java.util.Arrays;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public abstract class TileEntityReactorPiping
extends TileEntityReactorBase
implements RenderableDuct,
PumpablePipe,
RCPipe {
    protected Fluid fluid;
    protected int level;
    private boolean[] connections = new boolean[6];

    public abstract boolean isValidFluid(Fluid var1);

    public void updateEntity(World world, int x, int y, int z, int meta) {
        Fluid f = this.getFluidType();
        this.intakeFluid(world, x, y, z);
        if (this.getLevel() <= 0) {
            this.setLevel(0);
            this.setFluid(null);
        } else {
            this.dumpContents(world, x, y, z);
        }
        Fluid f2 = this.getFluidType();
        if (f != f2) {
            this.syncAllData(true);
            world.func_147471_g(x, y, z);
        }
    }

    public boolean isConnectedDirectly(ForgeDirection dir) {
        return this.connections[dir.ordinal()];
    }

    protected boolean isInteractableTile(TileEntity te) {
        if (te == null) {
            return false;
        }
        if (te.getClass() == ((Object)((Object)this)).getClass()) {
            return true;
        }
        if (te instanceof IFluidHandler) {
            String name = te.getClass().getSimpleName().toLowerCase(Locale.ENGLISH);
            return !name.contains("conduit") && !name.contains("pipe");
        }
        return false;
    }

    protected final boolean canInteractWith(World world, int x, int y, int z, ForgeDirection side) {
        if (!this.connections[side.ordinal()]) {
            return false;
        }
        int dx = x + side.offsetX;
        int dy = y + side.offsetY;
        int dz = z + side.offsetZ;
        Block id = world.func_147439_a(dx, dy, dz);
        int meta = world.func_72805_g(dx, dy, dz);
        if (id == Blocks.field_150350_a) {
            return false;
        }
        ReactorTiles m = ReactorTiles.getTE((IBlockAccess)world, dx, dy, dz);
        if (m == this.getTile()) {
            return true;
        }
        TileEntity te = this.getTileEntity(dx, dy, dz);
        return (te instanceof PipeConnector || te instanceof IFluidHandler) && this.isInteractableTile(te);
    }

    public final void animateWithTick(World world, int x, int y, int z) {
    }

    public final Fluid getFluidType() {
        return this.fluid;
    }

    public final int getLevel() {
        return this.level;
    }

    public final int getX() {
        return this.field_145851_c;
    }

    public final int getY() {
        return this.field_145848_d;
    }

    public final int getZ() {
        return this.field_145849_e;
    }

    public final World getWorld() {
        return this.field_145850_b;
    }

    public final boolean isConnectionValidForSide(ForgeDirection dir) {
        if (dir.offsetX == 0 && MinecraftForgeClient.getRenderPass() != 1) {
            dir = dir.getOpposite();
        }
        return this.connections[dir.ordinal()];
    }

    public final AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1));
    }

    public final void recomputeConnections(World world, int x, int y, int z) {
        for (int i = 0; i < 6; ++i) {
            this.connections[i] = this.isConnected(this.dirs[i]);
            world.func_147479_m(x + this.dirs[i].offsetX, y + this.dirs[i].offsetY, z + this.dirs[i].offsetZ);
        }
        this.syncAllData(true);
        world.func_147479_m(x, y, z);
    }

    public final void deleteFromAdjacentConnections(World world, int x, int y, int z) {
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = this.dirs[i];
            int dx = x + dir.offsetX;
            int dy = x + dir.offsetY;
            int dz = x + dir.offsetZ;
            ReactorTiles m = ReactorTiles.getTE((IBlockAccess)world, dx, dy, dz);
            if (m != ReactorTiles.TEList[this.getIndex()]) continue;
            TileEntityReactorPiping te = (TileEntityReactorPiping)world.func_147438_o(dx, dy, dz);
            te.connections[dir.getOpposite().ordinal()] = false;
            world.func_147479_m(dx, dy, dz);
        }
    }

    public final void addToAdjacentConnections(World world, int x, int y, int z) {
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = this.dirs[i];
            int dx = x + dir.offsetX;
            int dy = x + dir.offsetY;
            int dz = x + dir.offsetZ;
            ReactorTiles m = ReactorTiles.getTE((IBlockAccess)world, dx, dy, dz);
            if (m != ReactorTiles.TEList[this.getIndex()]) continue;
            TileEntityReactorPiping te = (TileEntityReactorPiping)world.func_147438_o(dx, dy, dz);
            te.connections[dir.getOpposite().ordinal()] = true;
            world.func_147479_m(dx, dy, dz);
        }
    }

    private boolean isConnected(ForgeDirection dir) {
        ReactorTiles m2;
        int x = this.field_145851_c + dir.offsetX;
        int y = this.field_145848_d + dir.offsetY;
        int z = this.field_145849_e + dir.offsetZ;
        ReactorTiles m = ReactorTiles.TEList[this.getIndex()];
        if (m == (m2 = ReactorTiles.getTE((IBlockAccess)this.field_145850_b, x, y, z))) {
            return true;
        }
        TileEntity tile = this.field_145850_b.func_147438_o(x, y, z);
        return tile instanceof IFluidHandler && this.isInteractableTile(tile);
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        for (int i = 0; i < 6; ++i) {
            NBT.func_74757_a("conn" + i, this.connections[i]);
        }
        ReikaNBTHelper.writeFluidToNBT((NBTTagCompound)NBT, (Fluid)this.getFluidType());
        NBT.func_74768_a("level", this.getLevel());
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        boolean update = false;
        boolean[] old = new boolean[this.connections.length];
        System.arraycopy(this.connections, 0, old, 0, old.length);
        for (int i = 0; i < 6; ++i) {
            this.connections[i] = NBT.func_74767_n("conn" + i);
        }
        update = !Arrays.equals(old, this.connections);
        Fluid f = ReikaNBTHelper.getFluidFromNBT((NBTTagCompound)NBT);
        update = update || f != this.getFluidType();
        this.setFluid(f);
        this.setLevel(NBT.func_74762_e("level"));
        if (this.field_145850_b != null && update) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public final int removeLiquid(int max) {
        int has = this.getFluidLevel();
        int rem = Math.min(max, has);
        this.setLevel(has - rem);
        return rem;
    }

    public final void addFluid(int toadd) {
        this.setLevel(this.getFluidLevel() + toadd);
    }

    public final boolean addFluid(Fluid f, int toadd) {
        Fluid has = this.getFluidType();
        if (has != null && has != f) {
            return false;
        }
        this.setFluid(f);
        this.addFluid(toadd);
        return true;
    }

    private final void intakeFluid(World world, int x, int y, int z) {
        for (int i = 0; i < 6; ++i) {
            int level;
            int todrain;
            IFluidHandler fl;
            FluidStack fs;
            int todrain2;
            WorldLocation loc;
            ForgeDirection dir = this.dirs[i];
            if (!this.canInteractWith(world, x, y, z, dir)) continue;
            int dx = x + dir.offsetX;
            int dy = y + dir.offsetY;
            int dz = z + dir.offsetZ;
            TileEntity te = world.func_147438_o(dx, dy, dz);
            if (te instanceof WorldRift && (loc = ((WorldRift)te).getLinkTarget()) != null) {
                if ((te = ((WorldRift)te).getTileEntityFrom(dir)) == null) continue;
                dx = te.field_145851_c;
                dy = te.field_145848_d;
                dz = te.field_145849_e;
                world = te.field_145850_b;
            }
            if (!this.isInteractableTile(te)) continue;
            if (te instanceof TileEntityReactorPiping) {
                int amt;
                int dL;
                TileEntityReactorPiping tp = (TileEntityReactorPiping)te;
                Fluid f = tp.getFluidType();
                if (f == null || (todrain2 = this.getPipeIntake(dL = (amt = tp.getLevel()) - this.getLevel())) <= 0 || !this.canIntakeFluid(f)) continue;
                this.setFluid(f);
                this.addFluid(todrain2);
                tp.removeLiquid(todrain2);
                this.onIntake(te);
                continue;
            }
            if (te instanceof PipeConnector) {
                int level2;
                FluidStack fs2;
                PipeConnector pc = (PipeConnector)te;
                TileEntityPiping.Flow flow = pc.getFlowForSide(dir.getOpposite());
                if (!flow.canOutput || (fs2 = pc.drain(dir.getOpposite(), Integer.MAX_VALUE, false)) == null || (todrain2 = this.getPipeIntake(fs2.amount - (level2 = this.getLevel()))) <= 0 || !this.canIntakeFluid(fs2.getFluid())) continue;
                this.addFluid(todrain2);
                this.setFluid(fs2.getFluid());
                pc.drain(dir.getOpposite(), todrain2, true);
                this.onIntake(te);
                continue;
            }
            if (!(te instanceof IFluidHandler) || (fs = (fl = (IFluidHandler)te).drain(dir.getOpposite(), Integer.MAX_VALUE, false)) == null || (todrain = this.getPipeIntake(fs.amount - (level = this.getLevel()))) <= 0 || !this.canIntakeFluid(fs.getFluid())) continue;
            fl.drain(dir.getOpposite(), todrain, true);
            this.addFluid(todrain);
            this.setFluid(fs.getFluid());
            this.onIntake(te);
        }
    }

    private final void dumpContents(World world, int x, int y, int z) {
        Fluid f = this.getFluidType();
        if (this.getLevel() <= 0 || f == null) {
            return;
        }
        for (int i = 0; i < 6; ++i) {
            int added;
            int toadd;
            IFluidHandler fl;
            WorldLocation loc;
            int level = this.getLevel();
            if (level <= 0) {
                this.setFluid(null);
                return;
            }
            ForgeDirection dir = this.dirs[i];
            if (!this.canInteractWith(world, x, y, z, dir)) continue;
            int dx = x + dir.offsetX;
            int dy = y + dir.offsetY;
            int dz = z + dir.offsetZ;
            TileEntity te = world.func_147438_o(dx, dy, dz);
            if (te instanceof WorldRift && (loc = ((WorldRift)te).getLinkTarget()) != null) {
                if ((te = ((WorldRift)te).getTileEntityFrom(dir)) == null) continue;
                dx = te.field_145851_c;
                dy = te.field_145848_d;
                dz = te.field_145849_e;
                world = te.field_145850_b;
            }
            if (!this.isInteractableTile(te)) continue;
            if (te instanceof TileEntityReactorPiping) {
                int otherlevel;
                int dL;
                int toadd2;
                TileEntityReactorPiping tp = (TileEntityReactorPiping)te;
                if (!tp.canIntakeFluid(f) || (toadd2 = this.getPipeOutput(dL = level - (otherlevel = tp.getLevel()))) <= 0) continue;
                tp.addFluid(toadd2);
                this.removeLiquid(toadd2);
                continue;
            }
            if (te instanceof PipeConnector) {
                int toadd3;
                PipeConnector pc = (PipeConnector)te;
                TileEntityPiping.Flow flow = pc.getFlowForSide(dir.getOpposite());
                if (!flow.canIntake || (toadd3 = this.getPipeOutput(this.getLevel())) <= 0) continue;
                FluidStack fs = new FluidStack(f, toadd3);
                int added2 = pc.fill(dir.getOpposite(), fs, true);
                if (added2 <= 0) continue;
                this.removeLiquid(added2);
                continue;
            }
            if (!(te instanceof IFluidHandler) || dir.offsetY != 0 || !(fl = (IFluidHandler)te).canFill(dir.getOpposite(), f) || (toadd = this.getPipeOutput(this.getLevel())) <= 0 || (added = fl.fill(dir.getOpposite(), new FluidStack(f, toadd), true)) <= 0) continue;
            this.removeLiquid(added);
        }
    }

    private boolean canIntakeFluid(Fluid f) {
        return this.isValidFluid(f) && (this.fluid == null || f.equals(this.fluid));
    }

    public final int getPipeIntake(int otherlevel) {
        return TileEntityPiping.TransferAmount.FORCEDQUARTER.getTransferred(otherlevel);
    }

    public final int getPipeOutput(int max) {
        return Math.min(TileEntityPiping.TransferAmount.FORCEDQUARTER.getTransferred(max), this.getLevel() - 5);
    }

    private void setFluid(Fluid f) {
        this.fluid = f;
    }

    private void setLevel(int amt) {
        this.level = amt;
    }

    protected abstract void onIntake(TileEntity var1);

    public final boolean isFluidPipe() {
        return true;
    }

    public IIcon getOverlayIcon() {
        return null;
    }

    public final boolean canTransferTo(PumpablePipe p, ForgeDirection dir) {
        return p instanceof TileEntityReactorPiping && this.getTile() == ((TileEntityReactorPiping)p).getTile();
    }

    public final void transferFrom(PumpablePipe from, int amt) {
        TileEntityReactorPiping te = (TileEntityReactorPiping)from;
        this.setLevel(this.getFluidLevel() + amt);
        this.setFluid(te.getFluidType());
        te.setLevel(te.getFluidLevel() - amt);
        if (te.getFluidLevel() == 0) {
            te.setFluid(null);
        }
    }

    public final int getFluidLevel() {
        return this.getLevel();
    }
}

