/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.Blocks;

import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaParticleHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.ReactorCraft.Auxiliary.RadiationEffects;
import Reika.ReactorCraft.Entities.EntityRadiation;
import Reika.ReactorCraft.ReactorCraft;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.BlockFluidClassic;

public class BlockCoriumFlowing
extends BlockFluidClassic {
    private IIcon[] icon;

    public BlockCoriumFlowing(Material material) {
        super(ReactorCraft.CORIUM, material);
        this.func_149711_c(100.0f);
        this.func_149713_g(0);
        this.func_149752_b(500.0f);
        this.func_149647_a((CreativeTabs)(ReactorCraft.instance.isLocked() ? null : ReactorCraft.tabRctr));
    }

    protected void flowIntoBlock(World world, int x, int y, int z, int l) {
        AxisAlignedBB box;
        Block b = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        super.flowIntoBlock(world, x, y, z, l);
        Block blockId = world.func_147439_a(x, y, z);
        if (blockId != Blocks.field_150350_a) {
            blockId.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
        }
        world.func_147465_d(x, y, z, (Block)this, l, 3);
        if ((world.func_147439_a(x, y, z) != b || world.func_72805_g(x, y, z) != meta) && world.func_72872_a(EntityRadiation.class, box = ReikaAABBHelper.getBlockAABB((int)x, (int)y, (int)z).func_72314_b(12.0, 12.0, 12.0)).size() < 24) {
            if (ReikaRandomHelper.doWithChance((double)0.02)) {
                RadiationEffects.instance.contaminateArea(world, x, y + ReikaRandomHelper.getSafeRandomInt((int)3), z, 8, 1.0f, 0.0, false, RadiationEffects.RadiationIntensity.LETHAL);
            }
            if (ReikaRandomHelper.doWithChance((double)0.1)) {
                RadiationEffects.instance.contaminateArea(world, x, y + ReikaRandomHelper.getSafeRandomInt((int)3), z, 1, 1.0f, 0.0, false, RadiationEffects.RadiationIntensity.LETHAL);
            }
        }
        ForgeDirection iceside = ReikaWorldHelper.checkForAdjBlock((World)world, (int)x, (int)y, (int)z, (Block)Blocks.field_150432_aD);
        ForgeDirection waterside = ReikaWorldHelper.checkForAdjMaterial((World)world, (int)x, (int)y, (int)z, (Material)Material.field_151586_h);
        if (iceside != null || waterside != null) {
            if (ReikaRandomHelper.doWithChance((double)15.0)) {
                // empty if block
            }
            if (iceside != null) {
                ReikaWorldHelper.changeAdjBlock((World)world, (int)x, (int)y, (int)z, (ForgeDirection)iceside, (Block)Blocks.field_150358_i, (int)0);
            }
            if (waterside != null) {
                ReikaWorldHelper.changeAdjBlock((World)world, (int)x, (int)y, (int)z, (ForgeDirection)waterside, (Block)Blocks.field_150350_a, (int)0);
                ReikaSoundHelper.playSoundAtBlock((World)world, (int)x, (int)y, (int)z, (String)"random.fizz");
                ReikaParticleHelper.SMOKE.spawnAroundBlock(world, x, y, z, 8);
            }
        }
    }

    private boolean blockBlocksFlow(World world, int x, int y, int z) {
        Block l = world.func_147439_a(x, y, z);
        if (l != Blocks.field_150466_ao && l != Blocks.field_150454_av && l != Blocks.field_150472_an && l != Blocks.field_150468_ap && l != Blocks.field_150436_aH) {
            if (l == Blocks.field_150350_a) {
                return false;
            }
            Material material = l.func_149688_o();
            return material == Material.field_151567_E ? true : material.func_76230_c();
        }
        return true;
    }

    private boolean liquidCanDisplaceBlock(World world, int i, int j, int k) {
        Material material = ReikaWorldHelper.getMaterial((IBlockAccess)world, (int)i, (int)j, (int)k);
        if (material == this.field_149764_J) {
            return false;
        }
        return !this.blockBlocksFlow(world, i, j, k);
    }

    public boolean isReplaceable(IBlockAccess world, int i, int j, int k) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.icon = new IIcon[]{iconRegister.func_94245_a("ReactorCraft:mat/slag"), iconRegister.func_94245_a("ReactorCraft:fluid/slag_flow")};
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int s, int meta) {
        return s != 0 && s != 1 ? this.icon[1] : this.icon[0];
    }

    private void checkForHarden(World world, int x, int y, int z) {
        if (world.func_147439_a(x, y, z) == this) {
            boolean flag = false;
            if (flag || ReikaWorldHelper.getMaterial((IBlockAccess)world, (int)x, (int)y, (int)(z - 1)) == Material.field_151586_h) {
                flag = true;
            }
            if (flag || ReikaWorldHelper.getMaterial((IBlockAccess)world, (int)x, (int)y, (int)(z + 1)) == Material.field_151586_h) {
                flag = true;
            }
            if (flag || ReikaWorldHelper.getMaterial((IBlockAccess)world, (int)(x - 1), (int)y, (int)z) == Material.field_151586_h) {
                flag = true;
            }
            if (flag || ReikaWorldHelper.getMaterial((IBlockAccess)world, (int)(x + 1), (int)y, (int)z) == Material.field_151586_h) {
                flag = true;
            }
            if (flag || ReikaWorldHelper.getMaterial((IBlockAccess)world, (int)x, (int)(y + 1), (int)z) == Material.field_151586_h) {
                flag = true;
            }
            if (flag) {
                this.func_149695_a(world, x, y, z, (Block)this);
            }
        }
    }

    public void func_149726_b(World world, int par2, int par3, int par4) {
        this.checkForHarden(world, par2, par3, par4);
        world.func_147464_a(par2, par3, par4, (Block)this, this.func_149738_a(world));
    }
}

