/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.Blocks;

import Reika.DragonAPI.Instantiable.Data.BlockStruct.BlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaTimeHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import Reika.DragonAPI.ModList;
import Reika.ReactorCraft.CommonProxy;
import Reika.ReactorCraft.ReactorCraft;
import Reika.ReactorCraft.Registry.FluoriteTypes;
import Reika.ReactorCraft.TritiumLampRenderer;
import Reika.RotaryCraft.Registry.BlockRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockTritiumLamp
extends Block {
    private final IIcon[] icons = new IIcon[FluoriteTypes.colorList.length];
    private IIcon bottom;
    private IIcon top;
    private IIcon frame;

    public BlockTritiumLamp(Material mat) {
        super(mat);
        this.func_149647_a((CreativeTabs)ReactorCraft.tabRctr);
        this.func_149711_c(1.5f);
        this.func_149752_b(8.0f);
        this.field_149762_H = field_149778_k;
    }

    public int getLightValue(IBlockAccess iba, int x, int y, int z) {
        if (iba.func_72805_g(x, y, z) < FluoriteTypes.colorList.length) {
            return 0;
        }
        int color = this.getColor(iba, x, y, z).getColor();
        return ModList.COLORLIGHT.isLoaded() ? ReikaColorAPI.getPackedIntForColoredLight((int)color, (int)15) : 15;
    }

    private FluoriteTypes getColor(IBlockAccess iba, int x, int y, int z) {
        return FluoriteTypes.colorList[iba.func_72805_g(x, y, z) % FluoriteTypes.colorList.length];
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    public int func_149701_w() {
        return 1;
    }

    public boolean canRenderInPass(int pass) {
        TritiumLampRenderer.renderPass = pass;
        return pass <= 1;
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149645_b() {
        return CommonProxy.lampRender;
    }

    public boolean func_149686_d() {
        return false;
    }

    public void func_149651_a(IIconRegister ico) {
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = ico.func_94245_a("reactorcraft:lamp/" + FluoriteTypes.colorList[i].getColorName());
        }
        this.frame = ico.func_94245_a("reactorcraft:lamp/frame");
        this.top = ico.func_94245_a("reactorcraft:lamp/top");
        this.bottom = ico.func_94245_a("reactorcraft:lamp/bottom");
    }

    public IIcon func_149691_a(int s, int meta) {
        return this.icons[meta % FluoriteTypes.colorList.length];
    }

    public IIcon getFrameIcon() {
        return this.frame;
    }

    public IIcon getTopIcon() {
        return this.top;
    }

    public IIcon getBottomIcon() {
        return this.bottom;
    }

    public TileEntity createTileEntity(World world, int meta) {
        return new TileEntityTritiumLamp();
    }

    public boolean hasTileEntity(int meta) {
        return true;
    }

    public void func_149726_b(World world, int x, int y, int z) {
    }

    public void func_149749_a(World world, int x, int y, int z, Block old, int oldmeta) {
        TileEntityTritiumLamp te = (TileEntityTritiumLamp)world.func_147438_o(x, y, z);
        te.onBreak();
        super.func_149749_a(world, x, y, z, old, oldmeta);
    }

    public int func_149643_k(World world, int x, int y, int z) {
        return world.func_72805_g(x, y, z);
    }

    public static class TileEntityTritiumLamp
    extends TileEntity {
        private BlockArray blocks = new BlockArray();
        private int ticks;
        private long createdTime;
        public static final long LIFESPAN = (long)((double)ReikaTimeHelper.YEAR.getMinecraftDuration() * 98.4);

        public boolean canUpdate() {
            return true;
        }

        public void func_145845_h() {
            if (this.ticks == 0 && this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) >= FluoriteTypes.colorList.length) {
                this.onCreate();
            }
            if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() - this.createdTime >= LIFESPAN) {
                this.onBreak();
                this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) % FluoriteTypes.colorList.length, 3);
            }
            ++this.ticks;
        }

        public void func_145841_b(NBTTagCompound NBT) {
            super.func_145841_b(NBT);
            this.blocks.writeToNBT("blocks", NBT);
            NBT.func_74772_a("created", this.createdTime);
        }

        public void func_145839_a(NBTTagCompound NBT) {
            super.func_145839_a(NBT);
            this.blocks.readFromNBT("blocks", NBT);
            this.createdTime = NBT.func_74763_f("created");
        }

        public Packet func_145844_m() {
            NBTTagCompound NBT = new NBTTagCompound();
            this.func_145841_b(NBT);
            S35PacketUpdateTileEntity pack = new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, NBT);
            return pack;
        }

        public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity p) {
            this.func_145839_a(p.field_148860_e);
        }

        private void onBreak() {
            if (!this.field_145850_b.field_72995_K) {
                for (int i = 0; i < this.blocks.getSize(); ++i) {
                    Coordinate c = this.blocks.getNthBlock(i);
                    int x = c.xCoord;
                    int y = c.yCoord;
                    int z = c.zCoord;
                    if (this.field_145850_b.func_147439_a(x, y, z) != BlockRegistry.LIGHT.getBlockInstance()) continue;
                    this.field_145850_b.func_147468_f(x, y, z);
                }
            }
        }

        private void onCreate() {
            if (!this.field_145850_b.field_72995_K) {
                if (this.createdTime == 0L) {
                    this.createdTime = this.field_145850_b.func_82737_E();
                }
                if (this.field_145850_b.func_82737_E() - this.createdTime < LIFESPAN) {
                    int r = 16;
                    for (int i = -r; i <= r; ++i) {
                        for (int j = -r; j <= r; ++j) {
                            for (int k = -r; k <= r; ++k) {
                                int z;
                                int y;
                                int x;
                                if (!(ReikaMathLibrary.py3d((double)i, (double)j, (double)k) <= (double)r) || !this.field_145850_b.func_147439_a(x = this.field_145851_c + i, y = this.field_145848_d + j, z = this.field_145849_e + k).isAir((IBlockAccess)this.field_145850_b, x, y, z)) continue;
                                this.field_145850_b.func_147465_d(x, y, z, BlockRegistry.LIGHT.getBlockInstance(), 15, 3);
                                this.field_145850_b.func_147471_g(x, y, z);
                                this.blocks.addBlockCoordinate(x, y, z);
                            }
                        }
                    }
                }
            }
        }

        public boolean shouldRefresh(Block oldBlock, Block newBlock, int oldMeta, int newMeta, World world, int x, int y, int z) {
            return oldBlock != newBlock || oldMeta % FluoriteTypes.colorList.length != newMeta % FluoriteTypes.colorList.length;
        }
    }
}

