/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.Entities;

import Reika.ChromatiCraft.API.Interfaces.WorldRift;
import Reika.DragonAPI.Base.ParticleEntity;
import Reika.DragonAPI.Instantiable.BasicTeleporter;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import Reika.DragonAPI.ModList;
import Reika.ReactorCraft.API.NeutronShield;
import Reika.ReactorCraft.Auxiliary.NeutronBlock;
import Reika.ReactorCraft.Auxiliary.NeutronTile;
import Reika.ReactorCraft.Auxiliary.RadiationEffects;
import Reika.ReactorCraft.Entities.EntityRadiation;
import Reika.ReactorCraft.Registry.FluoriteTypes;
import Reika.ReactorCraft.Registry.RadiationShield;
import Reika.ReactorCraft.Registry.ReactorBlocks;
import Reika.ReactorCraft.Registry.ReactorOptions;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;

public class EntityNeutron
extends ParticleEntity
implements IEntityAdditionalSpawnData {
    private NeutronType type;
    private NeutronSpeed speed;
    private static Block botaniaPlatform;
    private static Block ttPlatform;

    public static void initTransparencyBlocks() {
        botaniaPlatform = ModList.BOTANIA.isLoaded() ? GameRegistry.findBlock((String)ModList.BOTANIA.modLabel, (String)"platform") : null;
        ttPlatform = ModList.THAUMICTINKER.isLoaded() ? GameRegistry.findBlock((String)ModList.THAUMICTINKER.modLabel, (String)"platform") : null;
    }

    public EntityNeutron(World world, int x, int y, int z, ForgeDirection f, NeutronType type) {
        super(world, x, y, z, f);
        this.field_70131_O = 1.0f;
        this.type = type;
        this.speed = type.getCreationSpeed();
        if (this.speed == null) {
            Thread.dumpStack();
        }
    }

    public EntityNeutron(World world) {
        super(world);
    }

    public void func_70108_f(Entity e) {
        if (ReikaRandomHelper.doWithChance((double)12.5) && e instanceof EntityLivingBase) {
            RadiationEffects.instance.applyPulseEffects((EntityLivingBase)e, RadiationEffects.RadiationIntensity.MODERATE);
            this.func_70106_y();
        }
    }

    protected boolean onEnterBlock(World world, int x, int y, int z) {
        Block id = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (!this.isNeutronTransparent(id)) {
            RadiationShield rs;
            String type;
            NeutronShield ns;
            double c;
            boolean flag;
            if (id.hasTileEntity(meta)) {
                WorldLocation tgt;
                TileEntity te = world.func_147438_o(x, y, z);
                if (te instanceof NeutronTile) {
                    return ((NeutronTile)te).onNeutron(this, world, x, y, z);
                }
                if (te instanceof WorldRift && (tgt = ((WorldRift)te).getLinkTarget()) != null && this.field_70146_Z.nextInt(2) != 0) {
                    this.func_70012_b((double)tgt.xCoord + 0.5, (double)tgt.yCoord + 0.5, (double)tgt.zCoord + 0.5, 0.0f, 0.0f);
                    if (tgt.dimensionID != this.field_70170_p.field_73011_w.field_76574_g && !this.field_70170_p.field_72995_K) {
                        ReikaEntityHelper.transferEntityToDimension((Entity)this, (int)tgt.dimensionID, (Teleporter)new BasicTeleporter((WorldServer)tgt.getWorld()));
                    }
                }
            }
            if (id instanceof NeutronBlock) {
                if (((NeutronBlock)id).onNeutron(this, world, x, y, z)) {
                    return true;
                }
            } else if (id instanceof NeutronShield && (flag = ReikaRandomHelper.doWithChance((double)(c = Math.min((ns = (NeutronShield)id).getAbsorptionChance(type = this.getType().name()), RadiationShield.BEDINGOT.neutronAbsorbChance))))) {
                double c2 = MathHelper.func_151237_a((double)ns.getRadiationSpawnMultiplier(world, x, y, z, type), (double)0.0, (double)1.0);
                if (ReikaRandomHelper.doWithChance((double)c2)) {
                    this.spawnRadiationChance(world, x, y, z);
                }
                return true;
            }
            if ((id == ReactorBlocks.FLUORITE.getBlockInstance() || id == ReactorBlocks.FLUORITEORE.getBlockInstance()) && meta < FluoriteTypes.colorList.length) {
                world.func_147465_d(x, y, z, id, meta + 8, 3);
                world.func_147479_m(x, y, z);
            }
            if ((rs = RadiationShield.getFrom(id, meta)) != null && ReikaRandomHelper.doWithChance((double)rs.neutronAbsorbChance)) {
                return true;
            }
            if (ReikaRandomHelper.doWithChance((double)this.speed.getIrradiatedAbsorptionChance())) {
                boolean flag2;
                boolean bl = id.func_149662_c() ? this.field_70146_Z.nextBoolean() && id.getExplosionResistance(null, world, x, y, z, (double)x, (double)y, (double)z) >= 12.0f || ReikaRandomHelper.getSafeRandomInt((int)((int)(24.0f - id.getExplosionResistance(null, world, x, y, z, (double)x, (double)y, (double)z)))) == 0 : (255 - id.getLightOpacity((IBlockAccess)world, x, y, z) == 0 ? ReikaRandomHelper.getSafeRandomInt((int)id.getLightOpacity((IBlockAccess)world, x, y, z)) > 0 : (flag2 = this.field_70146_Z.nextInt(1000) == 0));
                if (flag2) {
                    this.spawnRadiationChance(world, x, y, z);
                    if (ReikaRandomHelper.doWithChance((double)20.0)) {
                        RadiationEffects.instance.transformBlock(world, x, y, z, RadiationEffects.RadiationIntensity.MODERATE);
                    }
                    return true;
                }
            }
            return false;
        }
        return this.field_70146_Z.nextInt(1000) == 0;
    }

    private boolean isNeutronTransparent(Block id) {
        return id == Blocks.field_150350_a || id == botaniaPlatform || id == ttPlatform;
    }

    private void spawnRadiationChance(World world, int x, int y, int z) {
        AxisAlignedBB box;
        List inbox;
        if (ReikaRandomHelper.doWithChance((double)2.0) && (inbox = world.func_72872_a(EntityRadiation.class, box = ReikaAABBHelper.getBlockAABB((int)x, (int)y, (int)z).func_72314_b(8.0, 8.0, 8.0))).size() < 3) {
            RadiationEffects.instance.contaminateArea(world, x, y, z, 1, 1.0f, 0.0, false, RadiationEffects.RadiationIntensity.LOWLEVEL);
        }
    }

    public double getSpeed() {
        return 0.75;
    }

    protected void onTick() {
    }

    public void moderate() {
        this.speed = NeutronSpeed.THERMAL;
    }

    public double getHitboxSize() {
        return 0.1;
    }

    public boolean despawnOverTime() {
        return true;
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeInt(this.type.ordinal());
    }

    public void readSpawnData(ByteBuf data) {
        this.type = NeutronType.neutronList[data.readInt()];
        this.speed = this.type.getCreationSpeed();
    }

    public NeutronType getType() {
        return this.type != null ? this.type : NeutronType.NULL;
    }

    public NeutronSpeed getNeutronSpeed() {
        return this.speed;
    }

    protected void func_70037_a(NBTTagCompound NBT) {
        this.type = NeutronType.neutronList[NBT.func_74762_e("ntype")];
        this.speed = NeutronSpeed.speedList[NBT.func_74762_e("nspeed")];
    }

    protected void func_70014_b(NBTTagCompound NBT) {
        NBT.func_74768_a("ntype", this.getType().ordinal());
        NBT.func_74768_a("nspeed", this.getNeutronSpeed().ordinal());
    }

    public boolean canInteractWithSpawnLocation() {
        return false;
    }

    public boolean despawnOverDistance() {
        return false;
    }

    public double getRenderRangeSquared() {
        return 4096.0;
    }

    public static enum NeutronSpeed {
        THERMAL,
        FAST;

        public static final NeutronSpeed[] speedList;

        public float getInteractionMultiplier() {
            if (this == THERMAL) {
                return 1.0f;
            }
            if (this == FAST) {
                return 0.6f;
            }
            return 0.0f;
        }

        public double getIrradiatedAbsorptionChance() {
            if (this == THERMAL) {
                return 100.0;
            }
            if (this == FAST) {
                return 40.0;
            }
            return 100.0;
        }

        public float getWasteConversionMultiplier() {
            if (this == THERMAL) {
                return 1.0f;
            }
            if (this == FAST) {
                return 2.2f;
            }
            return 0.0f;
        }

        static {
            speedList = NeutronSpeed.values();
        }
    }

    public static enum NeutronType {
        NULL,
        DECAY,
        FISSION,
        BREEDER,
        FUSION,
        WASTE,
        THORIUM;

        public static final NeutronType[] neutronList;

        public int getBoilerAbsorptionChance() {
            return this == BREEDER || this == THORIUM ? 80 : 0;
        }

        public int getSodiumBoilerAbsorptionChance() {
            return this != BREEDER && this != DECAY ? 90 : 0;
        }

        public boolean canTriggerFuelConversion() {
            return this == BREEDER;
        }

        public boolean dealsDamage() {
            return this != NULL;
        }

        public boolean stoppedByWater() {
            return this != FUSION;
        }

        public boolean canIrradiateMaterials() {
            return this == FISSION || this == FUSION || this == BREEDER || this == THORIUM;
        }

        public boolean isFissionType() {
            return this == DECAY || this == FISSION || this == BREEDER || this == THORIUM;
        }

        public boolean canTriggerFission() {
            return this.isFissionType() || this == WASTE && ReikaRandomHelper.doWithChance((double)40.0);
        }

        public NeutronSpeed getCreationSpeed() {
            if (!ReactorOptions.FASTNEUTRONS.getState()) {
                return NeutronSpeed.THERMAL;
            }
            switch (this) {
                default: {
                    return NeutronSpeed.THERMAL;
                }
                case BREEDER: 
                case FISSION: 
                case THORIUM: 
            }
            return NeutronSpeed.FAST;
        }

        static {
            neutronList = NeutronType.values();
        }
    }
}

