/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.Entities;

import Reika.DragonAPI.Base.InertEntity;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.ReactorCraft.Auxiliary.RadiationEffects;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityRadiation
extends InertEntity
implements IEntityAdditionalSpawnData {
    private int effectRange;
    private RadiationEffects.RadiationIntensity intensity;
    public boolean requireLOS = false;

    public EntityRadiation(World par1World) {
        super(par1World);
    }

    public EntityRadiation(World world, int range, RadiationEffects.RadiationIntensity ri) {
        super(world);
        this.effectRange = range;
        this.intensity = ri;
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound NBT) {
        this.effectRange = NBT.func_74762_e("effrange");
        this.intensity = RadiationEffects.RadiationIntensity.radiationList[NBT.func_74762_e("intensity")];
        this.requireLOS = NBT.func_74767_n("los");
    }

    protected void func_70014_b(NBTTagCompound NBT) {
        NBT.func_74768_a("effrange", this.effectRange);
        NBT.func_74768_a("intensity", this.intensity.ordinal());
        NBT.func_74757_a("los", this.requireLOS);
    }

    public void func_70071_h_() {
        this.func_70030_z();
        this.applyRadiation();
        if (this.effectRange <= 0) {
            this.func_70106_y();
        }
        if (this.decays() && this.field_70146_Z.nextInt(360000) == 0) {
            this.clean();
        }
        if (this.rainCleanable() && this.field_70170_p.func_72896_J() && this.field_70146_Z.nextInt(36000) == 0 && this.field_70170_p.func_72807_a(this.getBlockX(), this.getBlockZ()).func_76738_d()) {
            this.clean();
        }
    }

    protected boolean decays() {
        return true;
    }

    protected boolean rainCleanable() {
        return true;
    }

    public final int getBlockX() {
        return (int)Math.floor(this.field_70165_t);
    }

    public final int getBlockY() {
        return (int)Math.floor(this.field_70163_u);
    }

    public final int getBlockZ() {
        return (int)Math.floor(this.field_70161_v);
    }

    protected void applyRadiation() {
        World world = this.field_70170_p;
        double x = this.field_70165_t;
        double y = this.field_70163_u;
        double z = this.field_70161_v;
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)x, (double)y, (double)z).func_72314_b((double)this.effectRange, (double)this.effectRange, (double)this.effectRange);
        List inbox = world.func_72872_a(EntityLivingBase.class, box);
        for (EntityLivingBase e : inbox) {
            double dd = ReikaMathLibrary.py3d((double)(e.field_70165_t - x), (double)(e.field_70163_u - y), (double)(e.field_70161_v - z));
            if (!(dd <= (double)this.effectRange)) continue;
            RadiationEffects.instance.applyEffects(e, this.intensity);
        }
        boolean c = true;
        int dx = ReikaRandomHelper.getRandomPlusMinus((int)MathHelper.func_76128_c((double)x), (int)this.effectRange);
        int dy = ReikaRandomHelper.getRandomPlusMinus((int)MathHelper.func_76128_c((double)y), (int)this.effectRange);
        int dz = ReikaRandomHelper.getRandomPlusMinus((int)MathHelper.func_76128_c((double)z), (int)this.effectRange);
        RadiationEffects.instance.transformBlock(world, dx, dy, dz, this.intensity);
    }

    public void clean() {
        if (this.effectRange > 0) {
            --this.effectRange;
        } else {
            this.func_70106_y();
        }
    }

    public int getRange() {
        return this.effectRange;
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeInt(this.effectRange);
        data.writeInt(this.intensity.ordinal());
    }

    public void readSpawnData(ByteBuf data) {
        this.effectRange = data.readInt();
        this.intensity = RadiationEffects.RadiationIntensity.radiationList[data.readInt()];
    }

    public boolean func_70097_a(DamageSource src, float par2) {
        if (src.func_94541_c()) {
            RadiationEffects.instance.contaminateArea(this.field_70170_p, this.getBlockX(), this.getBlockY(), this.getBlockZ(), this.effectRange, 0.65f, 0.5, true, this.intensity);
            this.func_70106_y();
            return true;
        }
        return super.func_70097_a(src, par2);
    }
}

