/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.Items;

import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaParticleHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.ReactorCraft.Base.ItemReactorTool;
import Reika.ReactorCraft.Entities.EntityRadiation;
import Reika.ReactorCraft.Registry.ReactorItems;
import Reika.RotaryCraft.API.Interfaces.ChargeableTool;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class ItemRadiationCleaner
extends ItemReactorTool
implements ChargeableTool {
    private static final int CAPACITY = 32000;
    private static final int WATER_PER_TICK = 25;
    private static final int TICK_PER_KJ = 5;

    public ItemRadiationCleaner(int tex) {
        super(tex);
        this.field_77787_bX = false;
    }

    public ItemStack func_77659_a(ItemStack is, World world, EntityPlayer ep) {
        int z;
        int y;
        int x;
        Block id;
        MovingObjectPosition mov;
        if (!world.field_72995_K && this.getWater(is) < 32000 && (mov = ReikaPlayerAPI.getLookedAtBlock((EntityPlayer)ep, (double)5.0, (boolean)true)) != null && (id = world.func_147439_a(x = mov.field_72311_b, y = mov.field_72312_c, z = mov.field_72309_d)) == Blocks.field_150355_j && ReikaWorldHelper.isLiquidSourceBlock((World)world, (int)x, (int)y, (int)z)) {
            this.addWater(is, 1000);
            world.func_147449_b(x, y, z, Blocks.field_150350_a);
            return is;
        }
        ep.func_71008_a(is, this.func_77626_a(is));
        return is;
    }

    public void onUsingTick(ItemStack is, EntityPlayer ep, int count) {
        if (is.func_77960_j() > 0 && this.getWater(is) > 0) {
            double r = 1.0;
            double d = ReikaRandomHelper.getRandomPlusMinus((double)2.5, (double)2.0);
            Vec3 vec = ep.func_70040_Z();
            double dx = ep.field_70165_t + vec.field_72450_a * d;
            double dy = ep.field_70163_u + (double)ep.func_70047_e() + vec.field_72448_b * d;
            double dz = ep.field_70161_v + vec.field_72449_c * d;
            if (count % 5 == 0) {
                AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)dx, (double)dy, (double)dz, (double)dx, (double)dy, (double)dz).func_72314_b(r, r, r);
                List li = ep.field_70170_p.func_72872_a(EntityRadiation.class, box);
                for (EntityRadiation e : li) {
                    e.clean();
                }
            }
            int n = ReikaRandomHelper.getRandomPlusMinus((int)8, (int)4);
            for (int i = 0; i < n; ++i) {
                double v = ReikaRandomHelper.getRandomPlusMinus((double)0.1875, (double)0.0625);
                double vx = vec.field_72450_a * v;
                double vy = vec.field_72448_b * v;
                double vz = vec.field_72449_c * v;
                vx = ReikaRandomHelper.getRandomPlusMinus((double)vx, (double)0.001);
                vz = ReikaRandomHelper.getRandomPlusMinus((double)vz, (double)0.001);
                ReikaParticleHelper.RAIN.spawnAt(ep.field_70170_p, dx, dy, dz, vx, vy, vz);
            }
        }
    }

    public void func_77615_a(ItemStack is, World world, EntityPlayer ep, int ticksLeft) {
        if (!ep.field_71075_bZ.field_75098_d) {
            int used = this.func_77626_a(is) - ticksLeft;
            is.func_77964_b(Math.max(0, is.func_77960_j() - used / 5));
            this.addWater(is, -25 * used);
        }
    }

    public void func_77624_a(ItemStack is, EntityPlayer ep, List li, boolean vb) {
        li.add(String.format("Water: %d/%d mB", this.getWater(is), 32000));
    }

    private int getWater(ItemStack is) {
        return is.field_77990_d != null ? is.field_77990_d.func_74762_e("water") : 0;
    }

    private void addWater(ItemStack is, int amt) {
        this.setWater(is, amt + this.getWater(is));
    }

    private void setWater(ItemStack is, int level) {
        if (is.field_77990_d == null) {
            is.field_77990_d = new NBTTagCompound();
        }
        is.field_77990_d.func_74768_a("water", Math.min(32000, level));
    }

    public EnumAction func_77661_b(ItemStack is) {
        return EnumAction.bow;
    }

    public int func_77626_a(ItemStack is) {
        return Math.min(72000, Math.min(is.func_77960_j() * 5, this.getWater(is) / 25));
    }

    public ItemStack func_77654_b(ItemStack is, World world, EntityPlayer ep) {
        return is;
    }

    @Override
    public void func_150895_a(Item id, CreativeTabs tab, List li) {
        li.add(ReactorItems.CLEANUP.getStackOf());
        ItemStack is = ReactorItems.CLEANUP.getStackOfMetadata(32000);
        this.setWater(is, 32000);
        li.add(is);
    }

    public int setCharged(ItemStack is, int charge, boolean strongcoil) {
        int ret = is.func_77960_j();
        is.func_77964_b(charge);
        return ret;
    }
}

