/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft;

import Reika.DragonAPI.Instantiable.Data.BlockStruct.BlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaParticleHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.BCPipeHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.ThermalDuctHandler;
import Reika.ReactorCraft.Base.TileEntityReactorBase;
import Reika.ReactorCraft.ReactorCraft;
import Reika.RotaryCraft.Registry.MachineRegistry;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidEvent;
import net.minecraftforge.fluids.FluidStack;

public class LiquidHandler {
    @SubscribeEvent
    public void onFluidEntersPipe(FluidEvent.FluidMotionEvent evt) {
        Fluid f;
        PipeReactions r;
        World world = evt.world;
        int x = evt.x;
        int y = evt.y;
        int z = evt.z;
        FluidStack liq = evt.fluid;
        if (liq != null && (r = this.getReaction(f = liq.getFluid(), world, x, y, z)) != null) {
            BlockArray blocks = new BlockArray();
            blocks.recursiveAddWithMetadata((IBlockAccess)world, x, y, z, world.func_147439_a(x, y, z), world.func_72805_g(x, y, z));
            for (int i = 0; i < blocks.getSize(); ++i) {
                Coordinate c = blocks.getNthBlock(i);
                r.doEffect(world, c);
            }
        }
    }

    public boolean isCorrosive(Fluid f) {
        return f == ReactorCraft.UF6 || f == ReactorCraft.HF || f == ReactorCraft.CL;
    }

    public boolean isCorrodable(World world, int x, int y, int z) {
        BCPipeHandler.Materials type;
        Block id = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        MachineRegistry m = MachineRegistry.getMachine((IBlockAccess)world, (int)x, (int)y, (int)z);
        if (m == MachineRegistry.PIPE) {
            return true;
        }
        if (id == BCPipeHandler.getInstance().pipeID && ((type = BCPipeHandler.getInstance().getPipeType(world.func_147438_o(x, y, z))) == BCPipeHandler.Materials.GOLD || type == BCPipeHandler.Materials.IRON)) {
            return true;
        }
        return ThermalDuctHandler.getInstance().isDuct(id);
    }

    public boolean isExplodable(World world, int x, int y, int z) {
        BCPipeHandler.Materials type;
        Block id = world.func_147439_a(x, y, z);
        return id == BCPipeHandler.getInstance().pipeID && ((type = BCPipeHandler.getInstance().getPipeType(world.func_147438_o(x, y, z))) == BCPipeHandler.Materials.DIAMOND || type == BCPipeHandler.Materials.EMERALD);
    }

    private PipeReactions getReaction(Fluid f, World world, int x, int y, int z) {
        if (f == null) {
            return null;
        }
        if (f == ReactorCraft.PLASMA) {
            return world.func_147438_o(x, y, z) instanceof TileEntityReactorBase ? null : PipeReactions.MELT;
        }
        if (this.isCorrosive(f) && this.isCorrodable(world, x, y, z)) {
            return PipeReactions.CORRODE;
        }
        if (this.isCorrosive(f) && this.isExplodable(world, x, y, z)) {
            return PipeReactions.EXPLODE;
        }
        return null;
    }

    private static enum PipeReactions {
        MELT,
        CORRODE,
        EXPLODE,
        FIREEXPLODE;


        private void doEffect(World world, Coordinate c) {
            switch (this) {
                case MELT: {
                    ReikaSoundHelper.playSoundAtBlock((World)world, (int)c.xCoord, (int)c.yCoord, (int)c.zCoord, (String)"random.fizz", (float)0.4f, (float)1.0f);
                    ReikaParticleHelper.LAVA.spawnAroundBlock(world, c.xCoord, c.yCoord, c.zCoord, 36);
                    c.setBlock(world, (Block)Blocks.field_150356_k);
                    int r = 4;
                    for (int dx = c.xCoord - r; dx <= c.xCoord + r; ++dx) {
                        for (int dy = c.yCoord - r; dy <= c.yCoord + r; ++dy) {
                            for (int dz = c.zCoord - r; dz <= c.zCoord + r; ++dz) {
                                ReikaWorldHelper.temperatureEnvironment((World)world, (int)c.xCoord, (int)c.yCoord, (int)c.zCoord, (int)150000000);
                            }
                        }
                    }
                    break;
                }
                case CORRODE: {
                    ReikaSoundHelper.playSoundAtBlock((World)world, (int)c.xCoord, (int)c.yCoord, (int)c.zCoord, (String)"random.fizz", (float)0.4f, (float)1.0f);
                    ReikaParticleHelper.SMOKE.spawnAroundBlock(world, c.xCoord, c.yCoord, c.zCoord, 6);
                    c.setBlock(world, Blocks.field_150350_a);
                    break;
                }
                case EXPLODE: 
                case FIREEXPLODE: {
                    c.setBlock(world, Blocks.field_150350_a);
                    world.func_72885_a(null, (double)c.xCoord + 0.5, (double)c.yCoord + 0.5, (double)c.zCoord + 0.5, 2.0f, true, this == FIREEXPLODE);
                }
            }
        }
    }
}

