/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.TileEntities.Fission.Breeder;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.ReactorCraft.Base.TileEntityNuclearCore;
import Reika.ReactorCraft.Entities.EntityNeutron;
import Reika.ReactorCraft.Registry.ReactorAchievements;
import Reika.ReactorCraft.Registry.ReactorItems;
import Reika.ReactorCraft.Registry.ReactorTiles;
import Reika.ReactorCraft.Registry.ReactorType;
import Reika.ReactorCraft.TileEntities.Fission.Breeder.TileEntitySodiumHeater;
import Reika.ReactorCraft.TileEntities.Fission.TileEntityWaterCell;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityBreederCore
extends TileEntityNuclearCore {
    private StepTimer timer2 = new StepTimer(10);

    @Override
    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateEntity(world, x, y, z, meta);
        if (DragonAPICore.debugtest) {
            ReikaInventoryHelper.clearInventory((IInventory)this);
            ReikaInventoryHelper.addToIInv((ItemStack)ReactorItems.BREEDERFUEL.getStackOf(), (IInventory)this);
        }
        this.timer2.update();
        if (this.timer2.checkCap()) {
            for (int i = 2; i < 6; ++i) {
                TileEntitySodiumHeater te;
                int dTemp;
                ForgeDirection dir = this.dirs[i];
                int dx = x + dir.offsetX;
                int dy = y + dir.offsetY;
                int dz = z + dir.offsetZ;
                ReactorTiles r = ReactorTiles.getTE((IBlockAccess)world, dx, dy, dz);
                if (r != ReactorTiles.SODIUMBOILER || (dTemp = this.temperature - (te = (TileEntitySodiumHeater)world.func_147438_o(dx, dy, dz)).getTemperature()) <= 0) continue;
                this.temperature -= dTemp / 16;
                te.setTemperature(te.getTemperature() + dTemp / 16);
            }
        }
    }

    @Override
    public boolean isFissile() {
        return ReikaInventoryHelper.locateInInventory((Item)ReactorItems.BREEDERFUEL.getItemInstance(), (ItemStack[])this.inv) != -1;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        if (this.inv[i] != null) {
            return false;
        }
        if (itemstack.func_77973_b() == ReactorItems.BREEDERFUEL.getItemInstance()) {
            return i < 4;
        }
        if (itemstack.func_77973_b() == ReactorItems.PLUTONIUM.getItemInstance()) {
            return i < 4;
        }
        return false;
    }

    @Override
    public int getMaxTemperature() {
        return 900;
    }

    @Override
    public boolean onNeutron(EntityNeutron e, World world, int x, int y, int z) {
        super.onNeutron(e, world, x, y, z);
        if (!world.field_72995_K) {
            int slot;
            if (this.checkPoisonedChance()) {
                return true;
            }
            if (ReikaRandomHelper.doWithChance((double)(25 + this.temperature / 100)) && this.isFissile() && ReikaRandomHelper.doWithChance((double)e.getNeutronSpeed().getInteractionMultiplier()) && (slot = ReikaInventoryHelper.locateInInventory((Item)ReactorItems.BREEDERFUEL.getItemInstance(), (ItemStack[])this.inv)) != -1) {
                if (e.getType().canTriggerFuelConversion() && ReikaRandomHelper.doWithChance((double)(5.0f * e.getNeutronSpeed().getWasteConversionMultiplier()))) {
                    int dmg = this.inv[slot].func_77960_j();
                    if (dmg == ReactorItems.BREEDERFUEL.getNumberMetadatas() - 1) {
                        this.inv[slot] = ReactorItems.PLUTONIUM.getStackOf();
                        this.tryPushSpentFuel(slot);
                        ReactorAchievements.PLUTONIUM.triggerAchievement(this.getPlacer());
                    } else {
                        this.inv[slot] = ReactorItems.BREEDERFUEL.getStackOfMetadata(dmg + 1);
                    }
                    this.temperature += 50;
                } else {
                    this.temperature += this.temperature >= 700 ? 30 : 20;
                }
                this.spawnNeutronBurst(world, x, y, z);
                if (ReikaRandomHelper.doWithChance((double)10.0)) {
                    this.addWaste();
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canRemoveItem(int slot, ItemStack is) {
        if (is.func_77973_b() == ReactorItems.PLUTONIUM.getItemInstance()) {
            return true;
        }
        return is.func_77973_b() == ReactorItems.WASTE.getItemInstance();
    }

    @Override
    public ReactorTiles getTile() {
        return ReactorTiles.BREEDER;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public boolean canDumpHeatInto(TileEntityWaterCell.LiquidStates liq) {
        return liq == TileEntityWaterCell.LiquidStates.SODIUM;
    }

    @Override
    public ReactorType getReactorType() {
        return ReactorType.BREEDER;
    }
}

