/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.TileEntities.Fission;

import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.ReactorCraft.Base.TileEntityNuclearCore;
import Reika.ReactorCraft.Entities.EntityNeutron;
import Reika.ReactorCraft.Registry.ReactorAchievements;
import Reika.ReactorCraft.Registry.ReactorFuel;
import Reika.ReactorCraft.Registry.ReactorItems;
import Reika.ReactorCraft.Registry.ReactorTiles;
import Reika.ReactorCraft.Registry.ReactorType;
import Reika.ReactorCraft.TileEntities.Fission.TileEntityWaterCell;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class TileEntityFuelRod
extends TileEntityNuclearCore {
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public ReactorTiles getTile() {
        return ReactorTiles.FUEL;
    }

    public boolean func_94041_b(int i, ItemStack is) {
        if (this.inv[i] != null) {
            return false;
        }
        if (this.isFuel(is)) {
            return i < 4;
        }
        if (is.func_77973_b() == ReactorItems.DEPLETED.getItemInstance()) {
            return i < 4;
        }
        return false;
    }

    private boolean isFuel(ItemStack is) {
        if (is.func_77973_b() == ReactorItems.FUEL.getItemInstance()) {
            return true;
        }
        return is.func_77973_b() == ReactorItems.PLUTONIUM.getItemInstance();
    }

    @Override
    public boolean canRemoveItem(int i, ItemStack is) {
        if (is.func_77973_b() == ReactorItems.WASTE.getItemInstance()) {
            return true;
        }
        return is.func_77973_b() == ReactorItems.DEPLETED.getItemInstance();
    }

    private ReactorFuel getFuel() {
        return ReactorFuel.getFrom(this.inv[3]);
    }

    @Override
    public boolean onNeutron(EntityNeutron e, World world, int x, int y, int z) {
        super.onNeutron(e, world, x, y, z);
        if (!world.field_72995_K && e.getType().canTriggerFission() && ReikaRandomHelper.doWithChance((double)e.getNeutronSpeed().getInteractionMultiplier())) {
            if (this.checkPoisonedChance()) {
                return true;
            }
            if (this.isFissile()) {
                ReactorFuel f = this.getFuel();
                if (ReikaRandomHelper.doWithChance((double)((float)f.fissionChance + f.voidCoefficient * (float)(this.temperature - 100)))) {
                    ReactorAchievements.FISSION.triggerAchievement(this.getPlacer());
                    if (ReikaRandomHelper.doWithChance((double)f.consumeChance)) {
                        ItemStack is = this.inv[3];
                        this.inv[3] = f.getFissionProduct(is);
                        if (this.inv[3] != null && this.inv[3].func_77973_b() != is.func_77973_b()) {
                            this.tryPushSpentFuel(3);
                        }
                        if (ReikaRandomHelper.doWithChance((double)f.wasteChance)) {
                            this.addWaste();
                        }
                    }
                    this.spawnNeutronBurst(world, x, y, z);
                    this.temperature += f.temperatureStep;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean isFissile() {
        return this.getFuel() != null;
    }

    @Override
    public boolean canDumpHeatInto(TileEntityWaterCell.LiquidStates liq) {
        return liq.isWater();
    }

    @Override
    public ReactorType getReactorType() {
        return ReactorType.FISSION;
    }
}

