/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.TileEntities.PowerGen;

import Reika.DragonAPI.Instantiable.HybridTank;
import Reika.DragonAPI.Libraries.ReikaFluidHelper;
import Reika.ReactorCraft.Base.TankedReactorPowerReceiver;
import Reika.ReactorCraft.Registry.ReactorTiles;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.TileEntities.Piping.TileEntityPipe;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityReactorPump
extends TankedReactorPowerReceiver {
    public static final long MINPOWER = 16384L;
    public static final int MINTORQUE = 1024;
    private final HybridTank output = new HybridTank("pumpout", this.getCapacity());

    @Override
    public ReactorTiles getTile() {
        return ReactorTiles.PUMP;
    }

    @Override
    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateEntity(world, x, y, z, meta);
        if (this.canConvert()) {
            this.convertFluids();
        }
        if (!this.output.isEmpty()) {
            this.dumpFluids(world, x, y, z);
        }
    }

    private boolean canConvert() {
        if (!this.sufficientPower()) {
            return false;
        }
        if (this.tank.isEmpty()) {
            return false;
        }
        if (this.output.isEmpty()) {
            return true;
        }
        if (this.output.isFull()) {
            return false;
        }
        if (this.tank.getActualFluid().equals(FluidRegistry.getFluid((String)"rc lowpwater"))) {
            return this.output.getActualFluid().equals(FluidRegistry.WATER);
        }
        if (this.tank.getActualFluid().equals(FluidRegistry.getFluid((String)"rc lowpammonia"))) {
            return this.output.getActualFluid().equals(FluidRegistry.getFluid((String)"rc ammonia"));
        }
        return false;
    }

    private void dumpFluids(World world, int x, int y, int z) {
        for (int i = 2; i < 6; ++i) {
            int amt;
            IFluidHandler fl;
            ForgeDirection dir = this.dirs[i];
            TileEntity te = this.getAdjacentTileEntity(dir);
            if (te instanceof TileEntityPipe) {
                int dL;
                TileEntityPipe p = (TileEntityPipe)te;
                if (!p.canIntakeFluid(this.output.getActualFluid()) || (dL = this.output.getLevel() - p.getFluidLevel()) / 4 <= 0) continue;
                p.addFluid(dL / 4);
                p.setFluid(this.output.getActualFluid());
                this.output.removeLiquid(dL / 4);
                continue;
            }
            if (!(te instanceof IFluidHandler) || !(fl = (IFluidHandler)te).canFill(dir.getOpposite(), this.output.getActualFluid()) || (amt = fl.fill(dir.getOpposite(), this.output.getFluid(), true)) <= 0) continue;
            this.output.removeLiquid(amt);
        }
    }

    private void convertFluids() {
        int amt = Math.min(this.tank.getLevel(), this.output.getRemainingSpace());
        if (amt <= 0) {
            return;
        }
        if (this.tank.getActualFluid().equals(FluidRegistry.getFluid((String)"rc lowpwater"))) {
            this.output.addLiquid(amt, FluidRegistry.WATER);
        } else if (this.tank.getActualFluid().equals(FluidRegistry.getFluid((String)"rc lowpammonia"))) {
            this.output.addLiquid(amt, FluidRegistry.getFluid((String)"rc ammonia"));
        }
        this.tank.removeLiquid(amt);
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
        super.animateWithTick(world, x, y, z);
        if (this.getPower() > 0L) {
            this.phi += 15.0f;
        }
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.output.readFromNBT(NBT);
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        this.output.writeToNBT(NBT);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.canDrain(from, resource.getFluid()) ? this.output.drain(resource.amount, doDrain) : null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.canDrain(from, null) ? this.output.drain(maxDrain, doDrain) : null;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return from.offsetY == 0 && ReikaFluidHelper.isFluidDrainableFromTank((Fluid)fluid, (HybridTank)this.tank);
    }

    public boolean canConnectToPipe(MachineRegistry m) {
        return m.isStandardPipe();
    }

    @Override
    public boolean canConnectToPipeOnSide(MachineRegistry p, ForgeDirection side) {
        return side != ForgeDirection.DOWN && this.canConnectToPipe(p);
    }

    @Override
    public int getCapacity() {
        return 12000;
    }

    @Override
    public boolean canReceiveFrom(ForgeDirection from) {
        return from == ForgeDirection.UP;
    }

    @Override
    public Fluid getInputFluid() {
        return null;
    }

    @Override
    public boolean isValidFluid(Fluid f) {
        if (f.equals(FluidRegistry.getFluid((String)"rc lowpwater"))) {
            return true;
        }
        return f.equals(FluidRegistry.getFluid((String)"rc lowpammonia"));
    }

    public boolean canReadFrom(ForgeDirection dir) {
        return dir == ForgeDirection.DOWN;
    }

    @Override
    public IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType type, ForgeDirection side) {
        return type == IPipeTile.PipeType.FLUID ? (side != ForgeDirection.DOWN ? IPipeConnection.ConnectOverride.CONNECT : IPipeConnection.ConnectOverride.DISCONNECT) : IPipeConnection.ConnectOverride.DEFAULT;
    }

    public int getMinTorque(int available) {
        return 1024;
    }

    @Override
    public int getMinTorque() {
        return 1024;
    }

    @Override
    public int getMinSpeed() {
        return 1;
    }

    @Override
    public long getMinPower() {
        return 16384L;
    }
}

