/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.TileEntities.Processing;

import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.Isotopes;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.ModRegistry.ModOreList;
import Reika.ReactorCraft.Auxiliary.ReactorCoreTE;
import Reika.ReactorCraft.Base.TileEntityInventoriedReactorBase;
import Reika.ReactorCraft.Base.TileEntityWasteUnit;
import Reika.ReactorCraft.Entities.EntityNeutron;
import Reika.ReactorCraft.Registry.ReactorItems;
import Reika.ReactorCraft.Registry.ReactorTiles;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityWasteDecayer
extends TileEntityInventoriedReactorBase
implements ReactorCoreTE {
    public static final int BASE_TEMP = 150;
    public static final int OPTIMAL_TEMP = 400;

    @Override
    public ReactorTiles getTile() {
        return ReactorTiles.WASTEDECAYER;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        if (!world.field_72995_K) {
            this.feed();
        }
        this.thermalTicker.update();
        if (this.thermalTicker.checkCap()) {
            this.updateTemperature(world, x, y, z);
        }
    }

    private boolean feed() {
        World world = this.field_145850_b;
        int x = this.field_145851_c;
        int y = this.field_145848_d;
        int z = this.field_145849_e;
        Block id = world.func_147439_a(x, y - 1, z);
        int meta = world.func_72805_g(x, y - 1, z);
        TileEntity tile = this.getAdjacentTileEntity(ForgeDirection.DOWN);
        if (tile instanceof TileEntityWasteDecayer && ((TileEntityWasteDecayer)tile).feedIn(this.inv[this.inv.length - 1])) {
            for (int i = this.inv.length - 1; i > 0; --i) {
                this.inv[i] = this.inv[i - 1];
            }
            id = world.func_147439_a(x, y + 1, z);
            meta = world.func_72805_g(x, y + 1, z);
            tile = this.getAdjacentTileEntity(ForgeDirection.UP);
            this.inv[0] = tile instanceof TileEntityWasteDecayer ? ((TileEntityWasteDecayer)tile).feedOut() : null;
        }
        this.collapseInventory();
        return false;
    }

    private void collapseInventory() {
        for (int i = 0; i < this.inv.length; ++i) {
            for (int k = this.inv.length - 1; k > 0; --k) {
                if (this.inv[k] == null && this.inv[k - 1] != null) {
                    this.inv[k] = this.inv[k - 1];
                    this.inv[k - 1] = null;
                    return;
                }
                if (!ReikaItemHelper.areStacksCombinable((ItemStack)this.inv[k], (ItemStack)this.inv[k - 1], (int)Integer.MAX_VALUE) || this.inv[k].field_77994_a >= Math.min(this.inv[k].func_77976_d(), this.func_70297_j_())) continue;
                ++this.inv[k].field_77994_a;
                ReikaInventoryHelper.decrStack((int)(k - 1), (ItemStack[])this.inv);
                return;
            }
        }
    }

    private boolean feedIn(ItemStack is) {
        if (is == null) {
            return true;
        }
        if (!this.func_94041_b(0, is)) {
            return false;
        }
        if (this.inv[0] == null) {
            this.inv[0] = is.func_77946_l();
            return true;
        }
        return false;
    }

    private ItemStack feedOut() {
        if (this.inv[this.inv.length - 1] == null) {
            return null;
        }
        ItemStack is = this.inv[this.inv.length - 1].func_77946_l();
        this.inv[this.inv.length - 1] = null;
        return is;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
    }

    @Override
    public boolean onNeutron(EntityNeutron e, World world, int x, int y, int z) {
        EntityNeutron.NeutronType type = e.getType();
        if (!world.field_72995_K && type.canIrradiateMaterials() && ReikaRandomHelper.doWithChance((double)50.0)) {
            if (ReikaRandomHelper.doWithChance((double)(this.getDecayChance() * (double)e.getNeutronSpeed().getWasteConversionMultiplier()))) {
                this.tryDecay();
            }
            return true;
        }
        return false;
    }

    private double getDecayChance() {
        return this.temperature < 150 ? ReikaMathLibrary.linterpolate((double)this.temperature, (double)20.0, (double)150.0, (double)0.0, (double)5.0) : ReikaMathLibrary.linterpolate((double)this.temperature, (double)150.0, (double)400.0, (double)5.0, (double)25.0);
    }

    private boolean tryDecay() {
        for (int i = 0; i < this.inv.length; ++i) {
            ItemStack is = this.inv[i];
            if (is == null || !TileEntityWasteUnit.isLongLivedWaste(is) || !this.tryDecay(i, is)) continue;
            return true;
        }
        return false;
    }

    private boolean tryDecay(int i, ItemStack is) {
        Isotopes.DecayData split = Isotopes.getIsotope((int)is.func_77960_j()).getDecay();
        if (split == null) {
            ReikaInventoryHelper.decrStack((int)i, (ItemStack[])this.inv);
            return true;
        }
        int amt = MathHelper.func_76128_c((double)split.amount);
        if (ReikaRandomHelper.doWithChance((double)(split.amount - (double)amt))) {
            ++amt;
        }
        if (amt == 0) {
            return false;
        }
        ItemStack add = this.getItem(split, amt);
        if (add == null) {
            return true;
        }
        if (ReikaInventoryHelper.addToIInv((ItemStack)add, (IInventory)this)) {
            ReikaInventoryHelper.decrStack((int)i, (ItemStack[])this.inv);
            return true;
        }
        return false;
    }

    private ItemStack getItem(Isotopes.DecayData split, int amt) {
        if (split.isotope.getChemicalSymbol().equalsIgnoreCase("pb")) {
            return ModOreList.LEAD.existsInGame() ? ModOreList.LEAD.getFirstProduct() : null;
        }
        if (split.isotope instanceof Isotopes) {
            return new ItemStack(ReactorItems.WASTE.getItemInstance(), amt, ((Isotopes)split.isotope).ordinal());
        }
        return null;
    }

    @Override
    public final int getTextureState(ForgeDirection side) {
        if (side.offsetY != 0) {
            return 4;
        }
        World world = this.field_145850_b;
        int x = this.field_145851_c;
        int y = this.field_145848_d;
        int z = this.field_145849_e;
        ReactorTiles src = this.getTile();
        ReactorTiles r = ReactorTiles.getTE((IBlockAccess)world, x, y - 1, z);
        ReactorTiles r2 = ReactorTiles.getTE((IBlockAccess)world, x, y + 1, z);
        if (r2 == src && r == src) {
            return 2;
        }
        if (r2 == src) {
            return 1;
        }
        if (r == src) {
            return 3;
        }
        return 0;
    }

    public int func_70302_i_() {
        return 15;
    }

    public boolean func_94041_b(int slot, ItemStack is) {
        return ReactorItems.WASTE.matchWith(is);
    }

    @Override
    public boolean canItemEnterFromSide(ForgeDirection dir) {
        return dir == ForgeDirection.UP;
    }

    @Override
    public boolean canItemExitToSide(ForgeDirection dir) {
        return dir == ForgeDirection.DOWN;
    }

    @Override
    public boolean canRemoveItem(int slot, ItemStack is) {
        return !TileEntityWasteUnit.isLongLivedWaste(is);
    }

    @Override
    public int func_70297_j_() {
        return 8;
    }
}

