/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.TileEntities;

import Reika.ChromatiCraft.API.Interfaces.WorldRift;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaParticleHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.ReactorCraft.Auxiliary.NeutronTile;
import Reika.ReactorCraft.Base.TileEntityReactorPiping;
import Reika.ReactorCraft.Blocks.BlockDuct;
import Reika.ReactorCraft.Entities.EntityNeutron;
import Reika.ReactorCraft.ReactorCraft;
import Reika.ReactorCraft.Registry.ReactorAchievements;
import Reika.ReactorCraft.Registry.ReactorTiles;
import Reika.ReactorCraft.TileEntities.Fusion.TileEntityFusionHeater;
import Reika.ReactorCraft.TileEntities.Fusion.TileEntityFusionInjector;
import Reika.RotaryCraft.API.Interfaces.Shockable;
import Reika.RotaryCraft.Entities.EntityDischarge;
import Reika.RotaryCraft.Registry.BlockRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class TileEntityMagneticPipe
extends TileEntityReactorPiping
implements Shockable,
NeutronTile {
    private int charge;
    private StepTimer chargeTimer = new StepTimer(20);

    @Override
    public ReactorTiles getTile() {
        return ReactorTiles.MAGNETPIPE;
    }

    public IIcon getBlockIcon() {
        return this.charge > 0 ? BlockDuct.getGlow() : Blocks.field_150340_R.func_149691_a(0, 0);
    }

    public Block getPipeBlockType() {
        return Blocks.field_150340_R;
    }

    public boolean isConnectedToNonSelf(ForgeDirection dir) {
        return false;
    }

    @Override
    public boolean isValidFluid(Fluid f) {
        return f != null && f.equals(FluidRegistry.getFluid((String)"rc fusion plasma"));
    }

    @Override
    protected void onIntake(TileEntity te) {
    }

    public IIcon getGlassIcon() {
        return BlockRegistry.BLASTPANE.getBlockInstance().func_149691_a(0, 0);
    }

    @Override
    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateEntity(world, x, y, z, meta);
        this.distributeCharge(world, x, y, z);
        this.updateCharge(world, x, y, z);
        if (this.charge <= 0 && !world.field_72995_K) {
            ReactorCraft.logger.debug((Object)("Melting magnetic pipe " + this + " with charge " + this.charge));
            this.charge = 0;
            if (this.fluid != null && this.fluid.getTemperature(world, x, y, z) > 5000) {
                world.func_147449_b(x, y, z, (Block)Blocks.field_150356_k);
                ReikaSoundHelper.playSoundAtBlock((World)world, (int)x, (int)y, (int)z, (String)"random.fizz");
                ReikaParticleHelper.LAVA.spawnAroundBlock(world, x, y, z, 5);
                ReactorAchievements.MELTPIPE.triggerAchievement(this.getPlacer());
            }
        }
    }

    private void distributeCharge(World world, int x, int y, int z) {
        for (int i = 0; i < 6; ++i) {
            ReactorTiles r;
            WorldLocation loc;
            ForgeDirection dir = this.dirs[i];
            int dx = x + dir.offsetX;
            int dy = y + dir.offsetY;
            int dz = z + dir.offsetZ;
            TileEntity te = world.func_147438_o(dx, dy, dz);
            if (te instanceof WorldRift && (loc = ((WorldRift)te).getLinkTarget()) != null) {
                if ((te = ((WorldRift)te).getTileEntityFrom(dir)) == null) continue;
                dx = te.field_145851_c;
                dy = te.field_145848_d;
                dz = te.field_145849_e;
                world = te.field_145850_b;
            }
            if ((r = ReactorTiles.getTE((IBlockAccess)world, dx, dy, dz)) != ReactorTiles.MAGNETPIPE) continue;
            TileEntityMagneticPipe tile = (TileEntityMagneticPipe)world.func_147438_o(dx, dy, dz);
            int dq = this.charge - tile.charge;
            if (dq <= 0) continue;
            tile.charge += dq / 4;
            this.charge -= dq / 4;
        }
    }

    private void updateCharge(World world, int x, int y, int z) {
        ForgeDirection dir = ReikaWorldHelper.checkForAdjMaterial((World)world, (int)x, (int)y, (int)z, (Material)Material.field_151586_h);
        if (dir != null) {
            EntityDischarge e = new EntityDischarge(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, this.charge, (double)x + 0.5 + (double)dir.offsetX, (double)y + 0.5 + (double)dir.offsetY, (double)z + 0.5 + (double)dir.offsetZ);
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)e);
            }
            this.charge = 0;
        } else {
            this.charge = this.charge > 1 ? (int)((double)this.charge * 0.99) : 0;
        }
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("chg", this.charge);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.charge = NBT.func_74762_e("chg");
    }

    public void onDischarge(int charge, double range) {
        this.charge = (int)((double)this.charge + Math.pow(charge, 1.1));
    }

    public int getMinDischarge() {
        return 256;
    }

    public float getAimX() {
        return 0.5f;
    }

    public float getAimY() {
        return 0.5f;
    }

    public float getAimZ() {
        return 0.5f;
    }

    @Override
    public IIcon getOverlayIcon() {
        return null;
    }

    public int getCharge() {
        return this.charge;
    }

    private boolean isPlasmaAcceptingBlock(TileEntity te) {
        return te instanceof TileEntityMagneticPipe || te instanceof TileEntityFusionHeater || te instanceof TileEntityFusionInjector;
    }

    @Override
    protected boolean isInteractableTile(TileEntity te) {
        return (te instanceof WorldRift || this.isPlasmaAcceptingBlock(te)) && super.isInteractableTile(te);
    }

    public boolean canDischargeLongRange() {
        return true;
    }

    @Override
    public boolean onNeutron(EntityNeutron e, World world, int x, int y, int z) {
        return false;
    }
}

