/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.TileEntities.Waste;

import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.MathSci.Isotopes;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaParticleHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.ReactorCraft.Auxiliary.Feedable;
import Reika.ReactorCraft.Auxiliary.RadiationEffects;
import Reika.ReactorCraft.Base.TileEntityWasteUnit;
import Reika.ReactorCraft.Registry.ReactorAchievements;
import Reika.ReactorCraft.Registry.ReactorTiles;
import Reika.RotaryCraft.Auxiliary.Interfaces.RangedEffect;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityWasteStorage
extends TileEntityWasteUnit
implements RangedEffect,
Feedable {
    public int func_70302_i_() {
        return 12;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        if (rand.nextInt(20) == 0) {
            this.sickenMobs(world, x, y, z);
        }
        if (!world.field_72995_K) {
            this.decayWaste();
            this.feed();
        }
        if ((world.field_73011_w.field_76575_d || ReikaWorldHelper.getAmbientTemperatureAt((World)world, (int)x, (int)y, (int)z) > 100) && this.hasWaste()) {
            ReikaParticleHelper.SMOKE.spawnAroundBlock(world, x, y, z, 3);
            if (rand.nextInt(4) == 0) {
                ReikaSoundHelper.playSoundAtBlock((World)world, (int)x, (int)y, (int)z, (String)"random.fizz");
            }
            if (rand.nextInt(200) == 0) {
                world.func_147468_f(x, y, z);
                world.func_72885_a(null, (double)x + 0.5, (double)y + 0.5, (double)y + 0.5, 4.0f, true, true);
            }
        }
    }

    @Override
    protected boolean accountForOutGameTime() {
        return true;
    }

    @Override
    protected void onDecayWaste(int i) {
        super.onDecayWaste(i);
        if (ReikaInventoryHelper.isEmpty((IInventory)this)) {
            ReactorAchievements.DECAY.triggerAchievement(this.getPlacer());
        }
    }

    private void sickenMobs(World world, int x, int y, int z) {
        int r = this.getRange();
        AxisAlignedBB box = ReikaAABBHelper.getBlockAABB((int)x, (int)y, (int)z).func_72314_b((double)r, (double)r, (double)r);
        List li = world.func_72872_a(EntityLivingBase.class, box);
        for (EntityLivingBase e : li) {
            double dd;
            if (RadiationEffects.RadiationIntensity.MODERATE.hasSufficientShielding(e) || !ReikaWorldHelper.canBlockSee((World)world, (int)x, (int)y, (int)z, (double)e.field_70165_t, (double)e.field_70163_u, (double)e.field_70161_v, (double)(dd = ReikaMathLibrary.py3d((double)(e.field_70165_t - (double)x - 0.5), (double)(e.field_70163_u - (double)y - 0.5), (double)(e.field_70161_v - (double)z - 0.5))))) continue;
            RadiationEffects.instance.applyEffects(e, RadiationEffects.RadiationIntensity.MODERATE);
        }
    }

    @Override
    protected boolean isValidSlot(int i, ItemStack is) {
        return this.isAppropriateWasteSlot(is, i);
    }

    private boolean isAppropriateWasteSlot(ItemStack is, int slot) {
        for (int i = 0; i < this.inv.length; ++i) {
            ItemStack in = this.inv[i];
            if (!ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)in) || in.field_77994_a + is.field_77994_a > Math.min(this.func_70297_j_(), is.func_77976_d())) continue;
            return i == slot;
        }
        return this.inv[slot] == null;
    }

    @Override
    public ReactorTiles getTile() {
        return ReactorTiles.STORAGE;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public boolean leaksRadiation() {
        return false;
    }

    @Override
    public boolean canRemoveItem(int slot, ItemStack is) {
        return false;
    }

    @Override
    public boolean isValidIsotope(Isotopes i) {
        return TileEntityWasteStorage.isLongLivedWaste(i);
    }

    public int getRange() {
        int amt = this.countWaste();
        return this.getRangeFromWasteCount(amt);
    }

    public int getMaxRange() {
        int amt = this.func_70302_i_();
        return this.getRangeFromWasteCount(amt);
    }

    public int getRangeFromWasteCount(int amt) {
        return (int)Math.sqrt(amt);
    }

    @Override
    public final int func_70297_j_() {
        return 16;
    }

    @Override
    public boolean feed() {
        World world = this.field_145850_b;
        int x = this.field_145851_c;
        int y = this.field_145848_d;
        int z = this.field_145849_e;
        Block id = world.func_147439_a(x, y - 1, z);
        int meta = world.func_72805_g(x, y - 1, z);
        TileEntity tile = this.getAdjacentTileEntity(ForgeDirection.DOWN);
        if (tile instanceof TileEntityWasteStorage && ((Feedable)tile).feedIn(this.inv[this.inv.length - 1])) {
            for (int i = this.inv.length - 1; i > 0; --i) {
                this.inv[i] = this.inv[i - 1];
            }
            id = world.func_147439_a(x, y + 1, z);
            meta = world.func_72805_g(x, y + 1, z);
            tile = this.getAdjacentTileEntity(ForgeDirection.UP);
            this.inv[0] = tile instanceof TileEntityWasteStorage ? ((Feedable)tile).feedOut() : null;
        }
        this.collapseInventory();
        return false;
    }

    private void collapseInventory() {
        for (int i = 0; i < this.inv.length; ++i) {
            for (int k = this.inv.length - 1; k > 0; --k) {
                if (this.inv[k - 1] == null) continue;
                if (this.inv[k] == null) {
                    this.inv[k] = this.inv[k - 1];
                    this.inv[k - 1] = null;
                    continue;
                }
                if (!ReikaItemHelper.matchStacks((ItemStack)this.inv[k], (ItemStack)this.inv[k - 1]) || !ItemStack.func_77970_a((ItemStack)this.inv[k], (ItemStack)this.inv[k - 1]) || this.inv[k].field_77994_a + this.inv[k - 1].field_77994_a > Math.min(this.func_70297_j_(), this.inv[k].func_77976_d())) continue;
                this.inv[k].field_77994_a += this.inv[k - 1].field_77994_a;
                this.inv[k - 1] = null;
            }
        }
    }

    @Override
    public boolean feedIn(ItemStack is) {
        if (is == null) {
            return true;
        }
        if (!this.func_94041_b(0, is)) {
            return false;
        }
        if (this.inv[0] == null) {
            this.inv[0] = is.func_77946_l();
            return true;
        }
        return false;
    }

    @Override
    public ItemStack feedOut() {
        if (this.inv[this.inv.length - 1] == null) {
            return null;
        }
        ItemStack is = this.inv[this.inv.length - 1].func_77946_l();
        this.inv[this.inv.length - 1] = null;
        return is;
    }

    @Override
    protected boolean canBeAccelerated() {
        return true;
    }

    @Override
    protected double getBaseDecayRate() {
        return 1.75;
    }
}

