/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.World;

import Reika.DragonAPI.Interfaces.OreGenerator;
import Reika.DragonAPI.Interfaces.Registry.OreEnum;
import Reika.ReactorCraft.Registry.FluoriteTypes;
import Reika.ReactorCraft.Registry.ReactorOptions;
import Reika.ReactorCraft.Registry.ReactorOres;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenMinable;

public class BasicReactorOreGenerator
implements OreGenerator {
    public void generateOre(OreEnum ore, Random random, World world, int chunkX, int chunkZ) {
        ReactorOres r = (ReactorOres)ore;
        if (random.nextInt(ReactorOptions.DISCRETE.getValue()) == 0) {
            this.generate(r, world, random, chunkX * 16, chunkZ * 16);
        }
    }

    private void generate(ReactorOres ore, World world, Random random, int chunkX, int chunkZ) {
        Block id = ore.getBlock();
        int meta = ore.getBlockMetadata();
        int passes = ore.perChunk * ReactorOptions.DISCRETE.getValue() / this.getGenerationFactor(ore);
        if (ore == ReactorOres.FLUORITE) {
            meta = FluoriteTypes.getRandomColor().ordinal();
            if (ReactorOptions.RAINBOW.getState()) {
                passes = (int)((float)passes / 4.0f);
                meta = 0;
            }
        }
        for (int i = 0; i < passes; ++i) {
            int size;
            int posX = chunkX + random.nextInt(16);
            int posZ = chunkZ + random.nextInt(16);
            int posY = ore.minY + random.nextInt(ore.maxY - ore.minY + 1);
            if (!ore.canGenAt(world, posX, posY, posZ) || new WorldGenMinable(id, meta, size = ore.veinSize * this.getVeinSizeFactor(ore), ore.getReplaceableBlock()).func_76484_a(world, random, posX, posY, posZ)) {
                // empty if block
            }
            if (ore != ReactorOres.FLUORITE) continue;
            int r = 3;
            for (int k = -r; k <= r; ++k) {
                for (int l = -r; l <= r; ++l) {
                    for (int m = -r; m <= r; ++m) {
                        world.func_147479_m(posX, posY, posZ);
                    }
                }
            }
        }
    }

    protected int getVeinSizeFactor(ReactorOres ore) {
        return 1;
    }

    protected int getGenerationFactor(ReactorOres ore) {
        return 1;
    }
}

