/*
 * Decompiled with CFR 0.152.
 */
package Reika.ElectriCraft.TileEntities.ModInterface;

import Reika.DragonAPI.ASM.APIStripper;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.IC2Handler;
import Reika.DragonAPI.ModInteract.Power.ReikaEUHelper;
import Reika.DragonAPI.ModList;
import Reika.ElectriCraft.Base.ElectriTileEntity;
import Reika.ElectriCraft.Registry.ElectriTiles;
import Reika.RotaryCraft.API.Interfaces.Screwdriverable;
import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

@APIStripper.Strippable(value={"ic2.api.energy.tile.IEnergySink", "ic2.api.energy.tile.IEnergySource"})
public class TileEntityEUSplitter
extends ElectriTileEntity
implements IEnergySource,
IEnergySink,
Screwdriverable {
    private boolean[] out = new boolean[6];
    private int split;
    private double EUin;
    private double EUout;
    private int tierout;
    private ForgeDirection facing;

    private void calculate() {
        int s = 0;
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = this.dirs[i];
            if (!this.emitsTo(dir)) continue;
            ++s;
        }
        this.split = s;
        this.EUout = this.split > 0 ? this.EUin / (double)this.split : 0.0;
        this.tierout = ReikaEUHelper.getIC2TierFromEUVoltage((double)this.EUout);
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        if (!world.field_72995_K) {
            this.calculate();
            this.EUin = 0.0;
        }
    }

    public boolean emitsEnergyTo(TileEntity receiver, ForgeDirection direction) {
        return this.emitsTo(direction);
    }

    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return direction == this.getFacing();
    }

    public double getDemandedEnergy() {
        return Double.MAX_VALUE;
    }

    public int getSinkTier() {
        return IC2Handler.getInstance().isIC2Classic() ? 13 : Integer.MAX_VALUE;
    }

    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        this.EUin = amount;
        return amount;
    }

    public double getOfferedEnergy() {
        return this.EUout;
    }

    public void drawEnergy(double amount) {
    }

    public int getSourceTier() {
        return this.tierout;
    }

    @Override
    public ElectriTiles getTile() {
        return ElectriTiles.EUSPLIT;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    public boolean onShiftRightClick(World world, int x, int y, int z, ForgeDirection side) {
        if (!world.field_72995_K && ModList.IC2.isLoaded()) {
            this.removeTileFromNet();
        }
        this.out[side.ordinal()] = !this.out[side.ordinal()];
        world.func_147471_g(x, y, z);
        ReikaWorldHelper.causeAdjacentUpdates((World)world, (int)x, (int)y, (int)z);
        if (!world.field_72995_K && ModList.IC2.isLoaded()) {
            this.addTileToNet();
        }
        return true;
    }

    public boolean onRightClick(World world, int x, int y, int z, ForgeDirection side) {
        if (!world.field_72995_K && ModList.IC2.isLoaded()) {
            this.removeTileFromNet();
        }
        this.facing = side;
        world.func_147471_g(x, y, z);
        ReikaWorldHelper.causeAdjacentUpdates((World)world, (int)x, (int)y, (int)z);
        if (!world.field_72995_K && ModList.IC2.isLoaded()) {
            this.addTileToNet();
        }
        return true;
    }

    public boolean emitsTo(ForgeDirection s) {
        return this.emitsTo(s.ordinal());
    }

    public boolean emitsTo(int s) {
        return this.out[s] && s != this.getFacing().ordinal();
    }

    public ForgeDirection getFacing() {
        return this.facing != null ? this.facing : ForgeDirection.EAST;
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.facing = this.dirs[NBT.func_74762_e("face")];
        for (int i = 0; i < 6; ++i) {
            this.out[i] = NBT.func_74767_n("emit" + i);
        }
        this.split = NBT.func_74762_e("split");
        this.tierout = NBT.func_74762_e("tierout");
        this.EUin = NBT.func_74769_h("in");
        this.EUout = NBT.func_74769_h("out");
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("face", this.getFacing().ordinal());
        NBT.func_74768_a("split", this.split);
        NBT.func_74768_a("tierout", this.tierout);
        NBT.func_74780_a("in", this.EUin);
        NBT.func_74780_a("out", this.EUout);
        for (int i = 0; i < 6; ++i) {
            NBT.func_74757_a("emit" + i, this.out[i]);
        }
    }

    public void onFirstTick(World world, int x, int y, int z) {
        if (!world.field_72995_K && ModList.IC2.isLoaded()) {
            this.addTileToNet();
        }
    }

    @DependentMethodStripper.ModDependent(value={ModList.IC2})
    private void addTileToNet() {
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
    }

    protected void onInvalidateOrUnload(World world, int x, int y, int z, boolean invalidate) {
        if (!world.field_72995_K && ModList.IC2.isLoaded()) {
            this.removeTileFromNet();
        }
    }

    @DependentMethodStripper.ModDependent(value={ModList.IC2})
    private void removeTileFromNet() {
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
    }
}

