/*
 * Decompiled with CFR 0.152.
 */
package Reika.ElectriCraft.TileEntities.ModInterface;

import Reika.DragonAPI.Libraries.MathSci.ReikaEngLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.ElectriCraft.Base.BatteryTileBase;
import Reika.ElectriCraft.Registry.ElectriItems;
import Reika.ElectriCraft.Registry.ElectriTiles;
import cofh.api.energy.IEnergyConnection;
import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyReceiver;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityRFBattery
extends BatteryTileBase
implements IEnergyHandler {
    private long energy;
    public static final long CAPACITY = 60000000000000L;

    @Override
    public String getDisplayEnergy() {
        return TileEntityRFBattery.formatNumber(this.energy);
    }

    @Override
    public long getStoredEnergy() {
        return this.energy;
    }

    @Override
    public long getMaxEnergy() {
        return 60000000000000L;
    }

    @Override
    public String getFormattedCapacity() {
        return TileEntityRFBattery.formatNumber(60000000000000L);
    }

    private static String formatNumber(long num) {
        return String.format("%.3f %sRF", ReikaMathLibrary.getThousandBase((double)num), ReikaEngLibrary.getSIPrefix((double)num));
    }

    @Override
    public ElectriTiles getTile() {
        return ElectriTiles.RFBATTERY;
    }

    @Override
    public void updateEntity(World world, int x, int y, int z, int meta) {
        TileEntity te;
        int exp;
        super.updateEntity(world, x, y, z, meta);
        if (world.func_82737_E() % 64L == 0L) {
            world.func_147471_g(x, y, z);
        }
        if (!world.field_72995_K && this.hasRedstoneSignal() && (exp = (int)Math.min(this.energy, Integer.MAX_VALUE)) > 0 && (te = this.getAdjacentTileEntity(ForgeDirection.UP)) instanceof IEnergyConnection && ((IEnergyConnection)te).canConnectEnergy(ForgeDirection.DOWN)) {
            if (te instanceof IEnergyReceiver) {
                IEnergyReceiver ier = (IEnergyReceiver)te;
                int added = ier.receiveEnergy(ForgeDirection.DOWN, exp, false);
                this.energy -= (long)added;
            } else if (te instanceof IEnergyHandler) {
                IEnergyHandler ieh = (IEnergyHandler)te;
                int added = ieh.receiveEnergy(ForgeDirection.DOWN, exp, false);
                this.energy -= (long)added;
            }
        }
    }

    public boolean canConnectEnergy(ForgeDirection dir) {
        return true;
    }

    public int receiveEnergy(ForgeDirection dir, int amt, boolean simulate) {
        long ret;
        long l = ret = dir != ForgeDirection.UP ? Math.min((long)amt, 60000000000000L - this.energy) : 0L;
        if (ret > 0L && !simulate) {
            this.energy += ret;
        }
        return (int)ret;
    }

    public int extractEnergy(ForgeDirection dir, int amt, boolean simulate) {
        long ret;
        long l = ret = dir == ForgeDirection.UP ? Math.min((long)amt, this.energy) : 0L;
        if (ret > 0L && !simulate) {
            this.energy -= ret;
        }
        return (int)ret;
    }

    public int getEnergyStored(ForgeDirection dir) {
        return this.energy == this.getMaxEnergy() ? Integer.MAX_VALUE : (int)Math.min(this.energy, 0x7FFFFFFEL);
    }

    public int getMaxEnergyStored(ForgeDirection dir) {
        return Integer.MAX_VALUE;
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74772_a("e", this.energy);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.energy = NBT.func_74763_f("e");
    }

    @Override
    public int getEnergyColor() {
        return 0xFF1111;
    }

    @Override
    public String getUnitName() {
        return "RF";
    }

    @Override
    public boolean isDecimalSystem() {
        return false;
    }

    @Override
    protected Item getPlacerItem() {
        return ElectriItems.RFBATTERY.getItemInstance();
    }

    @Override
    protected void setEnergy(long val) {
        this.energy = val;
    }
}

