/*
 * Decompiled with CFR 0.152.
 */
package Reika.ElectriCraft.TileEntities.ModInterface;

import Reika.ChromatiCraft.API.Interfaces.WorldRift;
import Reika.DragonAPI.Interfaces.TileEntity.BreakAction;
import Reika.ElectriCraft.Base.ElectriCable;
import Reika.ElectriCraft.ElectriCraft;
import Reika.ElectriCraft.Network.RF.RFNetwork;
import Reika.ElectriCraft.Registry.ElectriTiles;
import cofh.api.energy.IEnergyConnection;
import cofh.api.energy.IEnergyHandler;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityRFCable
extends ElectriCable
implements IEnergyHandler,
BreakAction {
    protected RFNetwork network;
    private int RFlimit;

    public void setRFLimit(int limit) {
        if (this.RFlimit != limit) {
            this.RFlimit = limit;
            if (this.network != null) {
                this.network.setIOLimit(limit);
            }
        }
    }

    public int getRFLimit() {
        return this.RFlimit;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        if (!(this.getTicksExisted() != 0 && this.network != null || world.field_72995_K)) {
            this.findAndJoinNetwork(world, x, y, z);
        }
        if (this.network != null && this.network.getIOLimit() != this.RFlimit) {
            this.RFlimit = this.network.getIOLimit();
        }
    }

    public final void findAndJoinNetwork(World world, int x, int y, int z) {
        this.network = new RFNetwork();
        this.network.setIOLimit(this.getRFLimit());
        this.network.addElement(this);
        for (int i = 0; i < 6; ++i) {
            TileEntityRFCable n;
            ForgeDirection dir = this.dirs[i];
            if (!this.isChunkLoadedOnSide(dir)) continue;
            TileEntity te = this.getAdjacentTileEntity(dir);
            if (te instanceof TileEntityRFCable) {
                n = (TileEntityRFCable)te;
                RFNetwork w = n.network;
                if (w == null) continue;
                w.merge(this.network);
                continue;
            }
            if (!(te instanceof IEnergyHandler) || !(n = (IEnergyHandler)te).canConnectEnergy(dir.getOpposite())) continue;
            this.network.addConnection((IEnergyConnection)n, dir.getOpposite());
        }
        this.onJoinNetwork();
    }

    protected void onJoinNetwork() {
    }

    public final RFNetwork getNetwork() {
        return this.network;
    }

    public final void setNetwork(RFNetwork n) {
        if (n == null) {
            ElectriCraft.logger.logError((Object)((Object)((Object)this) + " was told to join a null network!"));
        } else {
            this.network = n;
            this.network.addElement(this);
        }
    }

    public final void removeFromNetwork() {
        if (this.network == null) {
            ElectriCraft.logger.logError((Object)((Object)((Object)this) + " was removed from a null network!"));
        } else {
            this.network.removeElement(this);
        }
    }

    public final void rebuildNetwork() {
        this.removeFromNetwork();
        this.resetNetwork();
        this.findAndJoinNetwork(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public final void resetNetwork() {
        this.network = null;
    }

    @Override
    public ElectriTiles getTile() {
        return ElectriTiles.CABLE;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.network != null ? this.network.addEnergy(maxReceive, simulate) : 0;
    }

    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return this.network != null ? this.network.drainEnergy(maxExtract, simulate) : 0;
    }

    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    public int getEnergyStored(ForgeDirection from) {
        return 0;
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        return Integer.MAX_VALUE;
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        if (NBT.func_74764_b("limit")) {
            this.setRFLimit(NBT.func_74762_e("limit"));
        }
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("limit", this.RFlimit);
    }

    @Override
    protected boolean connectsToTile(TileEntity te, ForgeDirection dir) {
        return te instanceof IEnergyConnection && ((IEnergyConnection)te).canConnectEnergy(dir.getOpposite()) || te instanceof WorldRift;
    }

    @Override
    protected void onNetworkUpdate(World world, int x, int y, int z, ForgeDirection dir) {
        IEnergyConnection ih;
        TileEntity te;
        if (this.network != null && (te = this.getAdjacentTileEntity(dir)) instanceof IEnergyConnection && (ih = (IEnergyConnection)te).canConnectEnergy(dir.getOpposite())) {
            this.network.addConnection(ih, dir.getOpposite());
        }
    }

    public void breakBlock() {
        if (this.network != null) {
            this.network.removeElement(this);
        }
    }
}

