/*
 * Decompiled with CFR 0.152.
 */
package Reika.ElectriCraft.TileEntities;

import Reika.DragonAPI.Libraries.MathSci.ReikaEngLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.ElectriCraft.Auxiliary.BatteryTracker;
import Reika.ElectriCraft.Auxiliary.Interfaces.BatteryTile;
import Reika.ElectriCraft.Auxiliary.Interfaces.WireEmitter;
import Reika.ElectriCraft.Auxiliary.Interfaces.WireReceiver;
import Reika.ElectriCraft.Base.NetworkTileEntity;
import Reika.ElectriCraft.Registry.BatteryType;
import Reika.ElectriCraft.Registry.ElectriItems;
import Reika.ElectriCraft.Registry.ElectriTiles;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityBattery
extends NetworkTileEntity
implements WireEmitter,
WireReceiver,
BatteryTile {
    private long energy;
    private long lastE;
    private boolean lastPower;
    private final BatteryTracker tracker = new BatteryTracker();

    @Override
    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateEntity(world, x, y, z, meta);
        this.tracker.update(this);
        if (!world.field_72995_K && this.network != null) {
            boolean flag;
            if (world.func_82737_E() % 64L == 0L) {
                ReikaWorldHelper.causeAdjacentUpdates((World)world, (int)x, (int)y, (int)z);
            }
            if (this.canReceivePower()) {
                int v = this.network.getTerminalVoltage(this);
                int a = this.network.getTerminalCurrent(this);
                long p = (long)v * (long)a;
                if (this.energy / 20L < this.getMaxEnergy()) {
                    this.energy += p;
                }
                if (this.energy / 20L >= this.getMaxEnergy()) {
                    this.energy = this.getMaxEnergy() * 20L;
                    this.network.updateWires();
                }
            }
            if ((flag = this.hasRedstoneSignal()) != this.lastPower) {
                this.network.updateWires();
            }
            if (this.canEmitPower()) {
                int v = this.getGenVoltage();
                int a = this.getGenCurrent();
                long p = (long)v * (long)a;
                this.energy -= p;
                if (this.energy <= 0L) {
                    this.energy = 0L;
                    this.network.updateWires();
                } else if (this.lastE == 0L) {
                    this.network.updateWires();
                }
            }
            this.lastPower = flag;
            this.lastE = this.energy;
        }
    }

    @Override
    public boolean canEmitPower() {
        return this.energy > 0L && this.hasRedstoneSignal() && this.network.getNumberPathsStartingAt(this) > 0;
    }

    private long getGenPower() {
        return (long)this.getGenCurrent() * (long)this.getGenVoltage();
    }

    @Override
    public long getStoredEnergy() {
        return this.energy / 20L;
    }

    @Override
    public long getMaxEnergy() {
        return this.getBatteryType().maxCapacity;
    }

    public BatteryType getBatteryType() {
        return BatteryType.batteryList[this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e)];
    }

    @Override
    public String getDisplayEnergy() {
        long e = this.getStoredEnergy();
        String pre = ReikaEngLibrary.getSIPrefix((double)e);
        double b = ReikaMathLibrary.getThousandBase((double)e);
        return String.format("%.3f%sJ", b, pre);
    }

    @Override
    public boolean canNetworkOnSide(ForgeDirection dir) {
        return true;
    }

    @Override
    public ElectriTiles getTile() {
        return ElectriTiles.BATTERY;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74772_a("e", this.energy);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.energy = NBT.func_74763_f("e");
    }

    @Override
    public boolean canReceivePowerFromSide(ForgeDirection dir) {
        return dir != ForgeDirection.UP;
    }

    @Override
    public boolean canEmitPowerToSide(ForgeDirection dir) {
        return dir == ForgeDirection.UP;
    }

    @Override
    public int getGenVoltage() {
        return this.canEmitPower() ? this.getBatteryType().outputVoltage : 0;
    }

    @Override
    public int getGenCurrent() {
        return this.canEmitPower() ? this.getBatteryType().outputCurrent : 0;
    }

    @Override
    public void setEnergyFromNBT(ItemStack is) {
        this.energy = is.func_77973_b() == ElectriItems.BATTERY.getItemInstance() ? (is.field_77990_d != null ? is.field_77990_d.func_74763_f("nrg") * 20L : 0L) : 0L;
    }

    @Override
    public boolean canReceivePower() {
        return this.energy < this.getMaxEnergy() * 20L;
    }

    @Override
    public int getRedstoneOverride() {
        return (int)(15.0 * (double)this.getStoredEnergy() / (double)this.getMaxEnergy());
    }

    @Override
    public String getFormattedCapacity() {
        return this.getBatteryType().getFormattedCapacity();
    }

    @Override
    public int getEnergyColor() {
        return 0xFFFFFF;
    }

    @Override
    public BatteryTracker getTracker() {
        return this.tracker;
    }

    @Override
    public String getUnitName() {
        return "J";
    }

    @Override
    public boolean isDecimalSystem() {
        return false;
    }
}

