/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.config;

import com.gtnewhorizon.gtnhlib.config.Config;

@Config(modid="angelica", category="customfont")
public class FontConfig {
    @Config.Comment(value={"Whether or not to use custom fonts when drawing text."})
    @Config.DefaultBoolean(value=false)
    public static boolean enableCustomFont;
    @Config.Comment(value={"Name of the primary custom font. Best not to set it from here."})
    @Config.DefaultString(value="(none)")
    public static String customFontNamePrimary;
    @Config.Comment(value={"Name of the fallback custom font. Best not to set it from here."})
    @Config.DefaultString(value="(none)")
    public static String customFontNameFallback;
    @Config.Comment(value={"The quality at which custom fonts are rendered, making them less pixelated but increasing memory usage."})
    @Config.DefaultInt(value=30)
    @Config.RangeInt(min=6, max=72)
    public static int customFontQuality;
    @Config.Comment(value={"Controls the distance at which the font's shadow is drawn."})
    @Config.DefaultFloat(value=1.0f)
    @Config.RangeFloat(min=0.0f, max=2.0f)
    public static float fontShadowOffset;
    @Config.Comment(value={"The number of shadows to be drawn behind text at various offsets."})
    @Config.DefaultInt(value=1)
    @Config.RangeInt(min=1, max=8)
    public static int shadowCopies;
    @Config.Comment(value={"The number of bold copies to be drawn behind text at various offsets."})
    @Config.DefaultInt(value=2)
    @Config.RangeInt(min=1, max=8)
    public static int boldCopies;
    @Config.Comment(value={"Influences the aspect ratio of each glyph."})
    @Config.DefaultFloat(value=0.0f)
    @Config.RangeFloat(min=-1.0f, max=1.0f)
    public static float glyphAspect;
    @Config.Comment(value={"Scale of each glyph, whitespace excluded."})
    @Config.DefaultFloat(value=1.0f)
    @Config.RangeFloat(min=0.1f, max=3.0f)
    public static float glyphScale;
    @Config.Comment(value={"Whitespace scale."})
    @Config.DefaultFloat(value=1.0f)
    @Config.RangeFloat(min=0.1f, max=3.0f)
    public static float whitespaceScale;
    @Config.Comment(value={"Adds extra spacing between glyphs."})
    @Config.DefaultFloat(value=0.0f)
    @Config.RangeFloat(min=-2.0f, max=2.0f)
    public static float glyphSpacing;
    @Config.Comment(value={"Controls font antialiasing. 0 = none, 1 = 4x MSAA, 2 = 16x MSAA."})
    @Config.DefaultInt(value=2)
    @Config.RangeInt(min=0, max=2)
    public static int fontAAMode;
    @Config.Comment(value={"Affects font antialiasing sample spacing. Higher values increase blur."})
    @Config.DefaultInt(value=7)
    @Config.RangeInt(min=1, max=24)
    public static int fontAAStrength;
    @Config.Comment(value={"Custom font scale multiplier, for bugfixes."})
    @Config.DefaultFloat(value=1.5f)
    @Config.RangeFloat(min=0.1f, max=3.0f)
    public static float customFontScale;
}

