/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.glsm.states;

import com.gtnewhorizons.angelica.glsm.GLStateManager;
import com.gtnewhorizons.angelica.glsm.states.ISettableState;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector3i;
import org.joml.Vector4f;
import org.joml.Vector4fc;
import org.joml.Vector4i;
import org.lwjgl.opengl.GL11;

public class LightState
implements ISettableState<LightState> {
    private static final Vector4i vector4i = new Vector4i();
    private static final Vector4f vector4f = new Vector4f();
    private static final Vector3i vector3i = new Vector3i();
    private static final Matrix3f matrix3f = new Matrix3f();
    public int light;
    public final Vector4f ambient;
    public final Vector4f diffuse;
    public final Vector4f specular;
    public final Vector4f position;
    public final Vector3f spotDirection;
    public float spotExponent;
    public float spotCutoff;
    public float constantAttenuation;
    public float linearAttenuation;
    public float quadraticAttenuation;

    public LightState(int light) {
        this(light, new Vector4f(0.0f, 0.0f, 0.0f, 1.0f), new Vector4f(0.0f, 0.0f, 0.0f, 1.0f), new Vector4f(0.0f, 0.0f, 0.0f, 1.0f), new Vector4f(0.0f, 0.0f, 1.0f, 0.0f), new Vector3f(0.0f, 0.0f, -1.0f), 0.0f, 180.0f, 1.0f, 0.0f, 0.0f);
        if (light == 16384) {
            this.diffuse.set(1.0f, 1.0f, 1.0f, 1.0f);
            this.specular.set(1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public LightState(int light, Vector4f ambient, Vector4f diffuse, Vector4f specular, Vector4f position, Vector3f spotDirection, float spotExponent, float spotCutoff, float constantAttenuation, float linearAttenuation, float quadraticAttenuation) {
        this.light = light;
        this.ambient = ambient;
        this.diffuse = diffuse;
        this.specular = specular;
        this.spotExponent = spotExponent;
        this.spotCutoff = spotCutoff;
        this.constantAttenuation = constantAttenuation;
        this.linearAttenuation = linearAttenuation;
        this.quadraticAttenuation = quadraticAttenuation;
        this.position = position;
        this.position.mul((Matrix4fc)GLStateManager.getModelViewMatrix());
        this.spotDirection = spotDirection;
        GLStateManager.getModelViewMatrix().get3x3(matrix3f);
        this.spotDirection.mul((Matrix3fc)matrix3f);
    }

    public void setAmbient(FloatBuffer newBuffer) {
        vector4f.set(newBuffer);
        if (GLStateManager.shouldBypassCache() || !this.ambient.equals((Object)vector4f)) {
            this.ambient.set((Vector4fc)vector4f);
            GL11.glLight((int)this.light, (int)4608, (FloatBuffer)newBuffer);
        }
    }

    public void setAmbient(IntBuffer newBuffer) {
        vector4i.set(newBuffer);
        vector4f.set(GLStateManager.i2f(LightState.vector4i.x), GLStateManager.i2f(LightState.vector4i.y), GLStateManager.i2f(LightState.vector4i.z), GLStateManager.i2f(LightState.vector4i.w));
        if (GLStateManager.shouldBypassCache() || !this.ambient.equals((Object)vector4f)) {
            this.ambient.set((Vector4fc)vector4f);
            GL11.glLight((int)this.light, (int)4608, (IntBuffer)newBuffer);
        }
    }

    public void setDiffuse(FloatBuffer newBuffer) {
        vector4f.set(newBuffer);
        if (GLStateManager.shouldBypassCache() || !this.diffuse.equals((Object)vector4f)) {
            this.diffuse.set((Vector4fc)vector4f);
            GL11.glLight((int)this.light, (int)4609, (FloatBuffer)newBuffer);
        }
    }

    public void setDiffuse(IntBuffer newBuffer) {
        vector4i.set(newBuffer);
        vector4f.set(GLStateManager.i2f(LightState.vector4i.x), GLStateManager.i2f(LightState.vector4i.y), GLStateManager.i2f(LightState.vector4i.z), GLStateManager.i2f(LightState.vector4i.w));
        if (GLStateManager.shouldBypassCache() || !this.diffuse.equals((Object)vector4f)) {
            this.diffuse.set((Vector4fc)vector4f);
            GL11.glLight((int)this.light, (int)4609, (IntBuffer)newBuffer);
        }
    }

    public void setSpecular(FloatBuffer newBuffer) {
        vector4f.set(newBuffer);
        if (GLStateManager.shouldBypassCache() || !this.specular.equals((Object)vector4f)) {
            this.specular.set((Vector4fc)vector4f);
            GL11.glLight((int)this.light, (int)4610, (FloatBuffer)newBuffer);
        }
    }

    public void setSpecular(IntBuffer newBuffer) {
        vector4i.set(newBuffer);
        vector4f.set(GLStateManager.i2f(LightState.vector4i.x), GLStateManager.i2f(LightState.vector4i.y), GLStateManager.i2f(LightState.vector4i.z), GLStateManager.i2f(LightState.vector4i.w));
        if (GLStateManager.shouldBypassCache() || !this.specular.equals((Object)vector4f)) {
            this.specular.set((Vector4fc)vector4f);
            GL11.glLight((int)this.light, (int)4610, (IntBuffer)newBuffer);
        }
    }

    public void setPosition(FloatBuffer newBuffer) {
        this.position.set(newBuffer);
        this.position.mul((Matrix4fc)GLStateManager.getModelViewMatrix());
        GL11.glLight((int)this.light, (int)4611, (FloatBuffer)newBuffer);
    }

    public void setPosition(IntBuffer newBuffer) {
        vector4i.set(newBuffer);
        this.position.set((float)LightState.vector4i.x, (float)LightState.vector4i.y, (float)LightState.vector4i.z, (float)LightState.vector4i.w);
        this.position.mul((Matrix4fc)GLStateManager.getModelViewMatrix());
        GL11.glLight((int)this.light, (int)4611, (IntBuffer)newBuffer);
    }

    public void setSpotDirection(FloatBuffer newBuffer) {
        GLStateManager.getModelViewMatrix().get3x3(matrix3f);
        this.spotDirection.set(newBuffer);
        this.spotDirection.mul((Matrix3fc)matrix3f);
        GL11.glLight((int)this.light, (int)4612, (FloatBuffer)newBuffer);
    }

    public void setSpotDirection(IntBuffer newBuffer) {
        vector3i.set(newBuffer);
        GLStateManager.getModelViewMatrix().get3x3(matrix3f);
        this.spotDirection.set((float)LightState.vector3i.x, (float)LightState.vector3i.y, (float)LightState.vector3i.z);
        this.spotDirection.mul((Matrix3fc)matrix3f);
        GL11.glLight((int)this.light, (int)4612, (IntBuffer)newBuffer);
    }

    public void setSpotExponent(FloatBuffer newBuffer) {
        this.setSpotExponent(newBuffer.get());
    }

    public void setSpotExponent(IntBuffer newBuffer) {
        this.setSpotExponent((float)newBuffer.get());
    }

    public void setSpotExponent(int i) {
        this.setSpotExponent((float)i);
    }

    public void setSpotExponent(float f) {
        if (GLStateManager.shouldBypassCache() || Float.compare(f, this.spotExponent) != 0) {
            this.spotExponent = f;
            GL11.glLightf((int)this.light, (int)4613, (float)f);
        }
    }

    public void setSpotCutoff(FloatBuffer newBuffer) {
        this.setSpotCutoff(newBuffer.get());
    }

    public void setSpotCutoff(IntBuffer newBuffer) {
        this.setSpotCutoff((float)newBuffer.get());
    }

    public void setSpotCutoff(int i) {
        this.setSpotCutoff((float)i);
    }

    public void setSpotCutoff(float f) {
        if (GLStateManager.shouldBypassCache() || Float.compare(f, this.spotCutoff) != 0) {
            this.spotCutoff = f;
            GL11.glLightf((int)this.light, (int)4614, (float)f);
        }
    }

    public void setConstantAttenuation(FloatBuffer newBuffer) {
        this.setConstantAttenuation(newBuffer.get());
    }

    public void setConstantAttenuation(IntBuffer newBuffer) {
        this.setConstantAttenuation((float)newBuffer.get());
    }

    public void setConstantAttenuation(int i) {
        this.setConstantAttenuation((float)i);
    }

    public void setConstantAttenuation(float f) {
        if (GLStateManager.shouldBypassCache() || Float.compare(f, this.constantAttenuation) != 0) {
            this.constantAttenuation = f;
            GL11.glLightf((int)this.light, (int)4615, (float)f);
        }
    }

    public void setLinearAttenuation(FloatBuffer newBuffer) {
        this.setLinearAttenuation(newBuffer.get());
    }

    public void setLinearAttenuation(IntBuffer newBuffer) {
        this.setLinearAttenuation((float)newBuffer.get());
    }

    public void setLinearAttenuation(int i) {
        this.setLinearAttenuation((float)i);
    }

    public void setLinearAttenuation(float f) {
        if (GLStateManager.shouldBypassCache() || Float.compare(f, this.linearAttenuation) != 0) {
            this.linearAttenuation = f;
            GL11.glLightf((int)this.light, (int)4616, (float)f);
        }
    }

    public void setQuadraticAttenuation(FloatBuffer newBuffer) {
        this.setQuadraticAttenuation(newBuffer.get());
    }

    public void setQuadraticAttenuation(IntBuffer newBuffer) {
        this.setQuadraticAttenuation((float)newBuffer.get());
    }

    public void setQuadraticAttenuation(int i) {
        this.setQuadraticAttenuation((float)i);
    }

    public void setQuadraticAttenuation(float f) {
        if (GLStateManager.shouldBypassCache() || Float.compare(f, this.quadraticAttenuation) != 0) {
            this.quadraticAttenuation = f;
            GL11.glLightf((int)this.light, (int)4617, (float)f);
        }
    }

    @Override
    public LightState set(LightState state) {
        this.ambient.set((Vector4fc)state.ambient);
        this.diffuse.set((Vector4fc)state.diffuse);
        this.specular.set((Vector4fc)state.specular);
        this.position.set((Vector4fc)state.position);
        this.spotDirection.set((Vector3fc)state.spotDirection);
        this.spotExponent = state.spotExponent;
        this.spotCutoff = state.spotCutoff;
        this.constantAttenuation = state.constantAttenuation;
        this.linearAttenuation = state.linearAttenuation;
        this.quadraticAttenuation = state.quadraticAttenuation;
        return this;
    }

    @Override
    public boolean sameAs(Object state) {
        if (this == state) {
            return true;
        }
        if (!(state instanceof LightState)) {
            return false;
        }
        LightState lightState = (LightState)state;
        return this.ambient.equals((Object)lightState.ambient) && this.diffuse.equals((Object)lightState.diffuse) && this.specular.equals((Object)lightState.specular) && this.position.equals((Object)lightState.position) && this.spotDirection.equals((Object)lightState.spotDirection) && Float.compare(this.spotCutoff, lightState.spotCutoff) == 0 && Float.compare(this.spotExponent, lightState.spotExponent) == 0 && Float.compare(this.linearAttenuation, lightState.linearAttenuation) == 0 && Float.compare(this.constantAttenuation, lightState.constantAttenuation) == 0 && Float.compare(this.quadraticAttenuation, lightState.quadraticAttenuation) == 0;
    }

    @Override
    public LightState copy() {
        return new LightState(this.light).set(this);
    }
}

