/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline.transform;

import com.gtnewhorizons.angelica.shadow.org.antlr.v4.runtime.tree.ParseTree;
import com.gtnewhorizons.angelica.shadow.org.taumc.glsl.Util;
import com.gtnewhorizons.angelica.shadow.org.taumc.glsl.grammar.GLSLParser;
import java.util.Map;
import net.coderbot.iris.gl.shader.ShaderType;
import net.coderbot.iris.pipeline.transform.PatchShaderType;
import net.coderbot.iris.pipeline.transform.parameter.Parameters;

public class CompatibilityTransformer {
    private static final ShaderType[] pipeline = new ShaderType[]{ShaderType.VERTEX, ShaderType.GEOMETRY, ShaderType.FRAGMENT};

    public static void transformEach(GLSLParser.Translation_unitContext translationUnit, Parameters parameters) {
        if (parameters.type == PatchShaderType.VERTEX) {
            Util.replaceExpression(translationUnit, "fract(worldpos.y + 0.001)", "fract(worldpos.y + 0.01)");
        }
        Util.removeUnusedFunctions(translationUnit);
        Util.removeConstAssignment(translationUnit);
    }

    public static void transformGrouped(Map<PatchShaderType, GLSLParser.Translation_unitContext> trees, Parameters parameters) {
        ShaderType prevType = null;
        for (ShaderType type : pipeline) {
            PatchShaderType[] patchTypes = PatchShaderType.fromGlShaderType(type);
            boolean hasAny = false;
            for (PatchShaderType currentType : patchTypes) {
                if (trees.get((Object)currentType) == null) continue;
                hasAny = true;
            }
            if (!hasAny) continue;
            if (prevType == null) {
                prevType = type;
                continue;
            }
            PatchShaderType prevPatchTypes = PatchShaderType.fromGlShaderType(prevType)[0];
            GLSLParser.Translation_unitContext prevTree = trees.get((Object)prevPatchTypes);
            Map<String, GLSLParser.Single_declarationContext> outDec = Util.findQualifiers(prevTree, 109);
            for (PatchShaderType currentType : patchTypes) {
                GLSLParser.Translation_unitContext currentTree = trees.get((Object)currentType);
                if (currentTree == null) continue;
                Map<String, GLSLParser.Single_declarationContext> inDec = Util.findQualifiers(currentTree, 62);
                for (String in : inDec.keySet()) {
                    if (in.startsWith("gl_")) continue;
                    if (!outDec.containsKey(in)) {
                        if (!Util.containsCall(currentTree, in)) continue;
                        Util.makeOutDeclaration(prevTree, inDec.get(in), in);
                        if (Util.hasAssigment(prevTree, in)) continue;
                        Util.initialize(prevTree, inDec.get(in), in);
                        continue;
                    }
                    ParseTree outType = (ParseTree)outDec.get((Object)in).fully_specified_type().type_specifier().type_specifier_nonarray().children.get(0);
                    ParseTree inType = (ParseTree)inDec.get((Object)in).fully_specified_type().type_specifier().type_specifier_nonarray().children.get(0);
                    if (outDec.get(in).fully_specified_type().type_specifier().array_specifier() != null || !inType.getText().equals(outType.getText()) || Util.hasAssigment(prevTree, in)) continue;
                    Util.initialize(prevTree, inDec.get(in), in);
                }
            }
            prevType = type;
        }
    }
}

