/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.asm.transformers;

import net.darkhax.bookshelf.asm.ASMHelper;
import net.darkhax.bookshelf.asm.Mappings;
import org.objectweb.asm.Label;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class EntityHorseTransformer {
    public static byte[] transform(String name, String transformedName, byte[] bytes) {
        ClassNode horseClass = ASMHelper.createClassFromByteArray(bytes);
        EntityHorseTransformer.injectGetCustomBookshelfArmor(horseClass);
        EntityHorseTransformer.injectSetCustomBoookhelfArmor(horseClass);
        EntityHorseTransformer.transformGetTotalArmorValue(ASMHelper.getMethodFromClass(horseClass, Mappings.getTotalArmorValue, "()I"));
        EntityHorseTransformer.transformOnInventoryChanged(ASMHelper.getMethodFromClass(horseClass, Mappings.onInventoryChanged, "(Lnet/minecraft/inventory/InventoryBasic;)V"));
        EntityHorseTransformer.transformUpdateHorseSlots(ASMHelper.getMethodFromClass(horseClass, Mappings.updateHorseSlots, "()V"));
        EntityHorseTransformer.transformEntityInit(ASMHelper.getMethodFromClass(horseClass, Mappings.entityInit, "()V"));
        EntityHorseTransformer.transformIsValidArmor(ASMHelper.getMethodFromClass(horseClass, Mappings.isArmorItem, "(Lnet/minecraft/item/Item;)Z"));
        if (ASMHelper.hasClassMethodName(horseClass, Mappings.setHorseTexturePaths)) {
            EntityHorseTransformer.transformSetHorseTexturePaths(ASMHelper.getMethodFromClass(horseClass, Mappings.setHorseTexturePaths, "()V"));
        }
        return ASMHelper.createByteArrayFromClass(horseClass, 3);
    }

    private static void injectGetCustomBookshelfArmor(ClassNode horseClass) {
        MethodNode newMethod = new MethodNode(2, "getCustomBookshelfArmor", "()Lnet/minecraft/item/ItemStack;", null, null);
        newMethod.visitCode();
        Label l0 = new Label();
        newMethod.visitLabel(l0);
        newMethod.visitVarInsn(25, 0);
        newMethod.visitFieldInsn(180, "net/minecraft/entity/passive/EntityHorse", Mappings.dataWatcher, "Lnet/minecraft/entity/DataWatcher;");
        newMethod.visitIntInsn(16, 23);
        newMethod.visitMethodInsn(182, "net/minecraft/entity/DataWatcher", Mappings.getWatchableObjectItemStack, "(I)Lnet/minecraft/item/ItemStack;", false);
        newMethod.visitInsn(176);
        Label l1 = new Label();
        newMethod.visitLabel(l1);
        newMethod.visitLocalVariable("this", "Lnet/minecraft/entity/passive/EntityHorse;", null, l0, l1, 0);
        newMethod.visitMaxs(2, 1);
        newMethod.visitEnd();
        horseClass.methods.add(newMethod);
    }

    private static void injectSetCustomBoookhelfArmor(ClassNode horseClass) {
        MethodNode newMethod = new MethodNode(2, "setCustomBookshelfArmor", "(Lnet/minecraft/item/ItemStack;)V", null, null);
        newMethod.visitCode();
        Label l0 = new Label();
        newMethod.visitLabel(l0);
        newMethod.visitVarInsn(25, 1);
        Label l1 = new Label();
        newMethod.visitJumpInsn(199, l1);
        newMethod.visitTypeInsn(187, "net/minecraft/item/ItemStack");
        newMethod.visitInsn(89);
        newMethod.visitFieldInsn(178, "net/minecraft/init/Items", Mappings.stick, "Lnet/minecraft/item/Item;");
        newMethod.visitInsn(3);
        newMethod.visitMethodInsn(183, "net/minecraft/item/ItemStack", "<init>", "(Lnet/minecraft/item/Item;I)V", false);
        newMethod.visitVarInsn(58, 1);
        newMethod.visitLabel(l1);
        newMethod.visitFrame(3, 0, null, 0, null);
        newMethod.visitVarInsn(25, 0);
        newMethod.visitFieldInsn(180, "net/minecraft/entity/passive/EntityHorse", Mappings.dataWatcher, "Lnet/minecraft/entity/DataWatcher;");
        newMethod.visitIntInsn(16, 23);
        newMethod.visitVarInsn(25, 1);
        newMethod.visitMethodInsn(182, "net/minecraft/entity/DataWatcher", Mappings.updateObject, "(ILjava/lang/Object;)V", false);
        Label l3 = new Label();
        newMethod.visitLabel(l3);
        newMethod.visitInsn(177);
        Label l4 = new Label();
        newMethod.visitLabel(l4);
        newMethod.visitLocalVariable("this", "Lnet/minecraft/entity/passive/EntityHorse;", null, l0, l3, 0);
        newMethod.visitLocalVariable("stack", "Lnet/minecraft/item/ItemStack;", null, l0, l3, 1);
        newMethod.visitMaxs(5, 2);
        newMethod.visitEnd();
        horseClass.methods.add(newMethod);
    }

    private static void transformGetTotalArmorValue(MethodNode method) {
        InsnList newInstr = new InsnList();
        newInstr.add((AbstractInsnNode)new LabelNode());
        newInstr.add((AbstractInsnNode)new VarInsnNode(25, 0));
        newInstr.add((AbstractInsnNode)new MethodInsnNode(183, "net/minecraft/entity/passive/EntityHorse", "getCustomBookshelfArmor", "()Lnet/minecraft/item/ItemStack;", false));
        newInstr.add((AbstractInsnNode)new VarInsnNode(58, 1));
        newInstr.add((AbstractInsnNode)new LabelNode());
        newInstr.add((AbstractInsnNode)new VarInsnNode(25, 1));
        newInstr.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/item/ItemStack", Mappings.getItem, "()Lnet/minecraft/item/Item;", false));
        newInstr.add((AbstractInsnNode)new TypeInsnNode(193, "net/darkhax/bookshelf/items/ItemHorseArmor"));
        LabelNode l2 = new LabelNode();
        newInstr.add((AbstractInsnNode)new JumpInsnNode(153, l2));
        newInstr.add((AbstractInsnNode)new LabelNode());
        newInstr.add((AbstractInsnNode)new VarInsnNode(25, 1));
        newInstr.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/item/ItemStack", Mappings.getItem, "()Lnet/minecraft/item/Item;", false));
        newInstr.add((AbstractInsnNode)new TypeInsnNode(192, "net/darkhax/bookshelf/items/ItemHorseArmor"));
        newInstr.add((AbstractInsnNode)new VarInsnNode(25, 0));
        newInstr.add((AbstractInsnNode)new VarInsnNode(25, 1));
        newInstr.add((AbstractInsnNode)new MethodInsnNode(182, "net/darkhax/bookshelf/items/ItemHorseArmor", "getArmorValue", "(Lnet/minecraft/entity/passive/EntityHorse;Lnet/minecraft/item/ItemStack;)I", false));
        newInstr.add((AbstractInsnNode)new InsnNode(172));
        newInstr.add((AbstractInsnNode)l2);
        method.instructions.insertBefore(method.instructions.getFirst(), newInstr);
    }

    private static void transformOnInventoryChanged(MethodNode method) {
        InsnList needle = new InsnList();
        needle.add((AbstractInsnNode)new VarInsnNode(25, 0));
        needle.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/entity/passive/EntityHorse", Mappings.isHorseSaddled, "()Z", false));
        needle.add((AbstractInsnNode)new VarInsnNode(54, 3));
        AbstractInsnNode pointer = ASMHelper.findLastNodeFromNeedle(method.instructions, needle);
        InsnList newInstr = new InsnList();
        newInstr.add((AbstractInsnNode)new LabelNode());
        newInstr.add((AbstractInsnNode)new VarInsnNode(25, 0));
        newInstr.add((AbstractInsnNode)new MethodInsnNode(183, "net/minecraft/entity/passive/EntityHorse", "getCustomBookshelfArmor", "()Lnet/minecraft/item/ItemStack;", false));
        newInstr.add((AbstractInsnNode)new VarInsnNode(58, 4));
        method.instructions.insert(pointer, newInstr);
        needle = new InsnList();
        needle.add((AbstractInsnNode)new LdcInsnNode((Object)"mob.horse.armor"));
        needle.add((AbstractInsnNode)new LdcInsnNode((Object)new Float("0.5")));
        needle.add((AbstractInsnNode)new InsnNode(12));
        needle.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/entity/passive/EntityHorse", Mappings.playSound, "(Ljava/lang/String;FF)V", false));
        needle.add((AbstractInsnNode)new LabelNode());
        pointer = ASMHelper.findLastNodeFromNeedle(method.instructions, needle);
        newInstr = new InsnList();
        newInstr.add((AbstractInsnNode)new VarInsnNode(25, 4));
        newInstr.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/item/ItemStack", Mappings.getItem, "()Lnet/minecraft/item/Item;", false));
        newInstr.add((AbstractInsnNode)new FieldInsnNode(178, "net/minecraft/init/Items", Mappings.stick, "Lnet/minecraft/item/Item;"));
        LabelNode l9 = new LabelNode();
        newInstr.add((AbstractInsnNode)new JumpInsnNode(166, l9));
        newInstr.add((AbstractInsnNode)new VarInsnNode(25, 4));
        newInstr.add((AbstractInsnNode)new VarInsnNode(25, 0));
        newInstr.add((AbstractInsnNode)new MethodInsnNode(183, "net/minecraft/entity/passive/EntityHorse", "getCustomBookshelfArmor", "()Lnet/minecraft/item/ItemStack;", false));
        newInstr.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/item/ItemStack", Mappings.isItemEqual, "(Lnet/minecraft/item/ItemStack;)Z", false));
        newInstr.add((AbstractInsnNode)new JumpInsnNode(154, l9));
        newInstr.add((AbstractInsnNode)new LabelNode());
        newInstr.add((AbstractInsnNode)new VarInsnNode(25, 0));
        newInstr.add((AbstractInsnNode)new LdcInsnNode((Object)"mob.horse.armor"));
        newInstr.add((AbstractInsnNode)new LdcInsnNode((Object)new Float("0.5")));
        newInstr.add((AbstractInsnNode)new InsnNode(12));
        newInstr.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/entity/passive/EntityHorse", Mappings.playSound, "(Ljava/lang/String;FF)V", false));
        newInstr.add((AbstractInsnNode)l9);
        method.instructions.insert(pointer, newInstr);
    }

    private static void transformSetHorseTexturePaths(MethodNode method) {
        InsnList needle = new InsnList();
        needle.add((AbstractInsnNode)new VarInsnNode(25, 0));
        needle.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/entity/passive/EntityHorse", Mappings.getHorseArmorIndexSynced, "()I", false));
        needle.add((AbstractInsnNode)new VarInsnNode(54, 3));
        AbstractInsnNode node = ASMHelper.findLastNodeFromNeedle(method.instructions, needle);
        InsnList newInstr = new InsnList();
        LabelNode l17 = new LabelNode();
        newInstr.add((AbstractInsnNode)l17);
        newInstr.add((AbstractInsnNode)new VarInsnNode(25, 0));
        newInstr.add((AbstractInsnNode)new MethodInsnNode(183, "net/minecraft/entity/passive/EntityHorse", "getCustomBookshelfArmor", "()Lnet/minecraft/item/ItemStack;", false));
        newInstr.add((AbstractInsnNode)new VarInsnNode(58, 4));
        LabelNode l18 = new LabelNode();
        newInstr.add((AbstractInsnNode)l18);
        newInstr.add((AbstractInsnNode)new VarInsnNode(25, 4));
        newInstr.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/item/ItemStack", Mappings.getItem, "()Lnet/minecraft/item/Item;", false));
        newInstr.add((AbstractInsnNode)new TypeInsnNode(193, "net/darkhax/bookshelf/items/ItemHorseArmor"));
        LabelNode l19 = new LabelNode();
        newInstr.add((AbstractInsnNode)new JumpInsnNode(153, l19));
        LabelNode l20 = new LabelNode();
        newInstr.add((AbstractInsnNode)l20);
        newInstr.add((AbstractInsnNode)new VarInsnNode(25, 0));
        newInstr.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/entity/passive/EntityHorse", Mappings.horseTextureArray, "[Ljava/lang/String;"));
        newInstr.add((AbstractInsnNode)new InsnNode(5));
        newInstr.add((AbstractInsnNode)new VarInsnNode(25, 4));
        newInstr.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/item/ItemStack", Mappings.getItem, "()Lnet/minecraft/item/Item;", false));
        newInstr.add((AbstractInsnNode)new TypeInsnNode(192, "net/darkhax/bookshelf/items/ItemHorseArmor"));
        newInstr.add((AbstractInsnNode)new VarInsnNode(25, 0));
        newInstr.add((AbstractInsnNode)new VarInsnNode(25, 4));
        newInstr.add((AbstractInsnNode)new MethodInsnNode(182, "net/darkhax/bookshelf/items/ItemHorseArmor", "getArmorTexture", "(Lnet/minecraft/entity/passive/EntityHorse;Lnet/minecraft/item/ItemStack;)Ljava/lang/String;", false));
        newInstr.add((AbstractInsnNode)new InsnNode(83));
        LabelNode l21 = new LabelNode();
        newInstr.add((AbstractInsnNode)l21);
        newInstr.add((AbstractInsnNode)new VarInsnNode(25, 0));
        newInstr.add((AbstractInsnNode)new TypeInsnNode(187, "java/lang/StringBuilder"));
        newInstr.add((AbstractInsnNode)new InsnNode(89));
        newInstr.add((AbstractInsnNode)new VarInsnNode(25, 0));
        newInstr.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/entity/passive/EntityHorse", Mappings.texturePrefix, "Ljava/lang/String;"));
        newInstr.add((AbstractInsnNode)new MethodInsnNode(184, "java/lang/String", "valueOf", "(Ljava/lang/Object;)Ljava/lang/String;", false));
        newInstr.add((AbstractInsnNode)new MethodInsnNode(183, "java/lang/StringBuilder", "<init>", "(Ljava/lang/String;)V", false));
        newInstr.add((AbstractInsnNode)new LdcInsnNode((Object)"cst-"));
        newInstr.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false));
        newInstr.add((AbstractInsnNode)new VarInsnNode(25, 4));
        newInstr.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/item/ItemStack", Mappings.getUnlocalizedName, "()Ljava/lang/String;", false));
        newInstr.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false));
        newInstr.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/StringBuilder", "toString", "()Ljava/lang/String;", false));
        newInstr.add((AbstractInsnNode)new FieldInsnNode(181, "net/minecraft/entity/passive/EntityHorse", Mappings.texturePrefix, "Ljava/lang/String;"));
        newInstr.add((AbstractInsnNode)new InsnNode(177));
        newInstr.add((AbstractInsnNode)l19);
        method.instructions.insert(node, newInstr);
    }

    private static void transformUpdateHorseSlots(MethodNode method) {
        InsnList needle = new InsnList();
        needle.add((AbstractInsnNode)new VarInsnNode(25, 0));
        needle.add((AbstractInsnNode)new VarInsnNode(25, 0));
        needle.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/entity/passive/EntityHorse", Mappings.horseChest, "Lnet/minecraft/inventory/AnimalChest;"));
        needle.add((AbstractInsnNode)new InsnNode(4));
        AbstractInsnNode pointer = ASMHelper.findFirstNodeFromNeedle(method.instructions, needle);
        InsnList newInstr = new InsnList();
        newInstr.add((AbstractInsnNode)new VarInsnNode(25, 0));
        newInstr.add((AbstractInsnNode)new VarInsnNode(25, 0));
        newInstr.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/entity/passive/EntityHorse", Mappings.horseChest, "Lnet/minecraft/inventory/AnimalChest;"));
        newInstr.add((AbstractInsnNode)new InsnNode(4));
        newInstr.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/inventory/AnimalChest", Mappings.getStackInSlot, "(I)Lnet/minecraft/item/ItemStack;", false));
        newInstr.add((AbstractInsnNode)new MethodInsnNode(183, "net/minecraft/entity/passive/EntityHorse", "setCustomBookshelfArmor", "(Lnet/minecraft/item/ItemStack;)V", false));
        newInstr.add((AbstractInsnNode)new LabelNode());
        method.instructions.insertBefore(pointer, newInstr);
    }

    private static void transformEntityInit(MethodNode method) {
        InsnList needle = new InsnList();
        needle.add((AbstractInsnNode)new VarInsnNode(25, 0));
        needle.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/entity/passive/EntityHorse", Mappings.dataWatcher, "Lnet/minecraft/entity/DataWatcher;"));
        needle.add((AbstractInsnNode)new IntInsnNode(16, 22));
        needle.add((AbstractInsnNode)new InsnNode(3));
        needle.add((AbstractInsnNode)new MethodInsnNode(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;", false));
        needle.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/entity/DataWatcher", Mappings.addObject, "(ILjava/lang/Object;)V", false));
        AbstractInsnNode pointer = ASMHelper.findLastNodeFromNeedle(method.instructions, needle);
        InsnList newInstr = new InsnList();
        newInstr.add((AbstractInsnNode)new LabelNode());
        newInstr.add((AbstractInsnNode)new VarInsnNode(25, 0));
        newInstr.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/entity/passive/EntityHorse", Mappings.dataWatcher, "Lnet/minecraft/entity/DataWatcher;"));
        newInstr.add((AbstractInsnNode)new IntInsnNode(16, 23));
        newInstr.add((AbstractInsnNode)new TypeInsnNode(187, "net/minecraft/item/ItemStack"));
        newInstr.add((AbstractInsnNode)new InsnNode(89));
        newInstr.add((AbstractInsnNode)new FieldInsnNode(178, "net/minecraft/init/Items", Mappings.stick, "Lnet/minecraft/item/Item;"));
        newInstr.add((AbstractInsnNode)new InsnNode(3));
        newInstr.add((AbstractInsnNode)new MethodInsnNode(183, "net/minecraft/item/ItemStack", "<init>", "(Lnet/minecraft/item/Item;I)V", false));
        newInstr.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/entity/DataWatcher", Mappings.addObject, "(ILjava/lang/Object;)V", false));
        method.instructions.insert(pointer, newInstr);
    }

    private static void transformIsValidArmor(MethodNode method) {
        InsnList needle = new InsnList();
        needle.add((AbstractInsnNode)new VarInsnNode(25, 0));
        needle.add((AbstractInsnNode)new FieldInsnNode(178, "net/minecraft/init/Items", Mappings.iron_horse_armor, "Lnet/minecraft/item/Item;"));
        needle.add((AbstractInsnNode)new JumpInsnNode(165, new LabelNode()));
        AbstractInsnNode node = ASMHelper.findFirstNodeFromNeedle(method.instructions, needle);
        InsnList newInstr = new InsnList();
        newInstr.add((AbstractInsnNode)new VarInsnNode(25, 0));
        newInstr.add((AbstractInsnNode)new TypeInsnNode(193, "net/darkhax/bookshelf/items/ItemHorseArmor"));
        LabelNode ln = new LabelNode();
        newInstr.add((AbstractInsnNode)new JumpInsnNode(153, ln));
        newInstr.add((AbstractInsnNode)new LabelNode());
        newInstr.add((AbstractInsnNode)new InsnNode(4));
        newInstr.add((AbstractInsnNode)new InsnNode(172));
        newInstr.add((AbstractInsnNode)ln);
        newInstr.add((AbstractInsnNode)new FrameNode(3, 0, null, 0, null));
        method.instructions.insertBefore(node, newInstr);
    }
}

