/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.lib.util;

import net.darkhax.bookshelf.lib.util.ItemStackUtils;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.init.Items;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public final class EnchantmentUtils {
    public static boolean isItemEnchantable(ItemStack itemStack) {
        return itemStack.func_77973_b().getItemEnchantability(itemStack) > 0 && (itemStack.func_77973_b() == Items.field_151122_aG || itemStack.func_77973_b() == Items.field_151134_bR || itemStack.func_77956_u());
    }

    public static int getExperienceFromLevel(int level) {
        return (int)(level < 16 ? (float)(17 * level) : (level > 15 && level < 31 ? 1.5f * (float)(level * level) - 29.5f * (float)level + 360.0f : 3.5f * (float)(level * level) - 151.5f * (float)level + 2220.0f));
    }

    public static int getExperienceToLevel(int startingLevel, int destinationLevel) {
        return EnchantmentUtils.getExperienceFromLevel(destinationLevel) - EnchantmentUtils.getExperienceFromLevel(startingLevel);
    }

    public static int getLevelsFromExperience(int exp) {
        int currentLevel = 0;
        float levelCap = EnchantmentUtils.getExperienceToLevel(currentLevel, currentLevel + 1);
        while ((float)exp >= levelCap) {
            exp = (int)((float)exp - levelCap);
            levelCap = EnchantmentUtils.getExperienceToLevel(++currentLevel, currentLevel + 1);
        }
        return currentLevel;
    }

    public static boolean areEnchantmentsCompatible(Enchantment firstEnchantment, Enchantment secondEnchantment) {
        return firstEnchantment.func_77326_a(secondEnchantment) && secondEnchantment.func_77326_a(firstEnchantment);
    }

    public static boolean isStackEnchanted(ItemStack stack) {
        return ItemStackUtils.isValidStack(stack) && EnchantmentUtils.getEnchantmentsFromStack(stack, stack.func_77973_b() instanceof ItemEnchantedBook).length > 0;
    }

    public static Enchantment[] getEnchantmentsFromStack(ItemStack stack, boolean stored) {
        ItemStackUtils.prepareDataTag(stack);
        String tagName = stored ? "StoredEnchantments" : "ench";
        NBTTagCompound tag = stack.field_77990_d;
        NBTTagList list = tag.func_150295_c(tagName, 10);
        Enchantment[] ench = new Enchantment[list.func_74745_c()];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            ench[i] = Enchantment.field_77331_b[list.func_150305_b(i).func_74765_d("id")];
        }
        return ench;
    }
}

