/*
 * Decompiled with CFR 0.152.
 */
package com.kuba6000.mobsinfo.api.utils;

import java.util.Objects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ItemID {
    private final Item item;
    private final int count;
    private final int meta;
    private final NBTTagCompound tag;
    private final boolean ignorecount;
    private final boolean ignoremeta;
    private final boolean ignorenbt;
    private int cachedHashCode = 0;

    public static ItemID create(ItemStack stack) {
        return new ItemID(stack, true, true, true, true);
    }

    public static ItemID create(ItemStack stack, boolean ignorecount) {
        return new ItemID(stack, ignorecount, false, false, true);
    }

    public static ItemID create(ItemStack stack, boolean ignorecount, boolean ignoremeta) {
        return new ItemID(stack, ignorecount, ignoremeta, false, true);
    }

    public static ItemID create(ItemStack stack, boolean ignorecount, boolean ignoremeta, boolean ignorenbt) {
        return new ItemID(stack, ignorecount, ignoremeta, ignorenbt, true);
    }

    public static ItemID createNoCopy(ItemStack stack) {
        return new ItemID(stack, true, false, false, false);
    }

    public static ItemID createNoCopy(ItemStack stack, boolean ignorecount) {
        return new ItemID(stack, ignorecount, false, false, false);
    }

    public static ItemID createNoCopy(ItemStack stack, boolean ignorecount, boolean ignoremeta) {
        return new ItemID(stack, ignorecount, ignoremeta, false, false);
    }

    public static ItemID createNoCopy(ItemStack stack, boolean ignorecount, boolean ignoremeta, boolean ignorenbt) {
        return new ItemID(stack, ignorecount, ignoremeta, ignorenbt, false);
    }

    private ItemID(ItemStack stack, boolean ignorecount, boolean ignoremeta, boolean ignorenbt, boolean createcopy) {
        this.ignorecount = ignorecount;
        this.ignoremeta = ignoremeta;
        this.ignorenbt = ignorenbt;
        this.item = stack.func_77973_b();
        this.count = ignorecount ? 0 : stack.field_77994_a;
        int n = this.meta = ignoremeta ? 0 : stack.func_77960_j();
        this.tag = ignorenbt ? null : (createcopy ? (NBTTagCompound)stack.field_77990_d.func_74737_b() : stack.field_77990_d);
    }

    public int hashCode() {
        int code = this.cachedHashCode;
        if (code == 0) {
            code = Objects.hash(this.item, this.count, this.meta, this.tag);
            if (code == 0) {
                code = 1;
            }
            this.cachedHashCode = code;
        }
        return code;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof ItemID) {
            ItemID other = (ItemID)obj;
            return this.item == other.item && this.count == other.count && this.meta == other.meta && Objects.equals(this.tag, other.tag);
        }
        if (obj instanceof ItemStack) {
            if (!this.item.equals(((ItemStack)obj).func_77973_b())) {
                return false;
            }
            if (!this.ignorecount && this.count != ((ItemStack)obj).field_77994_a) {
                return false;
            }
            if (!this.ignoremeta && this.meta != ((ItemStack)obj).func_77960_j()) {
                return false;
            }
            if (!this.ignorenbt) {
                if (this.tag == null) {
                    return ((ItemStack)obj).field_77990_d == null || ((ItemStack)obj).field_77990_d.func_82582_d();
                }
                return this.tag.equals((Object)((ItemStack)obj).field_77990_d);
            }
            return true;
        }
        return false;
    }
}

