/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.betterboat.entity;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.sanandrew.mods.betterboat.BetterBoat;
import de.sanandrew.mods.betterboat.network.PacketSendBoatPos;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityBetterBoat
extends Entity {
    private static final int DW_TIME_SINCE_HIT = 17;
    private static final int DW_FORWARD_DIRECTION = 18;
    private static final int DW_DMG_TAKEN = 19;
    private boolean isBoatEmpty = true;
    private double speedMultiplier = 0.07;
    private int boatPosRotationIncrements;
    private double boatX;
    private double boatY;
    private double boatZ;
    private double boatYaw;
    private double boatPitch;
    private double velocityX;
    private double velocityY;
    private double velocityZ;

    public EntityBetterBoat(World world) {
        super(world);
        this.field_70156_m = true;
        this.func_70105_a(1.5f, 0.6f);
        this.field_70129_M = this.field_70131_O / 2.0f;
    }

    public EntityBetterBoat(World world, double posX, double posY, double posZ) {
        this(world);
        this.func_70107_b(posX, posY + (double)this.field_70129_M, posZ);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = posX;
        this.field_70167_r = posY;
        this.field_70166_s = posZ;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(17, (Object)0);
        this.field_70180_af.func_75682_a(18, (Object)1);
        this.field_70180_af.func_75682_a(19, (Object)Float.valueOf(0.0f));
    }

    public AxisAlignedBB func_70114_g(Entity entity) {
        return entity.field_70121_D;
    }

    public AxisAlignedBB func_70046_E() {
        return this.field_70121_D;
    }

    public boolean func_70104_M() {
        return true;
    }

    public double func_70042_X() {
        return -0.3;
    }

    public boolean func_70097_a(DamageSource dmgSource, float damage) {
        if (this.func_85032_ar()) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            boolean isRiddenPlayerCreative;
            this.setForwardDirection(-this.getForwardDirection());
            this.setTimeSinceHit(10);
            this.setDamageTaken(this.getDamageTaken() + damage * 10.0f);
            this.func_70018_K();
            boolean bl = isRiddenPlayerCreative = dmgSource.func_76346_g() instanceof EntityPlayer && ((EntityPlayer)dmgSource.func_76346_g()).field_71075_bZ.field_75098_d;
            if (isRiddenPlayerCreative || this.getDamageTaken() > 40.0f) {
                if (this.field_70153_n != null) {
                    this.field_70153_n.func_70078_a((Entity)this);
                }
                if (!isRiddenPlayerCreative) {
                    this.func_145778_a(Items.field_151124_az, 1, 0.0f);
                }
                this.func_70106_y();
            }
            return true;
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70057_ab() {
        this.setForwardDirection(-this.getForwardDirection());
        this.setTimeSinceHit(10);
        this.setDamageTaken(this.getDamageTaken() * 11.0f);
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70056_a(double posX, double posY, double posZ, float yaw, float pitch, int posRotIncr) {
        if (this.isBoatEmpty) {
            this.boatPosRotationIncrements = posRotIncr + 5;
        } else {
            double deltaX = posX - this.field_70165_t;
            double deltaY = posY - this.field_70163_u;
            double deltaZ = posZ - this.field_70161_v;
            double deltaVec = deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ;
            if (deltaVec <= 1.0) {
                return;
            }
            this.boatPosRotationIncrements = 3;
        }
        this.boatX = posX;
        this.boatY = posY;
        this.boatZ = posZ;
        this.boatYaw = yaw;
        this.boatPitch = pitch;
        this.field_70159_w = this.velocityX;
        this.field_70181_x = this.velocityY;
        this.field_70179_y = this.velocityZ;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double motionX, double motionY, double motionZ) {
        this.velocityX = this.field_70159_w = motionX;
        this.velocityY = this.field_70181_x = motionY;
        this.velocityZ = this.field_70179_y = motionZ;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.getTimeSinceHit() > 0) {
            this.setTimeSinceHit(this.getTimeSinceHit() - 1);
        }
        if (this.getDamageTaken() > 0.0f) {
            this.setDamageTaken(this.getDamageTaken() - 1.0f);
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        double motionAmount = 0.0;
        for (int i = 0; i < 5; ++i) {
            double minY = this.field_70121_D.field_72338_b + (this.field_70121_D.field_72337_e - this.field_70121_D.field_72338_b) * (double)i / 5.0 - 0.125;
            double maxY = this.field_70121_D.field_72338_b + (this.field_70121_D.field_72337_e - this.field_70121_D.field_72338_b) * (double)(i + 1) / 5.0 - 0.125;
            AxisAlignedBB axisalignedbb = AxisAlignedBB.func_72330_a((double)this.field_70121_D.field_72340_a, (double)minY, (double)this.field_70121_D.field_72339_c, (double)this.field_70121_D.field_72336_d, (double)maxY, (double)this.field_70121_D.field_72334_f);
            if (!this.field_70170_p.func_72830_b(axisalignedbb, Material.field_151586_h)) continue;
            motionAmount += 0.2;
        }
        double horizMotion = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
        if (horizMotion > 0.2625) {
            double motionDirCos = Math.cos((double)this.field_70177_z * Math.PI / 180.0);
            double motionDirSin = Math.sin((double)this.field_70177_z * Math.PI / 180.0);
            for (double d = 0.0; d < 1.0 + horizMotion * 60.0; d += 1.0) {
                double particleZ;
                double particleX;
                double particlePosRnd1 = this.field_70146_Z.nextFloat() * 2.0f - 1.0f;
                double particlePosRnd2 = (double)(this.field_70146_Z.nextInt(2) * 2 - 1) * 0.7;
                if (this.field_70146_Z.nextBoolean()) {
                    particleX = this.field_70165_t - motionDirCos * particlePosRnd1 * 0.8 + motionDirSin * particlePosRnd2;
                    particleZ = this.field_70161_v - motionDirSin * particlePosRnd1 * 0.8 - motionDirCos * particlePosRnd2;
                } else {
                    particleX = this.field_70165_t + motionDirCos + motionDirSin * particlePosRnd1 * 0.7;
                    particleZ = this.field_70161_v + motionDirSin - motionDirCos * particlePosRnd1 * 0.7;
                }
                this.field_70170_p.func_72869_a("splash", particleX, this.field_70163_u - 0.125, particleZ, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            }
        }
        if (this.field_70170_p.field_72995_K && this.isBoatEmpty) {
            double newPosZ;
            double newPosY;
            double newPosX;
            if (this.boatPosRotationIncrements > 0) {
                float yawAngle = MathHelper.func_76142_g((float)((float)(this.boatYaw - (double)this.field_70177_z)));
                newPosX = this.field_70165_t + (this.boatX - this.field_70165_t) / (double)this.boatPosRotationIncrements;
                newPosY = this.field_70163_u + (this.boatY - this.field_70163_u) / (double)this.boatPosRotationIncrements;
                newPosZ = this.field_70161_v + (this.boatZ - this.field_70161_v) / (double)this.boatPosRotationIncrements;
                this.field_70177_z += yawAngle / (float)this.boatPosRotationIncrements;
                this.field_70125_A = (float)((double)this.field_70125_A + (this.boatPitch - (double)this.field_70125_A) / (double)this.boatPosRotationIncrements);
                --this.boatPosRotationIncrements;
                this.func_70107_b(newPosX, newPosY, newPosZ);
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
            } else {
                newPosX = this.field_70165_t + this.field_70159_w;
                newPosY = this.field_70163_u + this.field_70181_x;
                newPosZ = this.field_70161_v + this.field_70179_y;
                this.func_70107_b(newPosX, newPosY, newPosZ);
                if (this.field_70122_E) {
                    this.field_70159_w *= 0.5;
                    this.field_70181_x *= 0.5;
                    this.field_70179_y *= 0.5;
                }
                this.field_70159_w *= 0.99;
                this.field_70181_x *= 0.95;
                this.field_70179_y *= 0.99;
            }
        } else {
            double yawAngle;
            double motionVal;
            if (motionAmount < 1.0) {
                motionVal = motionAmount * 2.0 - 1.0;
                this.field_70181_x += 0.04 * motionVal;
            } else {
                if (this.field_70181_x < 0.0) {
                    this.field_70181_x /= 2.0;
                }
                this.field_70181_x += (double)0.007f;
            }
            if (this.field_70153_n != null && this.field_70153_n instanceof EntityLivingBase) {
                EntityLivingBase riddenLiving = (EntityLivingBase)this.field_70153_n;
                float sideMotion = this.field_70153_n.field_70177_z + -riddenLiving.field_70702_br * 90.0f;
                this.field_70159_w += -Math.sin(sideMotion * (float)Math.PI / 180.0f) * this.speedMultiplier * (double)riddenLiving.field_70701_bs * 0.05;
                this.field_70179_y += Math.cos(sideMotion * (float)Math.PI / 180.0f) * this.speedMultiplier * (double)riddenLiving.field_70701_bs * 0.05;
            }
            if ((motionVal = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y)) > 0.35) {
                double motionValRecur = 0.35 / motionVal;
                this.field_70159_w *= motionValRecur;
                this.field_70179_y *= motionValRecur;
                motionVal = 0.35;
            }
            if (motionVal > horizMotion && this.speedMultiplier < 0.35) {
                this.speedMultiplier += (0.35 - this.speedMultiplier) / 35.0;
                if (this.speedMultiplier > 0.35) {
                    this.speedMultiplier = 0.35;
                }
            } else {
                this.speedMultiplier -= (this.speedMultiplier - 0.07) / 35.0;
                if (this.speedMultiplier < 0.07) {
                    this.speedMultiplier = 0.07;
                }
            }
            for (int i = 0; i < 4; ++i) {
                int blockX = MathHelper.func_76128_c((double)(this.field_70165_t + ((double)(i % 2) - 0.5) * 0.8));
                int blockZ = MathHelper.func_76128_c((double)(this.field_70161_v + ((double)(i / 2) - 0.5) * 0.8));
                for (int j = 0; j < 2; ++j) {
                    int blockY = MathHelper.func_76128_c((double)this.field_70163_u) + j;
                    Block block = this.field_70170_p.func_147439_a(blockX, blockY, blockZ);
                    if (block == Blocks.field_150431_aC) {
                        this.field_70170_p.func_147468_f(blockX, blockY, blockZ);
                        this.field_70123_F = false;
                        continue;
                    }
                    if (block != Blocks.field_150392_bi) continue;
                    this.field_70170_p.func_147480_a(blockX, blockY, blockZ, true);
                    this.field_70123_F = false;
                }
            }
            if (this.field_70122_E) {
                this.field_70159_w *= 0.5;
                this.field_70181_x *= 0.5;
                this.field_70179_y *= 0.5;
            }
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70125_A = 0.0f;
            double yaw = this.field_70177_z;
            double deltaPosX = this.field_70169_q - this.field_70165_t;
            double deltaPosZ = this.field_70166_s - this.field_70161_v;
            if (deltaPosX * deltaPosX + deltaPosZ * deltaPosZ > 0.001) {
                yaw = (float)(Math.atan2(deltaPosZ, deltaPosX) * 180.0 / Math.PI);
            }
            if ((yawAngle = MathHelper.func_76138_g((double)(yaw - (double)this.field_70177_z))) > 20.0) {
                yawAngle = 20.0;
            }
            if (yawAngle < -20.0) {
                yawAngle = -20.0;
            }
            this.field_70177_z = (float)((double)this.field_70177_z + yawAngle);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            if (!this.field_70170_p.field_72995_K) {
                List collidedEntities = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(0.2, 0.0, 0.2));
                if (collidedEntities != null && !collidedEntities.isEmpty()) {
                    for (Object entityObj : collidedEntities) {
                        Entity entity = (Entity)entityObj;
                        if (entity == this.field_70153_n) continue;
                        if (entity.func_70104_M() && entity instanceof EntityBoat) {
                            entity.func_70108_f((Entity)this);
                            continue;
                        }
                        if (!(entity instanceof EntityLivingBase)) continue;
                        entity.func_70108_f((Entity)this);
                        this.field_70123_F = false;
                        if (!(horizMotion > 0.2)) continue;
                        entity.func_70097_a(DamageSource.func_76354_b((Entity)this, (Entity)(this.field_70153_n != null ? this.field_70153_n : this)), (float)(horizMotion * 5.0));
                    }
                }
                if (this.field_70153_n != null && this.field_70153_n.field_70128_L) {
                    this.field_70153_n = null;
                }
                if (this.field_70173_aa % 20 == 0) {
                    BetterBoat.network.sendToAllAround((IMessage)new PacketSendBoatPos(this), new NetworkRegistry.TargetPoint(this.field_71093_bK, this.field_70165_t, this.field_70163_u, this.field_70161_v, 128.0));
                }
            }
            if (this.field_70123_F && horizMotion > 0.2) {
                if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
                    this.func_70106_y();
                    if (!(this.field_70153_n instanceof EntityPlayer) || !((EntityPlayer)this.field_70153_n).field_71075_bZ.field_75098_d) {
                        this.func_145778_a(Items.field_151124_az, 1, 0.0f);
                    }
                }
            } else {
                this.field_70159_w *= 0.99;
                this.field_70181_x *= 0.95;
                this.field_70179_y *= 0.99;
            }
        }
    }

    public void func_70043_V() {
        if (this.field_70153_n != null) {
            double xOffset = Math.cos((double)this.field_70177_z * Math.PI / 180.0) * 0.4;
            double zOffset = Math.sin((double)this.field_70177_z * Math.PI / 180.0) * 0.4;
            this.field_70153_n.func_70107_b(this.field_70165_t + xOffset, this.field_70163_u + this.func_70042_X() + this.field_70153_n.func_70033_W(), this.field_70161_v + zOffset);
        }
    }

    protected void func_70014_b(NBTTagCompound nbt) {
    }

    protected void func_70037_a(NBTTagCompound nbt) {
    }

    @SideOnly(value=Side.CLIENT)
    public float func_70053_R() {
        return 0.0f;
    }

    public boolean func_130002_c(EntityPlayer player) {
        if (this.field_70153_n != null && this.field_70153_n instanceof EntityPlayer && this.field_70153_n != player) {
            return true;
        }
        if (!this.field_70170_p.field_72995_K) {
            player.func_70078_a((Entity)this);
        }
        return true;
    }

    protected void func_70064_a(double tickDistance, boolean onGround) {
        int blockX = MathHelper.func_76128_c((double)this.field_70165_t);
        int blockY = MathHelper.func_76128_c((double)this.field_70163_u);
        int blockZ = MathHelper.func_76128_c((double)this.field_70161_v);
        if (onGround) {
            if (this.field_70143_R > 3.0f) {
                this.func_70069_a(this.field_70143_R);
                if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
                    this.func_70106_y();
                    if (!(this.field_70153_n instanceof EntityPlayer) || !((EntityPlayer)this.field_70153_n).field_71075_bZ.field_75098_d) {
                        this.func_145778_a(Items.field_151124_az, 1, 0.0f);
                    }
                }
                this.field_70143_R = 0.0f;
            }
        } else if (this.field_70170_p.func_147439_a(blockX, blockY - 1, blockZ).func_149688_o() != Material.field_151586_h && tickDistance < 0.0) {
            this.field_70143_R = (float)((double)this.field_70143_R - tickDistance);
        }
    }

    public void setDamageTaken(float damage) {
        this.field_70180_af.func_75692_b(19, (Object)Float.valueOf(damage));
    }

    public float getDamageTaken() {
        return this.field_70180_af.func_111145_d(19);
    }

    public void setTimeSinceHit(int time) {
        this.field_70180_af.func_75692_b(17, (Object)time);
    }

    public int getTimeSinceHit() {
        return this.field_70180_af.func_75679_c(17);
    }

    public void setForwardDirection(int direction) {
        this.field_70180_af.func_75692_b(18, (Object)direction);
    }

    public int getForwardDirection() {
        return this.field_70180_af.func_75679_c(18);
    }
}

