/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Auxiliary;

import Reika.DragonAPI.Instantiable.Formula.LogarithmExpression;
import Reika.DragonAPI.Instantiable.Formula.MathExpression;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.RotaryCraft.Auxiliary.Interfaces.OverrunExpression;

public class DurationFormula
extends LogarithmExpression
implements OverrunExpression {
    private SurplusExpression surplus;
    private final int threshold;

    public DurationFormula(int b, int c) {
        super((double)b, (double)(-c), 2.0);
        this.surplus = new SurplusExpression(b, c);
        this.threshold = ReikaMathLibrary.intpow2((int)2, (int)(1 + b / c));
    }

    @Override
    public int getOverrun(int omega) {
        return omega >= this.threshold ? (int)this.surplus.evaluate(omega) : 0;
    }

    private static class SurplusExpression
    extends MathExpression {
        private final int base;
        private final int constant;

        private SurplusExpression(int b, int c) {
            this.base = b;
            this.constant = c;
        }

        public double evaluate(double arg) throws ArithmeticException {
            return ReikaMathLibrary.logbase((double)arg, (double)2.0) - (double)(this.base / this.constant);
        }

        public double getBaseValue() {
            return 0.0;
        }

        public String toString() {
            return "";
        }
    }
}

