/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Auxiliary;

import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.init.Items;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

@SideOnly(value=Side.CLIENT)
public class EntityEnderFX
extends EntityFX {
    private float scale;
    private boolean noSlow = false;
    private boolean rapidExpand = false;
    private AxisAlignedBB bounds = null;
    private double collideAngle;
    private boolean colliding = false;
    private int lifeFreeze;
    private int preColor = -1;
    private int fadeColor = -1;

    public EntityEnderFX(World world, double x, double y, double z, double vx, double vy, double vz, int color) {
        super(world, x, y, z, vx, vy, vz);
        this.field_70545_g = 0.0f;
        this.field_70145_X = true;
        this.field_70547_e = 60;
        this.field_70159_w = vx;
        this.field_70181_x = vy;
        this.field_70179_y = vz;
        this.scale = 1.0f;
        this.field_70552_h = (float)ReikaColorAPI.getRed((int)color) / 255.0f;
        this.field_70553_i = (float)ReikaColorAPI.getGreen((int)color) / 255.0f;
        this.field_70551_j = (float)ReikaColorAPI.getBlue((int)color) / 255.0f;
        this.field_70550_a = Items.field_151079_bi.func_77617_a(0);
    }

    public EntityEnderFX setIcon(IIcon ico) {
        this.field_70550_a = ico;
        return this;
    }

    public EntityEnderFX setScale(float f) {
        this.scale = f;
        return this;
    }

    public final EntityEnderFX setLife(int time) {
        this.field_70547_e = time;
        return this;
    }

    public final EntityEnderFX setNoSlowdown() {
        this.noSlow = true;
        return this;
    }

    public EntityEnderFX setRapidExpand() {
        this.rapidExpand = true;
        return this;
    }

    public final EntityEnderFX setGravity(float g) {
        this.field_70545_g = g;
        return this;
    }

    public final EntityEnderFX setColor(int r, int g, int b) {
        this.field_70552_h = (float)r / 255.0f;
        this.field_70553_i = (float)g / 255.0f;
        this.field_70551_j = (float)b / 255.0f;
        return this;
    }

    public final EntityEnderFX setColor(int rgb) {
        return this.setColor(ReikaColorAPI.getRed((int)rgb), ReikaColorAPI.getGreen((int)rgb), ReikaColorAPI.getBlue((int)rgb));
    }

    public final EntityEnderFX fadeColors(int c1, int c2) {
        this.preColor = c1;
        this.fadeColor = c2;
        return this.setColor(c1);
    }

    public final EntityEnderFX bound(AxisAlignedBB box) {
        this.bounds = box;
        return this;
    }

    public final EntityEnderFX setColliding() {
        return this.setColliding(this.field_70146_Z.nextDouble() * 360.0);
    }

    public final EntityEnderFX setColliding(double ang) {
        this.field_70145_X = false;
        this.colliding = true;
        this.collideAngle = ang;
        return this;
    }

    public void func_70071_h_() {
        if (this.colliding) {
            if (this.field_70124_G) {
                double v = this.field_70146_Z.nextDouble() * 0.0625;
                this.field_70159_w = v * Math.sin(Math.toRadians(this.collideAngle));
                this.field_70179_y = v * Math.cos(Math.toRadians(this.collideAngle));
                this.colliding = false;
                this.setNoSlowdown();
                this.lifeFreeze = 20;
                this.field_70545_g *= 4.0f;
            }
            if (this.field_70123_F) {
                // empty if block
            }
        }
        if (this.noSlow) {
            double mx = this.field_70159_w;
            double my = this.field_70181_x;
            double mz = this.field_70179_y;
            super.func_70071_h_();
            this.field_70159_w = mx;
            this.field_70181_x = my;
            this.field_70179_y = mz;
        } else {
            super.func_70071_h_();
        }
        if (this.lifeFreeze > 0) {
            --this.lifeFreeze;
            --this.field_70546_d;
        }
        if (this.fadeColor != -1) {
            int c = ReikaColorAPI.mixColors((int)this.fadeColor, (int)this.preColor, (float)((float)this.field_70546_d / (float)this.field_70547_e));
            this.setColor(c);
        }
        this.field_70544_f = this.rapidExpand ? this.scale * (this.field_70547_e / this.field_70546_d >= 12 ? (float)this.field_70546_d * 12.0f / (float)this.field_70547_e : 1.0f - (float)this.field_70546_d / (float)this.field_70547_e) : this.scale * (float)Math.sin(Math.toRadians(180.0 * (double)this.field_70546_d / (double)this.field_70547_e));
        if (this.bounds != null) {
            if (this.field_70165_t <= this.bounds.field_72340_a && this.field_70159_w < 0.0 || this.field_70165_t >= this.bounds.field_72336_d && this.field_70159_w > 0.0) {
                this.field_70159_w = -this.field_70159_w;
            }
            if (this.field_70163_u <= this.bounds.field_72338_b && this.field_70181_x < 0.0 || this.field_70163_u >= this.bounds.field_72337_e && this.field_70181_x > 0.0) {
                this.field_70181_x = -this.field_70181_x;
            }
            if (this.field_70161_v <= this.bounds.field_72339_c && this.field_70179_y < 0.0 || this.field_70161_v >= this.bounds.field_72334_f && this.field_70179_y > 0.0) {
                this.field_70179_y = -this.field_70179_y;
            }
        }
    }

    public void func_70539_a(Tessellator v5, float par2, float par3, float par4, float par5, float par6, float par7) {
        ReikaTextureHelper.bindItemTexture();
        super.func_70539_a(v5, par2, par3, par4, par5, par6, par7);
    }

    public int func_70070_b(float par1) {
        return 240;
    }

    public int func_70537_b() {
        return 2;
    }
}

