/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Auxiliary.RecipeManagers;

import Reika.ChromatiCraft.API.ChromatiAPI;
import Reika.ChromatiCraft.API.CrystalElementAccessor;
import Reika.ChromatiCraft.API.DyeTreeAPI;
import Reika.DragonAPI.Instantiable.Data.Maps.ItemHashMap;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.ForestryHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.IC2Handler;
import Reika.DragonAPI.ModList;
import Reika.DragonAPI.ModRegistry.ModCropList;
import Reika.DragonAPI.ModRegistry.ModWoodList;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Registry.PlantMaterials;
import Reika.RotaryCraft.RotaryCraft;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class MulchMaterials {
    public static final MulchMaterials instance = new MulchMaterials();
    private final ItemHashMap<Integer> values = new ItemHashMap().setOneWay();

    private MulchMaterials() {
        int i;
        ItemStack core;
        if (ModList.CHROMATICRAFT.isLoaded()) {
            DyeTreeAPI api = ChromatiAPI.getAPI().trees();
            for (int i2 = 0; i2 < 16; ++i2) {
                CrystalElementAccessor.CrystalElementProxy e = CrystalElementAccessor.getByIndex((int)i2);
                this.addValue(api.getDyeSapling(e), PlantMaterials.SAPLING.getPlantValue());
                this.addValue(api.getDyeLeaf(e, false), PlantMaterials.LEAVES.getPlantValue());
                this.addValue(api.getDyeFlower(e), PlantMaterials.FLOWER.getPlantValue());
            }
            this.addValue(api.getRainbowLeaf(), 16);
            this.addValue(api.getRainbowSapling(), 8);
        }
        if (ModList.FORESTRY.isLoaded()) {
            this.addValue(ForestryHandler.ItemEntry.SAPLING.getItem(), 2);
            this.addValue(ForestryHandler.ItemEntry.HONEY.getItem(), 1);
            this.addValue(ForestryHandler.ItemEntry.HONEYDEW.getItem(), 1);
            this.addValue(ForestryHandler.BlockEntry.LEAF.getBlock(), 4);
        }
        if (ModList.EMASHER.isLoaded()) {
            this.addValue(ModCropList.ALGAE.blockID, 3);
        }
        if (ModList.IC2.isLoaded()) {
            ItemStack chaff;
            ItemStack plantball = ReikaItemHelper.lookupItem((String)"IC2:itemFuelPlantBall");
            if (plantball != null) {
                this.addValue(plantball, 2);
            }
            if ((chaff = IC2Handler.IC2Stacks.BIOCHAFF.getItem()) != null) {
                this.addValue(chaff, 1);
            }
        }
        if (ModList.BOTANIA.isLoaded()) {
            Item petal = GameRegistry.findItem((String)ModList.BOTANIA.modLabel, (String)"petal");
            Block flower = GameRegistry.findBlock((String)ModList.BOTANIA.modLabel, (String)"flower");
            Block tallflower1 = GameRegistry.findBlock((String)ModList.BOTANIA.modLabel, (String)"doubleFlower1");
            Block tallflower2 = GameRegistry.findBlock((String)ModList.BOTANIA.modLabel, (String)"doubleFlower2");
            for (int i3 = 0; i3 < 16; ++i3) {
                Block tall = i3 >= 8 ? tallflower2 : tallflower1;
                int tallm = i3 % 8;
                this.addValue(new ItemStack(flower, 1, i3), 4);
                this.addValue(new ItemStack(tall, 1, tallm), 8);
                this.addValue(new ItemStack(petal, 1, i3), 2);
            }
        }
        if (Loader.isModLoaded((String)"Growthcraft|Apples") && (core = ReikaItemHelper.lookupItem((String)"Growthcraft|Apples:grc.appleSeeds")) != null) {
            this.addValue(core, 1);
        }
        for (i = 0; i < ModWoodList.woodList.length; ++i) {
            ModWoodList wood = ModWoodList.woodList[i];
            if (!wood.exists()) continue;
            this.addValue(wood.getCorrespondingSapling(), PlantMaterials.SAPLING.getPlantValue() * this.getModWoodValue(wood));
            for (ItemStack leaf : wood.getAllLeaves()) {
                if (leaf == null || leaf.func_77973_b() == null) {
                    RotaryCraft.logger.logError((Object)("Tried to add mulch recipe for a stack (" + wood + " leaves) which does not exist!"));
                    continue;
                }
                if (this.values.containsKey(leaf)) continue;
                this.addValue(leaf, PlantMaterials.LEAVES.getPlantValue() * this.getModWoodValue(wood));
            }
        }
        for (i = 0; i < PlantMaterials.plantList.length; ++i) {
            PlantMaterials plant = PlantMaterials.plantList[i];
            int[] metas = plant.getMetadatas();
            for (int k = 0; k < metas.length; ++k) {
                ItemStack is = plant.getPlantItem();
                is.func_77964_b(metas[k]);
                this.addValue(is, plant.getPlantValue());
            }
        }
        this.addValue(ItemStacks.sawdust.func_77946_l(), 1);
    }

    private void addValue(Item i, int amt) {
        this.addValue(new ItemStack(i), amt);
    }

    private void addValue(Block i, int amt) {
        this.addValue(new ItemStack(i), amt);
    }

    private void addValue(ItemStack is, int amt) {
        if (is == null || is.func_77973_b() == null) {
            RotaryCraft.logger.logError((Object)"Tried to add mulch recipe for a stack which does not exist!");
            Thread.dumpStack();
            return;
        }
        if (amt <= 0) {
            RotaryCraft.logger.logError((Object)("Tried to add mulch recipe for " + is + " (" + is.func_82833_r() + ") that produces zero sludge?!"));
            return;
        }
        this.values.put(is, (Object)amt);
    }

    public Collection<ItemStack> getAllValidPlants() {
        return this.values.keySet();
    }

    public boolean isMulchable(ItemStack is) {
        return this.values.containsKey(is);
    }

    public int getPlantValue(ItemStack is) {
        Integer ret = (Integer)this.values.get(is);
        return ret != null ? ret : 0;
    }

    private int getModWoodValue(ModWoodList wood) {
        if (wood == null) {
            return 0;
        }
        if (wood.isRareTree()) {
            return 32;
        }
        if (wood == ModWoodList.LIGHTED) {
            return 12;
        }
        ModList mod = wood.getParentMod();
        if (mod == ModList.THAUMCRAFT) {
            return 4;
        }
        if (mod == ModList.TWILIGHT) {
            return 3;
        }
        return 1;
    }
}

