/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Auxiliary;

import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.Exception.RegistrationException;
import Reika.DragonAPI.Interfaces.TileEntity.RenderFetcher;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.RotaryCraft.Base.RotaryTERenderer;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.RotaryCraft;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;

@SideOnly(value=Side.CLIENT)
public class RotaryRenderList {
    private static HashMap<MachineRegistry, RotaryTERenderer> renders = new HashMap();
    private static HashMap<MachineRegistry, MachineRegistry> overrides = new HashMap();

    public static boolean addRender(MachineRegistry m, RotaryTERenderer r) {
        if (!renders.containsValue((Object)r)) {
            renders.put(m, r);
            return true;
        }
        MachineRegistry parent = (MachineRegistry)((Object)ReikaJavaLibrary.getHashMapKeyByValue(renders, (Object)((Object)r)));
        overrides.put(m, parent);
        return false;
    }

    public static RotaryTERenderer getRenderForMachine(MachineRegistry m) {
        if (overrides.containsKey((Object)m)) {
            return renders.get((Object)overrides.get((Object)m));
        }
        return renders.get((Object)m);
    }

    public static String getRenderTexture(MachineRegistry m, RenderFetcher te) {
        return RotaryRenderList.getRenderForMachine(m).getImageFileName(te);
    }

    public static RotaryTERenderer instantiateRenderer(MachineRegistry m) {
        if (RotaryCraft.instance.isLocked()) {
            return null;
        }
        try {
            RotaryTERenderer r = (RotaryTERenderer)((Object)Class.forName(m.getRenderer()).newInstance());
            if (RotaryRenderList.addRender(m, r)) {
                return r;
            }
            return renders.get((Object)overrides.get((Object)m));
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            throw new RuntimeException("Tried to call nonexistent render " + m.getRenderer() + "!");
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new RuntimeException("Tried to call illegal render " + m.getRenderer() + "!");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new RegistrationException((DragonAPIMod)RotaryCraft.instance, "No class found for Renderer " + m.getRenderer() + "!");
        }
    }
}

