/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Auxiliary;

import Reika.DragonAPI.Instantiable.Data.BlockStruct.BlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Maps.ValueSortedMap;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModInteract.DeepInteract.PlanetDimensionHandler;
import Reika.RotaryCraft.Auxiliary.Interfaces.SolarPlantBlock;
import Reika.RotaryCraft.Registry.BlockRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.TileEntities.Auxiliary.TileEntityMirror;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.TreeMap;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class SolarPlant {
    private static final float TOWER_FALLOFF = 0.72f;
    public static int MAX_TOWER_HEIGHT;
    public static int MAX_TOWER_VALUE;
    private static final TreeMap<Integer, Integer> towerRounding;
    private final ValueSortedMap<Coordinate, SolarTower> towers = new ValueSortedMap();
    private final HashMap<Coordinate, Coordinate> mirrors = new HashMap();
    private final HashMap<Coordinate, Integer> mirrorLevels = new HashMap();

    public static SolarPlant build(World world, int x, int y, int z) {
        SolarPlant p = new SolarPlant();
        BlockArray blocks = new BlockArray();
        blocks.recursiveAdd((IBlockAccess)world, x, y, z, BlockRegistry.SOLAR.getBlockInstance());
        HashMap<Coordinate, ImmutablePair> towerLocations = new HashMap<Coordinate, ImmutablePair>();
        ArrayList<Coordinate> li = new ArrayList<Coordinate>();
        while (blocks.getSize() > 0) {
            Coordinate c = blocks.getNextAndMoveOn();
            SolarPlantBlock b = (SolarPlantBlock)c.getTileEntity((IBlockAccess)world);
            b.setPlant(p);
            MachineRegistry m = MachineRegistry.getMachine((IBlockAccess)world, c.xCoord, c.yCoord, c.zCoord);
            if (m == MachineRegistry.MIRROR) {
                li.add(c);
                continue;
            }
            if (m != MachineRegistry.SOLARTOWER) continue;
            ImmutablePair get = (ImmutablePair)towerLocations.get(c.to2D());
            int val1 = get != null ? (Integer)get.left : Integer.MAX_VALUE;
            int val2 = get != null ? (Integer)get.right : Integer.MIN_VALUE;
            val1 = Math.min(val1, c.yCoord);
            val2 = Math.max(val2, c.yCoord);
            towerLocations.put(c.to2D(), new ImmutablePair((Object)val1, (Object)val2));
        }
        for (Coordinate c : towerLocations.keySet()) {
            ImmutablePair ys = (ImmutablePair)towerLocations.get(c);
            int dy = (Integer)ys.left;
            int h = 0;
            while (MachineRegistry.getMachine((IBlockAccess)world, c.xCoord, dy, c.zCoord) == MachineRegistry.SOLARTOWER && dy <= (Integer)ys.left + MAX_TOWER_HEIGHT) {
                if (ReikaWorldHelper.checkForAdjBlock((World)world, (int)c.xCoord, (int)(++dy), (int)c.zCoord, (Block)MachineRegistry.MIRROR.getBlock(), (int)MachineRegistry.MIRROR.getBlockMetadata()) != null) {
                    h = 0;
                }
                ++h;
            }
            SolarPlant solarPlant = p;
            solarPlant.getClass();
            SolarTower s = solarPlant.new SolarTower(c, h, (Integer)ys.left, (Integer)ys.right);
            p.towers.put((Object)c, (Object)s);
        }
        for (Coordinate c : li) {
            p.addMirror(c, SolarPlant.getClosestTower(c, towerLocations.keySet()));
        }
        return p;
    }

    private void addMirror(Coordinate c, Coordinate tower) {
        this.mirrors.put(c, tower);
        Integer get = this.mirrorLevels.get(c.to2D());
        int val = get != null ? get : -1;
        int max = Math.max(val, c.yCoord);
        this.mirrorLevels.put(c.to2D(), max);
    }

    private static Coordinate getClosestTower(Coordinate c, Collection<Coordinate> locs) {
        double dist = Double.POSITIVE_INFINITY;
        Coordinate closest = null;
        for (Coordinate c2 : locs) {
            double dd = c2.getDistanceTo(c);
            if (!(dd < dist)) continue;
            dist = dd;
            closest = c2;
        }
        return closest;
    }

    private boolean isHighestMirror(TileEntityMirror te) {
        Integer get = this.mirrorLevels.get(new Coordinate((TileEntity)te).to2D());
        return get != null ? te.field_145848_d >= get : false;
    }

    public int towerCount() {
        return this.towers.size();
    }

    public int mirrorCount() {
        return this.mirrors.size();
    }

    public int rawTowerBlocks() {
        int ret = 0;
        for (SolarTower val : this.towers.values()) {
            ret += val.effectiveHeight;
        }
        return ret;
    }

    public int getEffectiveTowerBlocks() {
        float f = 1.0f;
        int sum = 0;
        for (SolarTower val : this.towers.values()) {
            sum = (int)((float)sum + (float)val.effectiveHeight * f);
            f *= 0.72f;
        }
        sum = towerRounding.floorEntry(sum).getValue();
        return sum;
    }

    public Coordinate getPrimaryTower() {
        return this.towers.isEmpty() ? null : ((SolarTower)this.towers.getFirst()).location;
    }

    public Coordinate getAimingPositionForMirror(TileEntityMirror te) {
        if (this.towers.isEmpty()) {
            return null;
        }
        Coordinate c = this.mirrors.get(new Coordinate((TileEntity)te));
        return c.offset(0, ((SolarTower)this.towers.get((Object)c)).topBlock, 0);
    }

    public float getOverallBrightness(World world) {
        float f = 0.0f;
        for (Coordinate c : this.mirrors.keySet()) {
            TileEntityMirror tm;
            TileEntity te = c.getTileEntity((IBlockAccess)world);
            if (!(te instanceof TileEntityMirror) || !(tm = (TileEntityMirror)te).isFunctional()) continue;
            f += 1.0f;
        }
        return (f /= (float)this.mirrorCount()) * this.getLightLevel(world) / 15.0f;
    }

    public float getLightLevel(World world) {
        float phase;
        if (world.field_73011_w.field_76574_g == -1 || world.field_73011_w.field_76574_g == 1) {
            return 0.0f;
        }
        if (world.field_73011_w.field_76576_e) {
            return 0.0f;
        }
        double sun = (double)(ReikaWorldHelper.getSunIntensity((World)world, (boolean)true, (float)0.0f) * 0.8f + 0.2f) * PlanetDimensionHandler.getSunIntensity((World)world);
        if (sun > 0.21) {
            return (int)(15.0 * sun);
        }
        int moon = world.field_73011_w.func_76559_b(world.func_72912_H().func_76073_f());
        switch (moon) {
            case 0: {
                phase = 1.0f;
                break;
            }
            case 1: 
            case 7: {
                phase = 0.8f;
                break;
            }
            case 2: 
            case 6: {
                phase = 0.5f;
                break;
            }
            case 3: 
            case 5: {
                phase = 0.2f;
                break;
            }
            case 4: {
                phase = 0.05f;
                break;
            }
            default: {
                phase = 0.0f;
            }
        }
        return 3.0f * phase;
    }

    public int getTowerMultiplier() {
        return Math.min(this.getEffectiveTowerBlocks(), MAX_TOWER_VALUE);
    }

    public void invalidate(World world) {
        for (Coordinate c : this.mirrors.keySet()) {
            SolarPlantBlock b = (SolarPlantBlock)c.getTileEntity((IBlockAccess)world);
            b.setPlant(null);
        }
        for (SolarTower s : this.towers.values()) {
            for (int y = s.bottomBlock; y <= s.topBlock; ++y) {
                SolarPlantBlock b = (SolarPlantBlock)s.location.offset(0, y, 0).getTileEntity((IBlockAccess)world);
                if (b == null) continue;
                b.setPlant(null);
            }
        }
        this.towers.clear();
        this.mirrors.clear();
    }

    public boolean canSeeTheSky(TileEntityMirror te) {
        return te.field_145850_b.func_72937_j(te.field_145851_c, te.field_145848_d + 1, te.field_145849_e) && this.isHighestMirror(te);
    }

    static {
        int i;
        MAX_TOWER_HEIGHT = 32;
        MAX_TOWER_VALUE = 96;
        towerRounding = new TreeMap();
        for (i = 0; i <= 6; ++i) {
            towerRounding.put(i, i);
        }
        for (i = 8; i <= 12; i += 2) {
            towerRounding.put(i, i);
        }
        for (i = 16; i <= 24; i += 4) {
            towerRounding.put(i, i);
        }
        towerRounding.put(MAX_TOWER_HEIGHT, MAX_TOWER_HEIGHT);
    }

    private class SolarTower
    implements Comparable<SolarTower> {
        private final Coordinate location;
        private final int effectiveHeight;
        private final int bottomBlock;
        private final int topBlock;

        private SolarTower(Coordinate c, int h, int bottom, int top) {
            this.location = c;
            this.effectiveHeight = h;
            this.bottomBlock = bottom;
            this.topBlock = top;
        }

        public int hashCode() {
            return this.location.hashCode() | this.effectiveHeight << 24;
        }

        @Override
        public int compareTo(SolarTower o) {
            int ret = -Integer.compare(this.effectiveHeight, o.effectiveHeight);
            return ret != 0 ? ret : Integer.compare(this.hashCode(), o.hashCode());
        }
    }
}

