/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Auxiliary;

import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.RotaryCraft.API.Power.PowerAcceptor;
import Reika.RotaryCraft.Auxiliary.ShaftPowerBus;
import Reika.RotaryCraft.Base.TileEntity.TileEntityIOMachine;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPowerReceiver;
import Reika.RotaryCraft.Base.TileEntity.TileEntityTransmissionMachine;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.TileEntities.Auxiliary.TileEntityFurnaceHeater;
import Reika.RotaryCraft.TileEntities.Processing.TileEntityExtractor;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityAdvancedGear;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityBeltHub;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityBusController;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityClutch;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityFlywheel;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityGearbox;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityPowerBus;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityShaft;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntitySplitter;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class TorqueUsage {
    private static double requiredTorque;
    private static final HashSet<WorldLocation> pathCache;

    public static int getTorque(TileEntityFlywheel te) {
        requiredTorque = 0.0;
        TorqueUsage.recursiveFind(te.getWriteTileEntity(), te, 1.0);
        if (requiredTorque < 0.0) {
            requiredTorque = 0.0;
        }
        pathCache.clear();
        return (int)Math.ceil(requiredTorque);
    }

    private static void recursiveFind(TileEntity tile, TileEntityFlywheel reader, double activeRatio) {
        if (tile == null) {
            return;
        }
        WorldLocation loc = new WorldLocation(tile);
        if (pathCache.contains(loc)) {
            return;
        }
        pathCache.add(loc);
        if (tile instanceof TileEntityTransmissionMachine) {
            TileEntityIOMachine io = (TileEntityIOMachine)tile;
            if (tile instanceof TileEntitySplitter) {
                TileEntitySplitter spl = (TileEntitySplitter)tile;
                if (!spl.isSplitting()) {
                    TileEntity write = spl.getWriteTileEntity();
                    if (TorqueUsage.isPoweredFrom(write, spl)) {
                        TorqueUsage.recursiveFind(write, reader, activeRatio);
                    }
                } else {
                    TileEntity di = spl.getWriteTileEntity();
                    TileEntity di2 = spl.getWriteTileEntity2();
                    if (TorqueUsage.isPoweredFrom(di, spl)) {
                        TorqueUsage.recursiveFind(di, reader, activeRatio);
                    }
                    if (TorqueUsage.isPoweredFrom(di2, spl)) {
                        TorqueUsage.recursiveFind(di2, reader, activeRatio);
                    }
                }
            } else if (tile instanceof TileEntityFlywheel) {
                requiredTorque += activeRatio * (double)((TileEntityFlywheel)tile).getOppTorque(reader);
            } else if (tile instanceof TileEntityClutch) {
                TileEntityClutch clu = (TileEntityClutch)tile;
                if (clu.isOutputEnabled() && TorqueUsage.isPoweredFrom(clu.getWriteTileEntity(), clu)) {
                    TorqueUsage.recursiveFind(clu.getWriteTileEntity(), reader, activeRatio);
                }
            } else if (tile instanceof TileEntityGearbox) {
                TileEntityGearbox gbx = (TileEntityGearbox)tile;
                if (TorqueUsage.isPoweredFrom(gbx.getWriteTileEntity(), gbx)) {
                    if (gbx.reduction) {
                        TorqueUsage.recursiveFind(gbx.getWriteTileEntity(), reader, activeRatio / (double)gbx.getRatio());
                    } else {
                        TorqueUsage.recursiveFind(gbx.getWriteTileEntity(), reader, activeRatio * (double)gbx.getRatio());
                    }
                }
            } else if (tile instanceof TileEntityAdvancedGear) {
                TileEntityAdvancedGear adv = (TileEntityAdvancedGear)tile;
                switch (adv.getGearType()) {
                    case WORM: {
                        if (TorqueUsage.isPoweredFrom(adv.getWriteTileEntity(), adv)) break;
                        TorqueUsage.recursiveFind(adv.getWriteTileEntity(), reader, activeRatio / 16.0);
                        break;
                    }
                    case CVT: {
                        if (!TorqueUsage.isPoweredFrom(adv.getWriteTileEntity(), adv)) break;
                        if (adv.getRatio() > 0) {
                            TorqueUsage.recursiveFind(adv.getWriteTileEntity(), reader, activeRatio * (double)adv.getRatio());
                            break;
                        }
                        TorqueUsage.recursiveFind(adv.getWriteTileEntity(), reader, -activeRatio / (double)adv.getRatio());
                        break;
                    }
                    case COIL: {
                        double amt = Math.sqrt(2L * adv.getEnergy());
                        if (adv.isBedrockCoil()) {
                            amt *= 16.0;
                        }
                        requiredTorque += amt * activeRatio;
                        break;
                    }
                    case HIGH: {
                        if (!TorqueUsage.isPoweredFrom(adv.getWriteTileEntity(), adv)) break;
                        double d = adv.torquemode ? 256.0 : 0.00390625;
                        TorqueUsage.recursiveFind(adv.getWriteTileEntity(), reader, activeRatio / d);
                    }
                }
            } else if (tile instanceof TileEntityShaft) {
                TileEntityShaft sha = (TileEntityShaft)tile;
                if (sha.isCross()) {
                    TileEntity write = sha.getWriteTileEntity();
                    TileEntity write2 = sha.getWriteTileEntity2();
                    if (TorqueUsage.isPoweredFrom(write, sha)) {
                        TorqueUsage.recursiveFind(write, reader, activeRatio);
                    }
                    if (TorqueUsage.isPoweredFrom(write2, sha)) {
                        TorqueUsage.recursiveFind(write2, reader, activeRatio);
                    }
                } else if (TorqueUsage.isPoweredFrom(io.getWriteTileEntity(), io)) {
                    TorqueUsage.recursiveFind(io.getWriteTileEntity(), reader, activeRatio);
                }
            } else if (TorqueUsage.isPoweredFrom(io.getWriteTileEntity(), io)) {
                TorqueUsage.recursiveFind(io.getWriteTileEntity(), reader, activeRatio);
            }
        } else if (tile instanceof TileEntityPowerReceiver) {
            TileEntityPowerReceiver pwr = (TileEntityPowerReceiver)tile;
            if (tile instanceof TileEntityBeltHub) {
                TileEntityBeltHub hub = (TileEntityBeltHub)tile;
                if (!hub.isReceivingEnd) {
                    TileEntity di;
                    Coordinate tgt = hub.getConnection();
                    TileEntity tileEntity = di = tgt != null ? tgt.getTileEntity((IBlockAccess)hub.field_145850_b) : null;
                    if (di instanceof TileEntityBeltHub) {
                        TileEntityBeltHub h2 = (TileEntityBeltHub)di;
                        TileEntity write = h2.getWriteTileEntity();
                        TileEntity write2 = h2.getWriteTileEntity2();
                        if (TorqueUsage.isPoweredFrom(write, h2)) {
                            TorqueUsage.recursiveFind(write, reader, activeRatio);
                        }
                        if (TorqueUsage.isPoweredFrom(write2, h2)) {
                            TorqueUsage.recursiveFind(write2, reader, activeRatio);
                        }
                    }
                }
            } else if (tile instanceof TileEntityBusController) {
                TorqueUsage.manageBus((TileEntityBusController)tile, reader, activeRatio);
            } else {
                double req = pwr.MINTORQUE;
                double min = 0.0;
                if (tile instanceof TileEntityExtractor) {
                    TileEntityExtractor ex = (TileEntityExtractor)tile;
                    int rtorque = ex.torque;
                    int mintorque = 0;
                    for (int i = 0; i < 4; ++i) {
                        if (ex.machine.getMinTorque(i) > rtorque) continue;
                        mintorque = Math.max(mintorque, ex.machine.getMinTorque(i));
                    }
                    req = mintorque;
                } else if (pwr.getTile().isModConversionEngine()) {
                    min = Math.max(1.0, Math.min(2.147483647E9, (double)pwr.power / 256.0));
                } else if (pwr.getTile() == MachineRegistry.FRICTION) {
                    TileEntityFurnaceHeater te = (TileEntityFurnaceHeater)tile;
                    req = te.hasFurnace() ? (req *= 4.0) : 0.01;
                }
                requiredTorque += Math.max(activeRatio * req, min);
            }
        } else if (tile instanceof PowerAcceptor) {
            requiredTorque += (double)Math.max(((PowerAcceptor)tile).getMinTorque(reader.torque), 1);
        }
    }

    private static void manageBus(TileEntityBusController tile, TileEntityFlywheel reader, double activeRatio) {
        ShaftPowerBus bus = tile.getBus();
        Collection<TileEntityPowerBus> blocks = bus.getBlocks();
        for (TileEntityPowerBus te : blocks) {
            for (int k = 2; k < 6; ++k) {
                TileEntity out;
                ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[k];
                if (!te.canOutputToSide(dir) || !((out = tile.getAdjacentTileEntity(dir)) instanceof TileEntityIOMachine)) continue;
                TileEntityIOMachine io = (TileEntityIOMachine)out;
                TileEntity read = io.getReadTileEntity();
                TileEntity read2 = io.getReadTileEntity2();
                TileEntity read3 = io.getReadTileEntity3();
                TileEntity read4 = io.getReadTileEntity4();
                if (io.getReadTileEntity() != te && read != te && read2 != te && read3 != te && read4 != te) continue;
                double ratio = te.getAbsRatio(dir);
                if (!te.isSideSpeedMode(dir)) {
                    ratio = 1.0 / ratio;
                }
                TorqueUsage.recursiveFind(out, reader, ratio * activeRatio);
            }
        }
    }

    private static boolean isPoweredFrom(TileEntity tile, TileEntityIOMachine caller) {
        PowerAcceptor acc;
        WorldLocation loc = new WorldLocation((TileEntity)caller);
        if (tile instanceof TileEntityIOMachine) {
            TileEntityIOMachine io = (TileEntityIOMachine)tile;
            WorldLocation read = io.getReadLocation();
            WorldLocation read2 = io.getReadLocation2();
            WorldLocation read3 = io.getReadLocation3();
            WorldLocation read4 = io.getReadLocation4();
            return loc.equals((Object)read) || loc.equals((Object)read2) || loc.equals((Object)read3) || loc.equals((Object)read4);
        }
        if (tile instanceof PowerAcceptor && (acc = (PowerAcceptor)tile).isReceiving()) {
            for (int i = 0; i < 6; ++i) {
                WorldLocation loc2;
                ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
                if (!acc.canReadFrom(dir) || !loc.equals((Object)(loc2 = new WorldLocation(tile).move(dir, 1)))) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean canReadFrom(TileEntityIOMachine te, TileEntityIOMachine input) {
        return te.getReadTileEntity() == input || te.getReadTileEntity2() == input || te.getReadTileEntity3() == input || te.getReadTileEntity4() == input;
    }

    static {
        pathCache = new HashSet();
    }
}

