/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Entities;

import Reika.DragonAPI.Libraries.Java.ReikaArrayHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import Reika.RotaryCraft.TileEntities.World.TileEntityFlooder;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;

public class EntityLiquidBlock
extends Entity {
    private Fluid fluid;
    private TileEntityFlooder tile;
    private static final ForgeDirection[] dirs = ForgeDirection.values();

    public EntityLiquidBlock(World world) {
        super(world);
        this.fluid = null;
        this.tile = null;
    }

    public EntityLiquidBlock(World world, int x, int y, int z, Fluid f, TileEntityFlooder te) {
        super(world);
        this.fluid = f;
        this.tile = te;
        this.func_70107_b(x, y, z);
    }

    public void func_70071_h_() {
        World world = this.field_70170_p;
        int x = this.getIntegerX();
        int y = this.getIntegerY();
        int z = this.getIntegerZ();
        if (this.canMoveInto(ForgeDirection.DOWN)) {
            this.field_70163_u -= 1.0;
        } else {
            ForgeDirection toPit = this.findPathToDepression(world, x, y, z);
            if (toPit != null) {
                int dx = x + toPit.offsetX;
                int dy = y + toPit.offsetY;
                int dz = z + toPit.offsetZ;
                if (this.canMoveInto(toPit)) {
                    this.func_70091_d(toPit.offsetX, toPit.offsetY, toPit.offsetZ);
                }
            }
        }
        this.func_70106_y();
    }

    public ForgeDirection findPathToDepression(World world, int x, int y, int z) {
        Object[] dir = new ForgeDirection[]{ForgeDirection.EAST, ForgeDirection.WEST, ForgeDirection.SOUTH, ForgeDirection.NORTH};
        ReikaArrayHelper.shuffleArray((Object[])dir);
        int dy = y - 1;
        int r = 6;
        for (int i = 0; i < 4; ++i) {
            Object d = dir[i];
            for (int k = 1; k <= r; ++k) {
                int dx = x + ((ForgeDirection)d).offsetX * k;
                int dz = z + ((ForgeDirection)d).offsetZ * k;
                if (!this.canMoveInto((ForgeDirection)d)) continue;
                return d;
            }
        }
        return null;
    }

    public int getIntegerX() {
        return MathHelper.func_76128_c((double)this.field_70165_t);
    }

    public int getIntegerY() {
        return MathHelper.func_76128_c((double)this.field_70163_u);
    }

    public int getIntegerZ() {
        return MathHelper.func_76128_c((double)this.field_70161_v);
    }

    public boolean canMoveInto(ForgeDirection side) {
        int dx = this.getIntegerX() + side.offsetX;
        int dy = this.getIntegerY() + side.offsetY;
        int dz = this.getIntegerZ() + side.offsetZ;
        return false;
    }

    public Block getBlock(ForgeDirection side) {
        int dx = this.getIntegerX() + side.offsetX;
        int dy = this.getIntegerY() + side.offsetY;
        int dz = this.getIntegerZ() + side.offsetZ;
        return this.field_70170_p.func_147439_a(dx, dy, dz);
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound NBT) {
        this.fluid = ReikaNBTHelper.getFluidFromNBT((NBTTagCompound)NBT);
    }

    protected void func_70014_b(NBTTagCompound NBT) {
        ReikaNBTHelper.writeFluidToNBT((NBTTagCompound)NBT, (Fluid)this.fluid);
    }

    public Fluid getFluid() {
        return this.fluid;
    }
}

