/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.GUIs;

import Reika.DragonAPI.Auxiliary.Trackers.PackModificationTracker;
import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Instantiable.GUI.ImagedGuiButton;
import Reika.DragonAPI.Libraries.IO.ReikaChatHelper;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaObfuscationHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Rendering.ReikaGuiAPI;
import Reika.DragonAPI.Libraries.Rendering.ReikaRenderHelper;
import Reika.DragonAPI.ModList;
import Reika.RotaryCraft.Auxiliary.HandbookAuxData;
import Reika.RotaryCraft.Auxiliary.HandbookNotifications;
import Reika.RotaryCraft.Auxiliary.Interfaces.EnchantableMachine;
import Reika.RotaryCraft.Auxiliary.Interfaces.HandbookEntry;
import Reika.RotaryCraft.Auxiliary.RotaryDescriptions;
import Reika.RotaryCraft.Base.TileEntity.TileEntityEngine;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.EngineType;
import Reika.RotaryCraft.Registry.Flywheels;
import Reika.RotaryCraft.Registry.HandbookRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.Registry.MaterialRegistry;
import Reika.RotaryCraft.RotaryCraft;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityAdvancedGear;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.recipe.GuiCraftingRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiHandbook
extends GuiScreen {
    private int mx;
    private int my;
    protected final int xSize = 256;
    protected final int ySize = 220;
    public World worldObj;
    private EntityPlayer player;
    public static final long SECOND = 2000000000L;
    public static final int PAGES_PER_SCREEN = 8;
    private static final int descX = 8;
    private static final int descY = 88;
    protected int screen = 0;
    protected int page = 0;
    protected int subpage = 0;
    protected int modifier = 0;
    private byte bcg;
    public static long time;
    private long buttontime;
    public static int i;
    private int buttoni = 0;
    protected int buttontimer = 0;
    private static int staticwidth;
    private static int staticheight;
    private int guiTick;
    protected float renderq = 22.5f;
    protected static final RenderBlocks rb;
    protected static final RenderItem ri;

    public GuiHandbook(EntityPlayer p5ep, World world, int s, int p) {
        this.player = p5ep;
        this.worldObj = world;
        staticwidth = 256;
        staticheight = 220;
        this.screen = s;
        this.page = p;
        if (ConfigRegistry.DYNAMICHANDBOOK.getState() || DragonAPICore.isReikasComputer() && ReikaObfuscationHelper.isDeObfEnvironment()) {
            this.reloadXMLData();
        }
    }

    protected void reloadXMLData() {
        RotaryDescriptions.reload();
    }

    public final void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.guiTick = 0;
        int j = (this.field_146294_l - 256) / 2;
        int k = (this.field_146295_m - 220) / 2 - 8;
        String file = HandbookRegistry.TOC.getTabImageFile();
        if (!this.isLimitedView()) {
            this.field_146292_n.add(new ImagedGuiButton(10, j - 20, 17 + k + 163, 20, 20, 220, 0, "-", 0, false, file, RotaryCraft.class));
            this.field_146292_n.add(new ImagedGuiButton(11, j - 20, 17 + k + 143, 20, 20, 220, 20, "+", 0, false, file, RotaryCraft.class));
            this.field_146292_n.add(new ImagedGuiButton(15, j - 20, 17 + k + 183, 20, 20, 220, 20, "<<", 0, false, file, RotaryCraft.class));
        }
        this.field_146292_n.add(new GuiButton(12, j + 256 - 27, k + 6, 20, 20, "X"));
        HandbookEntry h = this.getEntry();
        if (h.hasSubpages() || h instanceof HandbookRegistry && ((HandbookRegistry)h).getBonusSubpages() > 0) {
            this.field_146292_n.add(new GuiButton(13, j + 256 - 27, k + 40, 20, 20, ">"));
            this.field_146292_n.add(new GuiButton(14, j + 256 - 27, k + 60, 20, 20, "<"));
        }
        if (!this.isLimitedView()) {
            this.addTabButtons(j, k);
        }
        this.onInitGui(j, k, h);
    }

    protected void onInitGui(int j, int k, HandbookEntry h) {
    }

    protected void addTabButtons(int j, int k) {
        HandbookRegistry.addRelevantButtons(j, k, this.screen, this.field_146292_n);
    }

    public final boolean func_73868_f() {
        return true;
    }

    public int getMaxScreen() {
        return HandbookRegistry.RESOURCEDESC.getScreen() + HandbookRegistry.RESOURCEDESC.getNumberChildren() / 8;
    }

    public int getMaxPage() {
        return HandbookRegistry.getEntriesForScreen(this.screen).size() - 1;
    }

    public int getMaxSubpage() {
        HandbookRegistry h = HandbookRegistry.getEntry(this.screen, this.page);
        if (h == HandbookRegistry.TIERS) {
            return HandbookAuxData.getPowerDataSize() - 1;
        }
        if (h == HandbookRegistry.COMPUTERCRAFT) {
            return MachineRegistry.machineList.length / 36 + 1;
        }
        if (h == HandbookRegistry.ALERTS) {
            return HandbookNotifications.instance.getNewAlerts().size() / 3;
        }
        if (h == HandbookRegistry.PACKMODS) {
            return PackModificationTracker.instance.getModifications((DragonAPIMod)RotaryCraft.instance).size() / 3;
        }
        if (h == HandbookRegistry.ENCHANTING) {
            return MachineRegistry.getEnchantableMachineList().getSize();
        }
        return h.hasSubpages() ? 1 + h.getBonusSubpages() : h.getBonusSubpages();
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 12) {
            this.field_146297_k.field_71439_g.func_71053_j();
            return;
        }
        if (this.buttontimer > 0) {
            return;
        }
        this.buttontimer = 20;
        if (button.field_146127_k == 15) {
            this.screen = 0;
            this.page = 0;
            this.subpage = 0;
            this.renderq = 22.5f;
            this.func_73866_w_();
            return;
        }
        if (button.field_146127_k == 10) {
            this.prevScreen();
            return;
        }
        if (button.field_146127_k == 11) {
            this.nextScreen();
            return;
        }
        if (this.isOnTOC()) {
            this.screen = this.getNewScreenByTOCButton(button.field_146127_k + this.screen * 8);
            this.func_73866_w_();
            this.page = 0;
            this.subpage = 0;
            this.renderq = 22.5f;
            return;
        }
        if (button.field_146127_k == 13) {
            if (this.subpage < this.getMaxSubpage()) {
                ++this.subpage;
            }
            this.func_73866_w_();
            return;
        }
        if (button.field_146127_k == 14) {
            if (this.subpage > 0) {
                --this.subpage;
            }
            this.func_73866_w_();
            return;
        }
        time = System.nanoTime();
        i = 0;
        this.page = button.field_146127_k;
        this.subpage = 0;
        this.renderq = 22.5f;
        this.func_73866_w_();
    }

    private void nextScreen() {
        if (this.screen < this.getMaxScreen()) {
            ++this.screen;
            this.page = 0;
            this.subpage = 0;
        }
        this.renderq = 22.5f;
        this.func_73866_w_();
    }

    private void prevScreen() {
        if (this.screen > 0) {
            --this.screen;
            this.page = 0;
            this.subpage = 0;
        }
        this.renderq = 22.5f;
        this.func_73866_w_();
    }

    private void nextPage() {
        if (this.page < this.getMaxPage()) {
            ++this.page;
        } else {
            this.nextScreen();
            return;
        }
        this.subpage = 0;
        this.renderq = 22.5f;
        this.func_73866_w_();
    }

    private void prevPage() {
        if (this.page > 0) {
            --this.page;
        } else {
            this.prevScreen();
            this.page = this.getMaxPage();
            return;
        }
        this.subpage = 0;
        this.renderq = 22.5f;
        this.func_73866_w_();
    }

    protected boolean isOnTOC() {
        return this.getEntry() == HandbookRegistry.TOC;
    }

    protected int getNewScreenByTOCButton(int id) {
        List<HandbookRegistry> li = HandbookRegistry.getCategoryTabs(true);
        if (id >= li.size()) {
            ReikaJavaLibrary.pConsole((Object)("Could not load screen for #" + id));
            return 0;
        }
        return li.get(id).getScreen();
    }

    public void refreshScreen() {
        int lastx = this.mx;
        int lasty = this.my;
        this.field_146297_k.field_71439_g.func_71053_j();
        Mouse.setCursorPosition((int)lastx, (int)lasty);
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.mx = Mouse.getX();
        this.my = Mouse.getY();
    }

    protected PageType getGuiLayout() {
        HandbookRegistry h = HandbookRegistry.getEntry(this.screen, this.page);
        if (this.isOnTOC()) {
            return PageType.TOC;
        }
        if (h.isPlainGui()) {
            return PageType.PLAIN;
        }
        if (h == HandbookRegistry.BAITBOX && this.subpage == 1) {
            return PageType.ANIMALBAIT;
        }
        if (h == HandbookRegistry.TERRA && this.subpage == 1) {
            return PageType.TERRAFORMER;
        }
        if (h == HandbookRegistry.TIERS) {
            return PageType.GREYBOX;
        }
        if (h == HandbookRegistry.TIMING) {
            return PageType.GREYBOX;
        }
        if (h == HandbookRegistry.ALERTS) {
            return PageType.BLACKBOX;
        }
        if (h == HandbookRegistry.PACKMODS) {
            return PageType.BLACKBOX;
        }
        if (this.subpage >= 1) {
            return PageType.PLAIN;
        }
        if (h == HandbookRegistry.STEELINGOT) {
            return PageType.BLASTFURNACE;
        }
        if (h == HandbookRegistry.EXTRACTS) {
            return PageType.EXTRACTOR;
        }
        if (h == HandbookRegistry.FLAKES) {
            return PageType.SMELTING;
        }
        if (h == HandbookRegistry.COMPACTS) {
            return PageType.COMPACTOR;
        }
        if (h == HandbookRegistry.GLASS) {
            return PageType.SMELTING;
        }
        if (h == HandbookRegistry.TUNGSTEN) {
            return PageType.SMELTING;
        }
        if (h == HandbookRegistry.NETHERDUST) {
            return PageType.SMELTING;
        }
        if (h == HandbookRegistry.YEAST) {
            return PageType.FERMENTER;
        }
        if (h == HandbookRegistry.ETHANOL) {
            return PageType.SMELTING;
        }
        if (h == HandbookRegistry.SILVERINGOT) {
            return PageType.SMELTING;
        }
        if (h == HandbookRegistry.SALT) {
            return PageType.PLAIN;
        }
        if (h == HandbookRegistry.BUCKETS) {
            if (System.nanoTime() / 2000000000L % 2L == 0L) {
                return PageType.FRACTIONATOR;
            }
            return PageType.GRINDER;
        }
        if (h == HandbookRegistry.BEDTOOLS || h == HandbookRegistry.BEDARMOR) {
            return PageType.BLASTFURNACE;
        }
        if (h == HandbookRegistry.ALLOYING) {
            return PageType.BLASTFURNACE;
        }
        if (h == HandbookRegistry.COKE) {
            return PageType.BLASTFURNACE;
        }
        if (h == HandbookRegistry.STRONGSPRING) {
            return PageType.BLASTFURNACE;
        }
        if (h.isMachine() || h.isEngine() || h.isTrans() || h.getParent() == HandbookRegistry.CONVERTERDESC) {
            return PageType.MACHINERENDER;
        }
        return PageType.CRAFTING;
    }

    public final String getBackgroundTexture() {
        PageType type = this.getGuiLayout();
        String var4 = "/Reika/RotaryCraft/Textures/GUI/Handbook/" + type.getFileName() + ".png";
        return var4;
    }

    private final void drawRecipes() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int posX = (this.field_146294_l - 256) / 2;
        int posY = (this.field_146295_m - 220) / 2;
        try {
            this.drawAuxData(posX, posY);
        }
        catch (Exception e) {
            ReikaChatHelper.write((Object)Arrays.toString(e.getStackTrace()));
            e.printStackTrace();
        }
    }

    protected void drawAuxData(int posX, int posY) {
        HandbookAuxData.drawPage(this.field_146289_q, ri, this.screen, this.page, this.subpage, posX, posY);
    }

    private final void drawTabIcons() {
        int posX = (this.field_146294_l - 256) / 2;
        int posY = (this.field_146295_m - 220) / 2;
        List<HandbookEntry> li = this.getAllTabsOnScreen();
        for (int i = 0; i < li.size(); ++i) {
            HandbookEntry h = li.get(i);
            ReikaGuiAPI.instance.drawItemStack(ri, this.field_146289_q, h.getTabIcon(), posX - 17, posY - 6 + i * 20);
        }
    }

    public List<HandbookEntry> getAllTabsOnScreen() {
        List<HandbookRegistry> li = HandbookRegistry.getEntriesForScreen(this.screen);
        return new ArrayList<HandbookEntry>(li);
    }

    private final void drawGraphics(float ptick) {
        int posX = (this.field_146294_l - 256) / 2 - 2;
        int posY = (this.field_146295_m - 220) / 2 - 8;
        if (this.getEntry() == HandbookRegistry.ENCHANTING && this.subpage > 0) {
            MultiMap<MachineRegistry, Enchantment> map = MachineRegistry.getEnchantableMachineList();
            ArrayList li = new ArrayList(map.keySet());
            Collections.sort(li);
            double x = posX + 167;
            double y = posY + 44;
            MachineRegistry m = (MachineRegistry)((Object)li.get(this.subpage - 1));
            TileEntity te = m.createTEInstanceForRender(0);
            ((EnchantableMachine)te).getEnchantmentHandler().setEnchantment((Enchantment)map.get((Object)m).iterator().next(), 1);
            this.doRenderMachine(x, y, HandbookRegistry.ENCHANTING, m);
            ((EnchantableMachine)te).getEnchantmentHandler().clear();
        }
        if (!this.isLimitedView()) {
            ReikaRenderHelper.disableLighting();
            int msx = ReikaGuiAPI.instance.getMouseRealX();
            int msy = ReikaGuiAPI.instance.getMouseRealY();
            String s = String.format("Page %d/%d", this.screen, this.getMaxScreen());
            ReikaGuiAPI.instance.drawTooltipAt(this.field_146289_q, s, posX + 24 + 256 + this.field_146289_q.func_78256_a(s), posY + 20);
            if (ReikaGuiAPI.instance.isMouseInBox(posX - 18, posX + 2, posY + 0, posY + 220)) {
                String sg = "";
                List<HandbookEntry> li = this.getAllTabsOnScreen();
                int idx = (msy - posY) / 20;
                if (idx >= 8) {
                    int diff = idx - 8;
                    switch (diff) {
                        case 0: {
                            sg = "Next";
                            break;
                        }
                        case 1: {
                            sg = "Back";
                            break;
                        }
                        case 2: {
                            sg = "Return";
                        }
                    }
                } else if (idx < li.size()) {
                    HandbookEntry h = li.get(idx);
                    sg = h.getTitle();
                }
                if (!sg.isEmpty()) {
                    ReikaGuiAPI.instance.drawTooltipAt(this.field_146289_q, sg, msx + this.field_146289_q.func_78256_a(sg) + 30, msy);
                }
            }
        }
        if (HandbookNotifications.instance.newAlerts() || PackModificationTracker.instance.modificationsExist((DragonAPIMod)RotaryCraft.instance)) {
            ReikaTextureHelper.bindFinalTexture(DragonAPICore.class, (String)"Resources/warning.png");
            GL11.glEnable((int)3042);
            Tessellator v5 = Tessellator.field_78398_a;
            int x = posX + 257;
            int y = posY + 18;
            int alpha = (int)(155.0 + 100.0 * Math.sin(Math.toRadians(System.currentTimeMillis() / 8L % 360L)));
            v5.func_78382_b();
            v5.func_78384_a(0xFFFFFF, alpha);
            v5.func_78374_a((double)x, (double)(y + 24), 0.0, 0.0, 1.0);
            v5.func_78374_a((double)(x + 24), (double)(y + 24), 0.0, 1.0, 1.0);
            v5.func_78374_a((double)(x + 24), (double)y, 0.0, 1.0, 0.0);
            v5.func_78374_a((double)x, (double)y, 0.0, 0.0, 0.0);
            v5.func_78381_a();
            GL11.glDisable((int)3042);
            int i = Mouse.getX() * this.field_146294_l / this.field_146297_k.field_71443_c;
            int j = this.field_146295_m - Mouse.getY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
            int dx = i - posX;
            int dy = j - posY;
            if (ReikaMathLibrary.isValueInsideBoundsIncl((int)261, (int)377, (int)dx) && ReikaMathLibrary.isValueInsideBoundsIncl((int)22, (int)36, (int)dy)) {
                if (HandbookNotifications.instance.newAlerts()) {
                    ReikaGuiAPI.instance.drawTooltip(this.field_146289_q, "Some config settings have been changed.");
                }
                if (PackModificationTracker.instance.modificationsExist((DragonAPIMod)RotaryCraft.instance)) {
                    ReikaGuiAPI.instance.drawTooltip(this.field_146289_q, "The modpack has made some changes to the mod.", 0, 10);
                }
            }
        }
        this.drawAuxGraphics(posX, posY, ptick);
    }

    protected final void func_73864_a(int x, int y, int a) {
        super.func_73864_a(x, y, a);
        int j = (this.field_146294_l - 256) / 2 - 2;
        int k = (this.field_146295_m - 220) / 2 - 8;
        if (a == 0) {
            int dx = x - j;
            int dy = y - k;
            if ((HandbookNotifications.instance.newAlerts() || PackModificationTracker.instance.modificationsExist((DragonAPIMod)RotaryCraft.instance)) && ReikaMathLibrary.isValueInsideBoundsIncl((int)261, (int)377, (int)dx) && ReikaMathLibrary.isValueInsideBoundsIncl((int)22, (int)36, (int)dy)) {
                this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
                int screen = -1;
                int page = -1;
                if (HandbookNotifications.instance.newAlerts()) {
                    screen = HandbookRegistry.ALERTS.getScreen();
                    page = HandbookRegistry.ALERTS.getPage();
                } else if (PackModificationTracker.instance.modificationsExist((DragonAPIMod)RotaryCraft.instance)) {
                    screen = HandbookRegistry.PACKMODS.getScreen();
                    page = HandbookRegistry.PACKMODS.getPage();
                }
                if (screen >= 0 && page >= 0) {
                    this.screen = screen;
                    this.page = page;
                    this.func_73866_w_();
                    HandbookNotifications.instance.clearAlert();
                }
            }
        }
    }

    public final void func_73869_a(char c, int key) {
        super.func_73869_a(c, key);
        if (ModList.NEI.isLoaded() && key == NEIClientConfig.getKeyBinding((String)"gui.recipe")) {
            ItemStack is;
            int x = ReikaGuiAPI.instance.getMouseRealX();
            int y = ReikaGuiAPI.instance.getMouseRealY();
            int j = (this.field_146294_l - 256) / 2 - 2;
            int k = (this.field_146295_m - 220) / 2 - 8;
            if (x >= j && y >= k && x < j + 256 && y < k + 220 && (is = ReikaGuiAPI.instance.getItemRenderAt(x, y)) != null) {
                GuiCraftingRecipe.openRecipeGui((String)"item", (Object[])new Object[]{is});
            }
        }
        if (key == 203) {
            this.prevPage();
        } else if (key == 205) {
            this.nextPage();
        } else if (key == 201) {
            this.prevScreen();
        } else if (key == 209) {
            this.nextScreen();
        }
    }

    protected void drawAuxGraphics(int posX, int posY, float ptick) {
        HandbookAuxData.drawGraphics((HandbookRegistry)this.getEntry(), posX, posY, 256, 220, this.field_146289_q, ri, this.subpage);
    }

    public final int getGuiTick() {
        return this.guiTick;
    }

    public final void func_73863_a(int x, int y, float f) {
        if (System.nanoTime() - this.buttontime > 100000000L) {
            ++this.buttoni;
            this.buttontime = System.nanoTime();
            this.buttontimer = 0;
        }
        ++this.guiTick;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindTexture();
        int posX = (this.field_146294_l - 256) / 2;
        int posY = (this.field_146295_m - 220) / 2 - 8;
        this.func_73729_b(posX, posY, 0, 0, 256, 220);
        int xo = 0;
        int yo = 0;
        HandbookEntry h = this.getEntry();
        boolean disable = h.isConfigDisabled();
        String s = h.getTitle() + (disable ? " (Disabled)" : "");
        this.field_146289_q.func_78276_b(s, posX + xo + 6, posY + yo + 6, disable ? 0xFF0000 : 0);
        if (h == HandbookRegistry.ENCHANTING && this.subpage > 0) {
            MultiMap<MachineRegistry, Enchantment> map = MachineRegistry.getEnchantableMachineList();
            ArrayList li = new ArrayList(map.keySet());
            Collections.sort(li);
            this.field_146289_q.func_78276_b(((MachineRegistry)((Object)li.get(this.subpage - 1))).getName(), posX + xo + 6, posY + yo + 18, disable ? 0xFF0000 : 0);
        }
        int c = disable ? 0x777777 : 0xFFFFFF;
        int px = posX + 8;
        if (this.isOnTOC()) {
            posY -= 44;
        }
        if (this.subpage == 0 || h.sameTextAllSubpages()) {
            this.field_146289_q.func_78279_b(this.parseHandbookText(h.getData()), px, posY + 88, 242, c);
        } else {
            this.field_146289_q.func_78279_b(this.parseHandbookText(h.getNotes(this.subpage)), px, posY + 88, 242, c);
        }
        if (disable) {
            this.field_146289_q.func_78279_b("This machine has been disabled by your server admin or modpack creator.", px, posY + 88, 242, 0xFFFFFF);
            this.field_146289_q.func_78279_b("Contact them for further information or to request that they remove this restriction.", px, posY + 88 + 27, 242, 0xFFFFFF);
            this.field_146289_q.func_78279_b("If you are the server admin or pack creator, use the configuration files to change this setting.", px, posY + 88 + 54, 242, 0xFFFFFF);
        }
        super.func_73863_a(x, y, f);
        if (this.subpage == 0 && !disable) {
            this.drawRecipes();
        }
        if (!this.isLimitedView()) {
            this.drawTabIcons();
        }
        this.drawGraphics(f);
        if (this.subpage == 0) {
            this.drawMachineRender(posX, posY);
        }
        RenderHelper.func_74518_a();
    }

    private String parseHandbookText(String s) {
        return s;
    }

    protected HandbookEntry getEntry() {
        return HandbookRegistry.getEntry(this.screen, this.page);
    }

    protected void bindTexture() {
        String var4 = this.getBackgroundTexture();
        ReikaTextureHelper.bindTexture(RotaryCraft.class, (String)var4);
    }

    public boolean isLimitedView() {
        return false;
    }

    protected void doRenderMachine(double x, double y, HandbookEntry he) {
        HandbookRegistry h = (HandbookRegistry)he;
        MachineRegistry m = h.getMachine();
        if (m == null) {
            return;
        }
        this.doRenderMachine(x, y, h, m);
    }

    protected final void doRenderMachine(double x, double y, HandbookRegistry h, MachineRegistry m) {
        MaterialRegistry[] mats = MaterialRegistry.values();
        TileEntity te = m.createTEInstanceForRender(0);
        int timeStep = (int)(System.nanoTime() / 2000000000L % (long)mats.length);
        int r = (int)(System.nanoTime() / 20000000L) % 360;
        float variable = 0.0f;
        if (h.isEngine() && h != HandbookRegistry.SOLAR) {
            EngineType type = EngineType.engineList[h.getOffset()];
            te = type.getTEInstanceForRender();
            ((TileEntityEngine)te).setType(type.getCraftedProduct());
        }
        if (h == HandbookRegistry.SHAFT) {
            variable = -1000.0f * (float)(timeStep + 1);
        }
        if (h == HandbookRegistry.FLYWHEEL) {
            int tick = (int)(System.nanoTime() / 2000000000L % (long)Flywheels.list.length);
            variable = 500.0f - 1000.0f * (float)(tick + 1);
        }
        if (h == HandbookRegistry.GEARBOX) {
            variable = -1000.0f * (float)(timeStep + 1);
        }
        if (h == HandbookRegistry.WORM) {
            variable = -1000.0f;
        }
        if (h == HandbookRegistry.CVT) {
            variable = -2000.0f;
        }
        if (h == HandbookRegistry.COIL) {
            int tick = (int)(System.nanoTime() / 2000000000L % 2L);
            if (tick == 1) {
                ((TileEntityAdvancedGear)te).setBedrock(true);
            }
            variable = -3000.0f;
        }
        double sc = 48.0;
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)0.0, (double)32.0);
        if (m.hasModel() && !m.isPipe()) {
            double dx = x;
            double dy = y + 21.0;
            double dz = 0.0;
            GL11.glTranslated((double)dx, (double)dy, (double)dz);
            GL11.glScaled((double)sc, (double)(-sc), (double)sc);
            GL11.glRotatef((float)this.renderq, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)r, (float)0.0f, (float)1.0f, (float)0.0f);
            TileEntityRendererDispatcher.field_147556_a.func_147549_a(te, -0.5, 0.0, -0.5, variable);
        } else {
            double dx = x;
            double dy = y;
            double dz = 0.0;
            GL11.glTranslated((double)dx, (double)dy, (double)dz);
            GL11.glScaled((double)sc, (double)(-sc), (double)sc);
            GL11.glRotatef((float)this.renderq, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)r, (float)0.0f, (float)1.0f, (float)0.0f);
            ReikaTextureHelper.bindTerrainTexture();
            rb.func_147800_a(m.getBlock(), m.getBlockMetadata(), 1.0f);
        }
        GL11.glPopMatrix();
    }

    private void drawMachineRender(int posX, int posY) {
        RenderHelper.func_74520_c();
        HandbookEntry h = this.getEntry();
        double x = posX + 167;
        double y = posY + 44;
        int range = 64;
        boolean rotate = ReikaGuiAPI.instance.isMouseInBox((int)x - range / 2, (int)x + range / 2, (int)y - range, (int)y + range);
        if (Mouse.isButtonDown((int)0) && rotate) {
            int mvy = Mouse.getDY();
            if (mvy < 0 && this.renderq < 45.0f) {
                this.renderq += 1.0f;
            }
            if (mvy > 0 && this.renderq > -45.0f) {
                this.renderq -= 1.0f;
            }
        }
        y -= 8.0 * Math.sin(Math.abs(Math.toRadians(this.renderq)));
        if (h.hasMachineRender()) {
            GL11.glEnable((int)3042);
            this.doRenderMachine(x, y, h);
            GL11.glDisable((int)3042);
        }
    }

    static {
        i = 0;
        rb = new RenderBlocks();
        ri = new RenderItem();
    }

    protected static enum PageType {
        PLAIN("b"),
        CRAFTING(""),
        SMELTING("c"),
        EXTRACTOR("d"),
        COMPACTOR("e"),
        FERMENTER("f"),
        FRACTIONATOR("g"),
        GRINDER("h"),
        BLASTFURNACE("j"),
        ANIMALBAIT("k"),
        TERRAFORMER("l"),
        MACHINERENDER("m"),
        GREYBOX("n"),
        BLACKBOX("o"),
        SOLID("p"),
        TOC("a");

        private final String endString;

        private PageType(String s) {
            this.endString = s;
        }

        public String getFileName() {
            return "handbookgui" + this.endString;
        }
    }
}

