/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Items.Tools.Charged;

import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaVectorHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.RotaryCraft.Auxiliary.GravelGunDamage;
import Reika.RotaryCraft.Base.ItemChargedTool;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.ItemRegistry;
import Reika.RotaryCraft.Registry.RotaryAchievements;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class ItemGravelGun
extends ItemChargedTool {
    public ItemGravelGun(int tex) {
        super(tex);
    }

    @Override
    public ItemStack func_77659_a(ItemStack is, World world, EntityPlayer ep) {
        if (is.func_77960_j() <= 0) {
            this.noCharge();
            return is;
        }
        this.warnCharge(is);
        if (!ReikaPlayerAPI.playerHasOrIsCreative((EntityPlayer)ep, (Block)Blocks.field_150351_n, (int)-1)) {
            if (!world.field_72995_K) {
                world.func_72926_e(1001, (int)ep.field_70165_t, (int)ep.field_70163_u, (int)ep.field_70161_v, 1);
            }
            return is;
        }
        Vec3 look = ep.func_70040_Z();
        float i = 1.0f;
        while (i <= 128.0f) {
            DecimalPosition looks = ReikaVectorHelper.getPlayerLookCoords((EntityPlayer)ep, (double)i);
            AxisAlignedBB fov = looks.getAABB(0.5);
            List li = world.func_72872_a(Entity.class, fov);
            ArrayList<Entity> infov = new ArrayList<Entity>();
            for (Entity e : li) {
                if (this.isFiringPlayer(e, ep) || ep.equals((Object)e) || !this.isEntityAttackable(e) || !ReikaWorldHelper.lineOfSight((World)world, (Entity)ep, (Entity)e)) continue;
                infov.add(e);
            }
            for (Entity ent : infov) {
                double dist = ReikaMathLibrary.py3d((double)(ep.field_70165_t - ent.field_70165_t), (double)(ep.field_70163_u - ent.field_70163_u), (double)(ep.field_70161_v - ent.field_70161_v));
                double x = ep.field_70165_t + look.field_72450_a;
                double y = ep.field_70163_u + (double)ep.func_70047_e() + look.field_72448_b;
                double z = ep.field_70161_v + look.field_72449_c;
                double dx = ent.field_70165_t - ep.field_70165_t;
                double dy = ent.field_70163_u - ep.field_70163_u;
                double dz = ent.field_70161_v - ep.field_70161_v;
                if (!world.field_72995_K) {
                    ItemStack fl = new ItemStack(Items.field_151145_ak);
                    EntityItem ei = new EntityItem(world, look.field_72450_a / look.func_72433_c() + ep.field_70165_t, look.field_72448_b / look.func_72433_c() + ep.field_70163_u, look.field_72449_c / look.func_72433_c() + ep.field_70161_v, fl);
                    ei.field_145804_b = 100;
                    ei.field_70159_w = dx;
                    ei.field_70181_x = dy + 1.0;
                    ei.field_70179_y = dz;
                    ei.field_70133_I = true;
                    world.func_72956_a((Entity)ep, "dig.gravel", 1.5f, 2.0f);
                    ei.lifespan = 5;
                    world.func_72838_d((Entity)ei);
                    if (is.func_77960_j() > 4096) {
                        // empty if block
                    }
                    if (ent instanceof EntityDragon) {
                        EntityDragon ed = (EntityDragon)ent;
                        ed.func_70965_a(ed.field_70987_i, DamageSource.func_76365_a((EntityPlayer)ep), this.getAttackDamage(is.func_77960_j()));
                    } else if (ent instanceof EntityEnderCrystal) {
                        ent.func_70097_a(DamageSource.func_76365_a((EntityPlayer)ep), this.getAttackDamage(is.func_77960_j()));
                    } else {
                        EntityLivingBase e = (EntityLivingBase)ent;
                        float dmg = this.getAttackDamage(is.func_77960_j());
                        if (ent instanceof EntityPlayer) {
                            for (int n = 1; n < 5; ++n) {
                                ItemRegistry ir = ItemRegistry.getEntry(e.func_71124_b(n));
                                if (ir == null || !ir.isBedrockArmor()) continue;
                                dmg = (float)((double)dmg * 0.75);
                            }
                        }
                        float pre = e.func_110143_aJ();
                        ent.func_70097_a((DamageSource)new GravelGunDamage(ep), dmg);
                        float post = e.func_110143_aJ();
                        if (post > 0.0f) {
                            float newh = Math.min(post, pre - Math.min(10.0f, dmg));
                            if (newh <= 0.0f) {
                                e.func_70606_j(0.01f);
                                ent.func_70097_a((DamageSource)new GravelGunDamage(ep), dmg);
                            } else {
                                e.func_70606_j(newh);
                            }
                        }
                        if (dmg >= 500.0f) {
                            RotaryAchievements.MASSIVEHIT.triggerAchievement(ep);
                        }
                    }
                    if (ent instanceof EntityMob && (ent.field_70128_L || ((EntityLivingBase)ent).func_110143_aJ() <= 0.0f) && ReikaMathLibrary.py3d((double)(ep.field_70165_t - ent.field_70165_t), (double)(ep.field_70163_u - ent.field_70163_u), (double)(ep.field_70161_v - ent.field_70161_v)) >= 80.0) {
                        RotaryAchievements.GRAVELGUN.triggerAchievement(ep);
                    }
                }
                for (float t = 0.0f; t < 2.0f; t += 0.05f) {
                    world.func_72869_a("crit", x, y, z, dx / dist * (double)t, dy / dist * (double)t, dz / dist * (double)t);
                }
            }
            if (infov.size() > 1) {
                RotaryAchievements.DOUBLEKILL.triggerAchievement(ep);
            }
            if (infov.size() > 0) {
                if (!ep.field_71075_bZ.field_75098_d) {
                    ReikaInventoryHelper.findAndDecrStack((Block)Blocks.field_150351_n, (int)-1, (ItemStack[])ep.field_71071_by.field_70462_a);
                }
                is.func_77964_b(is.func_77960_j() - this.getChargeConsumed(is.func_77960_j()));
                return is;
            }
            i = (float)((double)i + 0.5);
        }
        return is;
    }

    private boolean isFiringPlayer(Entity e, EntityPlayer ep) {
        return e instanceof EntityPlayer && e.func_70005_c_().equals(ep.func_70005_c_());
    }

    private boolean isEntityAttackable(Entity ent) {
        if (ent instanceof EntityPlayer && ReikaPlayerAPI.isReika((EntityPlayer)((EntityPlayer)ent))) {
            return false;
        }
        if (!(ent instanceof EntityLivingBase)) {
            return ent instanceof EntityEnderCrystal;
        }
        return ConfigRegistry.GRAVELPLAYER.getState() || !(ent instanceof EntityPlayer);
    }

    private int getChargeConsumed(int charge) {
        return Math.max(1, ReikaMathLibrary.logbase2((long)(1 + charge)));
    }

    private float getAttackDamage(int charge) {
        if (charge <= 0) {
            return 0.0f;
        }
        if (charge == 1) {
            return 1.0f;
        }
        long pow = ReikaMathLibrary.longpow((int)(charge / 2), (int)3);
        double base = this.getExpBase() + Math.pow(charge, this.getPowR()) / 150000.0;
        return (float)(1.0 + ReikaMathLibrary.logbase((long)pow, (int)2) / 2.0 * ReikaMathLibrary.doubpow((double)base, (double)charge));
    }

    private double getPowR() {
        return ConfigRegistry.HARDGRAVELGUN.getState() ? 0.15 : 0.1875;
    }

    private double getExpBase() {
        return ConfigRegistry.HARDGRAVELGUN.getState() ? 1.00005 : 1.0001;
    }

    public void func_77624_a(ItemStack is, EntityPlayer ep, List li, boolean par4) {
        float dmg = this.getAttackDamage(is.func_77960_j());
        String s = dmg > 0.0f ? String.format("Dealing %.1f hearts of damage per shot", Float.valueOf(dmg / 2.0f)) : "Unable to fire - requires charging";
        li.add(s);
    }
}

