/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.ModInterface;

import Reika.DragonAPI.Auxiliary.Trackers.ReflectiveFailureTracker;
import Reika.DragonAPI.Interfaces.Registry.ModEntry;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.ModList;
import Reika.RotaryCraft.Blocks.BlockCanola;
import Reika.RotaryCraft.Registry.BlockRegistry;
import Reika.RotaryCraft.Registry.ItemRegistry;
import Reika.RotaryCraft.RotaryCraft;
import com.InfinityRaider.AgriCraft.api.API;
import com.InfinityRaider.AgriCraft.api.v1.IGrowthRequirement;
import com.InfinityRaider.AgriCraft.api.v2.APIv2;
import com.InfinityRaider.AgriCraft.api.v2.IAdditionalCropData;
import com.InfinityRaider.AgriCraft.api.v2.ICrop;
import com.InfinityRaider.AgriCraft.api.v2.ICropPlant;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class AgriCanola
implements ICropPlant {
    private static final int[] GAIN_FORTUNE_MAPPING = new int[]{0, 1, 1, 2, 2, 3, 4, 5, 7, 10};
    private static final int[] METADATA_CONVERSION = new int[]{0, 1, 2, 4, 5, 6, 8, 9};
    public static final AgriCanola instance = new AgriCanola();

    private AgriCanola() {
    }

    public int tier() {
        return 2;
    }

    public ItemStack getSeed() {
        return ItemRegistry.CANOLA.getStackOf();
    }

    public Block getBlock() {
        return BlockRegistry.CANOLA.getBlockInstance();
    }

    public ArrayList<ItemStack> getAllFruits() {
        return ReikaJavaLibrary.makeListFrom((Object)this.getSeed());
    }

    public ItemStack getRandomFruit(Random rand) {
        return this.getSeed();
    }

    public ArrayList<ItemStack> getFruitsOnHarvest(int gain, Random rand) {
        int rem;
        ArrayList<ItemStack> li = new ArrayList<ItemStack>();
        for (int n = BlockCanola.getDrops(GAIN_FORTUNE_MAPPING[gain - 1], rand); n > 0; n -= rem) {
            rem = Math.min(n, ItemRegistry.CANOLA.getItemInstance().func_77639_j());
            li.add(ItemRegistry.CANOLA.getCraftedProduct(rem));
        }
        return li;
    }

    public boolean onHarvest(World world, int x, int y, int z, EntityPlayer player) {
        return true;
    }

    public void onSeedPlanted(World world, int x, int y, int z) {
    }

    public void onPlantRemoved(World world, int x, int y, int z) {
    }

    public boolean canBonemeal() {
        return true;
    }

    public boolean onAllowedGrowthTick(World world, int x, int y, int z, int oldGrowthStage) {
        return true;
    }

    public boolean isFertile(World world, int x, int y, int z) {
        return BlockCanola.canGrowAt(world, x, y, z);
    }

    public boolean isMature(IBlockAccess world, int x, int y, int z) {
        return METADATA_CONVERSION[world.func_72805_g(x, y, z)] == 9;
    }

    public float getHeight(int meta) {
        return BlockCanola.getPlantHeight(METADATA_CONVERSION[meta]);
    }

    public IIcon getPlantIcon(int growthStage) {
        return BlockRegistry.CANOLA.getBlockInstance().func_149691_a(2, METADATA_CONVERSION[growthStage]);
    }

    public boolean renderAsFlower() {
        return false;
    }

    public String getInformation() {
        return "A coarse black seed, often ground for oil, used either for cooking or for industrial lubrication.";
    }

    @SideOnly(value=Side.CLIENT)
    public boolean overrideRendering() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderPlantInCrop(IBlockAccess world, int x, int y, int z, RenderBlocks renderer) {
    }

    public static void register() {
        try {
            Class<?> c = Class.forName("com.InfinityRaider.AgriCraft.compatibility.ModHelper");
            Field f = c.getDeclaredField("modHelpers");
            f.setAccessible(true);
            HashMap map = (HashMap)f.get(null);
            map.remove(RotaryCraft.instance.getModContainer().getModId());
        }
        catch (Exception e) {
            ReflectiveFailureTracker.instance.logModReflectiveFailure((ModEntry)ModList.AGRICRAFT, e);
            e.printStackTrace();
        }
        ((APIv2)API.getAPI((int)2)).registerCropPlant((ICropPlant)instance);
    }

    public IAdditionalCropData getInitialCropData(World world, int x, int y, int z, ICrop crop) {
        return null;
    }

    public IAdditionalCropData readCropDataFromNBT(NBTTagCompound tag) {
        return null;
    }

    public void onValidate(World world, int x, int y, int z, ICrop crop) {
    }

    public void onInvalidate(World world, int x, int y, int z, ICrop crop) {
    }

    public void onChunkUnload(World world, int x, int y, int z, ICrop crop) {
    }

    public IGrowthRequirement getGrowthRequirement() {
        return ((APIv2)API.getAPI((int)2)).createDefaultGrowthRequirement();
    }
}

