/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.ModInterface.Conversion;

import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModInteract.Power.ReikaRFHelper;
import Reika.RotaryCraft.Base.TileEntity.EnergyToPowerBase;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.Registry.SoundRegistry;
import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyStorage;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMagnetic
extends EnergyToPowerBase
implements IEnergyHandler {
    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        this.getIOSides(world, x, y, z, meta);
        if ((world.func_72820_D() & 0x1FL) == 0L) {
            ReikaWorldHelper.causeAdjacentUpdates((World)world, (int)x, (int)y, (int)z);
        }
        this.updateSpeed();
        if (!world.field_72995_K) {
            ++this.tickcount;
            if (this.power > 0L && this.tickcount >= 85) {
                this.tickcount = 0;
                SoundRegistry.DYNAMO.playSoundAtBlock(world, x, y, z, this.isMuffled() ? 0.1f : 0.5f, 1.0f);
            }
        }
        this.basicPowerReceiver();
    }

    @Override
    public boolean isValidSupplier(TileEntity te) {
        return te instanceof IEnergyHandler || te instanceof IEnergyProvider || te instanceof IEnergyStorage;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
        if (!this.isInWorld()) {
            this.phi = 0.0f;
            return;
        }
        this.phi = (float)((double)this.phi + ReikaMathLibrary.doubpow((double)ReikaMathLibrary.logbase((long)(this.omega + 1), (int)2), (double)1.05));
    }

    @Override
    public MachineRegistry getTile() {
        return MachineRegistry.MAGNETIC;
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (this.canConnectEnergy(from) && maxReceive >= this.getMinimumCurrent()) {
            int amt = Math.min(maxReceive, this.getMaxStorage() - this.storedEnergy);
            if (!simulate) {
                this.storedEnergy += amt;
            }
            return amt;
        }
        return 0;
    }

    private int getMinimumCurrent() {
        switch (this.getTier()) {
            case 0: {
                return 1;
            }
            case 1: {
                return 3;
            }
            case 2: {
                return 24;
            }
            case 3: {
                return 187;
            }
            case 4: {
                return 1491;
            }
            case 5: {
                return 11925;
            }
        }
        return 0;
    }

    public boolean canConnectEnergy(ForgeDirection from) {
        return from == this.getFacing();
    }

    public int getEnergyStored(ForgeDirection from) {
        return this.storedEnergy;
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        return this.getMaxStorage();
    }

    @Override
    public int getMaxStorage() {
        return 1 + this.getMinimumCurrent() * 200;
    }

    @Override
    protected int getIdealConsumedUnitsPerTick() {
        return this.getRFPerTick();
    }

    private int getRFPerTick() {
        return (int)(this.getPowerLevel() / (long)ReikaRFHelper.getWattsPerRF());
    }

    @Override
    public String getUnitDisplay() {
        return "RF";
    }

    @Override
    public int getPowerColor() {
        return 0xFF0000;
    }

    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }
}

