/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.ModInterface.NEI;

import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaGuiAPI;
import Reika.DragonAPI.Libraries.Rendering.ReikaLiquidRenderer;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.MulchMaterials;
import Reika.RotaryCraft.GUIs.Machine.Inventory.GuiFermenter;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.ItemRegistry;
import Reika.RotaryCraft.RotaryCraft;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import org.lwjgl.opengl.GL11;

public class FermenterHandler
extends TemplateRecipeHandler {
    public String getRecipeName() {
        return "Fermenter";
    }

    public String getGuiTexture() {
        return "/Reika/RotaryCraft/Textures/GUI/fermentergui.png";
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ReikaTextureHelper.bindTexture(RotaryCraft.class, (String)this.getGuiTexture());
        GL11.glDisable((int)2929);
        ReikaGuiAPI.instance.drawTexturedModalRectWithDepth(0, 6, 5, 5, 166, 76, ReikaGuiAPI.NEI_DEPTH);
    }

    public void drawForeground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        ReikaTextureHelper.bindTexture(RotaryCraft.class, (String)this.getGuiTexture());
        this.drawExtras(recipe);
        ReikaLiquidRenderer.bindFluidTexture((Fluid)FluidRegistry.WATER);
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(74, 35, 23, 17), "rcferment", new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId != null && outputId.equals("rcferment")) {
            if (ConfigRegistry.enableFermenterYeast()) {
                this.arecipes.add(new FermenterRecipe(null, ItemRegistry.YEAST.getStackOf()));
            }
            Collection<ItemStack> li = MulchMaterials.instance.getAllValidPlants();
            for (ItemStack is : li) {
                this.arecipes.add(new FermenterRecipe(is, ReikaItemHelper.getSizedItemStack((ItemStack)ItemStacks.sludge, (int)MulchMaterials.instance.getPlantValue(is))));
            }
        }
        super.loadCraftingRecipes(outputId, results);
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId != null && inputId.equals("rcferment")) {
            this.loadCraftingRecipes(inputId, ingredients);
        }
        super.loadUsageRecipes(inputId, ingredients);
    }

    public void loadCraftingRecipes(ItemStack result) {
        if (ReikaItemHelper.matchStacks((ItemStack)result, (ItemStack)ItemStacks.sludge) || ReikaItemHelper.matchStacks((ItemStack)result, (ItemStack)ItemStacks.ethanolbucket)) {
            Collection<ItemStack> li = MulchMaterials.instance.getAllValidPlants();
            for (ItemStack is : li) {
                this.arecipes.add(new FermenterRecipe(is, ItemStacks.sludge.func_77946_l()));
            }
        } else if (result.func_77973_b() == ItemRegistry.YEAST.getItemInstance() && ConfigRegistry.enableFermenterYeast()) {
            this.arecipes.add(new FermenterRecipe(null, result));
        }
    }

    public boolean isEthanolIngredient(ItemStack is) {
        if (is.func_77973_b() == ItemRegistry.YEAST.getItemInstance()) {
            return true;
        }
        if (is.func_77973_b() == Items.field_151131_as) {
            return true;
        }
        return MulchMaterials.instance.getPlantValue(is) > 0;
    }

    public boolean isYeastIngredient(ItemStack is) {
        if (ReikaItemHelper.matchStackWithBlock((ItemStack)is, (Block)Blocks.field_150346_d)) {
            return true;
        }
        if (is.func_77973_b() == Items.field_151102_aT) {
            return true;
        }
        return is.func_77973_b() == Items.field_151131_as;
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        if (ItemRegistry.YEAST.matchItem(ingredient)) {
            Collection<ItemStack> li = MulchMaterials.instance.getAllValidPlants();
            for (ItemStack is : li) {
                this.arecipes.add(new FermenterRecipe(is, ItemStacks.sludge.func_77946_l()));
            }
        } else if (this.isEthanolIngredient(ingredient) || this.isYeastIngredient(ingredient)) {
            if (this.isYeastIngredient(ingredient)) {
                if (ConfigRegistry.enableFermenterYeast()) {
                    this.arecipes.add(new FermenterRecipe(ingredient, ItemRegistry.YEAST.getStackOf()));
                }
            } else {
                this.arecipes.add(new FermenterRecipe(ingredient, ItemStacks.sludge.func_77946_l()));
            }
        }
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiFermenter.class;
    }

    public void drawExtras(int recipe) {
        int l = 27;
        ReikaGuiAPI.instance.func_73729_b(18, 16 + l, 176, 31 + l, 11, 56 - l);
    }

    public class FermenterRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        private ItemStack output;
        private ItemStack input;

        private FermenterRecipe(ItemStack in, ItemStack out) {
            super((TemplateRecipeHandler)FermenterHandler.this);
            this.output = out;
            this.input = ReikaItemHelper.getSizedItemStack((ItemStack)in, (int)1);
        }

        public PositionedStack getResult() {
            int amt = this.input != null ? MulchMaterials.instance.getPlantValue(this.input) : 1;
            ItemStack is = this.output.func_77973_b() == ItemRegistry.YEAST.getItemInstance() ? this.output : ReikaItemHelper.getSizedItemStack((ItemStack)this.output, (int)amt);
            return new PositionedStack((Object)is, 111, 36);
        }

        public ArrayList<PositionedStack> getIngredients() {
            ArrayList<PositionedStack> stacks = new ArrayList<PositionedStack>();
            stacks.add(new PositionedStack((Object)this.getTopSlot(), 50, 18));
            stacks.add(new PositionedStack((Object)this.getBottomSlot(), 50, 54));
            return stacks;
        }

        private ItemStack getTopSlot() {
            return this.output.func_77973_b() == ItemRegistry.YEAST.getItemInstance() ? new ItemStack(Items.field_151102_aT) : ItemRegistry.YEAST.getStackOf();
        }

        private ItemStack getBottomSlot() {
            return this.output.func_77973_b() == ItemRegistry.YEAST.getItemInstance() ? new ItemStack(Blocks.field_150346_d) : this.input;
        }
    }
}

