/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.ModInterface.NEI;

import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaGuiAPI;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.WorktableRecipes;
import Reika.RotaryCraft.GUIs.Machine.Inventory.GuiWorktable;
import Reika.RotaryCraft.RotaryCraft;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class WorktableRecipeHandler
extends TemplateRecipeHandler {
    public String getRecipeName() {
        return "Worktable";
    }

    public String getGuiTexture() {
        return "/Reika/RotaryCraft/Textures/GUI/worktablegui.png";
    }

    public String getOverlayIdentifier() {
        return "crafting";
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ReikaTextureHelper.bindTexture(RotaryCraft.class, (String)this.getGuiTexture());
        GL11.glDisable((int)2929);
        ReikaGuiAPI.instance.drawTexturedModalRectWithDepth(0, 0, 5, 11, 166, 70, ReikaGuiAPI.NEI_DEPTH);
    }

    public void drawForeground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        ReikaTextureHelper.bindTexture(RotaryCraft.class, (String)this.getGuiTexture());
        this.drawExtras(recipe);
    }

    public void loadCraftingRecipes(ItemStack result) {
        List<WorktableRecipes.WorktableRecipe> li = WorktableRecipes.getInstance().getRecipeListCopy();
        for (WorktableRecipes.WorktableRecipe wr : li) {
            if (!ReikaItemHelper.matchStacks((ItemStack)result, (ItemStack)wr.getOutput())) continue;
            this.arecipes.add(new WorktableNEIRecipe(wr));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        List<WorktableRecipes.WorktableRecipe> li = WorktableRecipes.getInstance().getRecipeListCopy();
        for (WorktableRecipes.WorktableRecipe wr : li) {
            if (!wr.containsItem(ingredient)) continue;
            this.arecipes.add(new WorktableNEIRecipe(wr));
        }
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiWorktable.class;
    }

    public void loadTransferRects() {
    }

    public IOverlayHandler getOverlayHandler(GuiContainer gui, int recipe) {
        IOverlayHandler ioh = super.getOverlayHandler(gui, recipe);
        return ioh;
    }

    public class WorktableNEIRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        private final WorktableRecipes.WorktableRecipe recipe;

        public WorktableNEIRecipe(WorktableRecipes.WorktableRecipe rec) {
            super((TemplateRecipeHandler)WorktableRecipeHandler.this);
            this.recipe = rec;
        }

        public PositionedStack getResult() {
            return new PositionedStack((Object)this.recipe.getOutput(), 111, 24);
        }

        public ArrayList<PositionedStack> getIngredients() {
            ArrayList<PositionedStack> stacks = new ArrayList<PositionedStack>();
            ItemStack[] in = this.recipe.getDisplayArray();
            if (in == null) {
                RotaryCraft.logger.logError((Object)("Recipe " + this.recipe + " has null display array?!"));
                return stacks;
            }
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    ItemStack is = in[i * 3 + j];
                    int dx = 21 + 18 * j;
                    int dy = 6 + 18 * i;
                    if (is == null) continue;
                    PositionedStack pos = new PositionedStack((Object)is, dx, dy);
                    stacks.add(pos);
                }
            }
            return stacks;
        }
    }
}

