/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Registry;

import Reika.DragonAPI.Auxiliary.EnumDifficulty;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.RotaryCraft;
import java.util.Random;

public enum DifficultyEffects {
    BEDROCKDUST(3, 2, 1),
    PIPECRAFT(32, 16, 8),
    PARTCRAFT(6, 3, 2),
    BELTCRAFT(16, 8, 2),
    COMPACTOR(2, 2, 1),
    SMALLERCRAFT(2, 2, 1),
    BONUSSTEEL(2.0, 1.0, 0.5),
    BLASTCONSUME(0.4f, 1.0f, 3.0f),
    JETFAILURE(4500, 1800, 900),
    CONSUMEFRAC(0.03125f, 0.25f, 0.75f),
    PRODUCEFRAC(new int[]{1600, 3200}, new int[]{1000, 2200}, new int[]{400, 800}),
    BREAKCOIL(0.01, 0.05, 0.15),
    FURNACEMELT(1800, 600, 150),
    CANOLA(new int[]{128, 280}, new int[]{64, 160}, new int[]{8, 64}),
    RAILGUNCRAFT(16, 8, 2),
    LUBEUSAGE(0.25f, 1.0f, 2.5f),
    JETINGESTFAIL(0.05f, 0.2f, 0.5f),
    FRACTIONTEAR(0.0f, 0.0f, 0.05f);

    private boolean isChance = false;
    private boolean isRandom = false;
    private static final Random rand;
    private int easyInt;
    private int mediumInt;
    private int hardInt;
    private int easyMinimum;
    private int mediumMinimum;
    private int hardMinimum;
    private int easyMaximum;
    private int mediumMaximum;
    private int hardMaximum;
    private float easyChance;
    private float mediumChance;
    private float hardChance;
    private double easyDouble;
    private double mediumDouble;
    private double hardDouble;

    private DifficultyEffects(int easy, int med, int hard) {
        this.easyInt = easy;
        this.mediumInt = med;
        this.hardInt = hard;
    }

    private DifficultyEffects(int[] easy, int[] med, int[] hard) {
        this.isRandom = true;
        this.easyMinimum = easy[0];
        this.mediumMinimum = med[0];
        this.hardMinimum = hard[0];
        this.easyMaximum = easy[1];
        this.mediumMaximum = med[1];
        this.hardMaximum = hard[1];
    }

    private DifficultyEffects(float easy, float med, float hard) {
        this.isChance = true;
        this.easyChance = easy;
        this.mediumChance = med;
        this.hardChance = hard;
    }

    private DifficultyEffects(double easy, double med, double hard) {
        this.easyDouble = easy;
        this.mediumDouble = med;
        this.hardDouble = hard;
    }

    public int getInt() {
        if (this.isRandom) {
            switch (DifficultyEffects.getDifficulty()) {
                case EASY: {
                    return this.easyMinimum + rand.nextInt(1 + this.easyMaximum - this.easyMinimum);
                }
                case MEDIUM: {
                    return this.mediumMinimum + rand.nextInt(1 + this.mediumMaximum - this.mediumMinimum);
                }
                case HARD: {
                    return this.hardMinimum + rand.nextInt(1 + this.hardMaximum - this.hardMinimum);
                }
            }
            return this.mediumMinimum + rand.nextInt(1 + this.mediumMaximum - this.mediumMinimum);
        }
        switch (DifficultyEffects.getDifficulty()) {
            case EASY: {
                return this.easyInt;
            }
            case MEDIUM: {
                return this.mediumInt;
            }
            case HARD: {
                return this.hardInt;
            }
        }
        return this.mediumInt;
    }

    public float getChance() {
        switch (DifficultyEffects.getDifficulty()) {
            case EASY: {
                return this.easyChance;
            }
            case MEDIUM: {
                return this.mediumChance;
            }
            case HARD: {
                return this.hardChance;
            }
        }
        return this.mediumChance;
    }

    public double getDouble() {
        switch (DifficultyEffects.getDifficulty()) {
            case EASY: {
                return this.easyDouble;
            }
            case MEDIUM: {
                return this.mediumDouble;
            }
            case HARD: {
                return this.hardDouble;
            }
        }
        return this.mediumDouble;
    }

    public boolean testChance() {
        if (!this.isChance) {
            RotaryCraft.logger.logError((Object)((Object)((Object)this) + " is not chance, but was called for it!"));
            ReikaJavaLibrary.dumpStack();
            return false;
        }
        float chance = this.getChance();
        return ReikaRandomHelper.doWithChance((double)chance);
    }

    public static EnumDifficulty getDifficulty() {
        return EnumDifficulty.getDifficulty((int)ConfigRegistry.DIFFICULTY.getValue());
    }

    public int getMaxAmount() {
        if (this.isRandom) {
            switch (DifficultyEffects.getDifficulty()) {
                case EASY: {
                    return this.easyMaximum;
                }
                case MEDIUM: {
                    return this.mediumMaximum;
                }
                case HARD: {
                    return this.hardMaximum;
                }
            }
            return this.mediumMaximum;
        }
        switch (DifficultyEffects.getDifficulty()) {
            case EASY: {
                return this.easyInt;
            }
            case MEDIUM: {
                return this.mediumInt;
            }
            case HARD: {
                return this.hardInt;
            }
        }
        return this.mediumInt;
    }

    public int getAverageAmount() {
        if (this.isRandom) {
            switch (DifficultyEffects.getDifficulty()) {
                case EASY: {
                    return (this.easyMaximum + this.easyMinimum) / 2;
                }
                case MEDIUM: {
                    return (this.mediumMaximum + this.mediumMinimum) / 2;
                }
                case HARD: {
                    return (this.hardMaximum + this.hardMinimum) / 2;
                }
            }
            return (this.mediumMaximum + this.mediumMinimum) / 2;
        }
        switch (DifficultyEffects.getDifficulty()) {
            case EASY: {
                return this.easyInt;
            }
            case MEDIUM: {
                return this.mediumInt;
            }
            case HARD: {
                return this.hardInt;
            }
        }
        return this.mediumInt;
    }

    static {
        rand = new Random();
    }
}

