/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Registry;

import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Registry.ItemRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;

public enum Flywheels {
    WOOD(16, 2, 800.0, 2.0E7),
    STONE(128, 5, 3000.0, 9.0E7),
    IRON(512, 15, 7800.0, 1.0E9),
    GOLD(4096, 40, 19300.0, 1.08E8),
    TUNGSTEN(8192, 25, 10100.0, 7.84E9),
    DEPLETEDU(4096, 40, 19050.0, 3.75E9),
    BEDROCK(Integer.MAX_VALUE, 200, 13650.0, Double.POSITIVE_INFINITY);

    public final int maxTorque;
    public final int maxSpeed;
    public final int decayTime;
    public final double density;
    public final double tensileStrength;
    public static final Flywheels[] list;

    private Flywheels(int t, int dec, double rho, double str) {
        this.maxTorque = t;
        this.tensileStrength = str;
        this.decayTime = dec;
        this.density = rho;
        this.maxSpeed = this.getLimitLoad();
    }

    private int getLimitLoad() {
        double r = 0.75;
        double s = 100.0 * this.tensileStrength;
        double frac = 2.0 * s / (this.density * r * r);
        double base = Math.sqrt(frac);
        return (int)base;
    }

    public int getMinTorque() {
        return this == BEDROCK ? 16384 : this.maxTorque / 4;
    }

    public ItemStack getCore() {
        return ItemRegistry.FLYWHEELCRAFT.getStackOfMetadata(this.ordinal());
    }

    public ItemStack getFlywheelItem() {
        return MachineRegistry.FLYWHEEL.getCraftedMetadataProduct(this.ordinal());
    }

    public static Flywheels getMaterialFromFlywheelItem(ItemStack is) {
        int idx = is.func_77960_j();
        if (idx < 0 || idx >= list.length) {
            is.func_77964_b(0);
            is.func_150996_a(Item.func_150898_a((Block)Blocks.field_150348_b));
            return WOOD;
        }
        return list[idx];
    }

    public String getName() {
        return StatCollector.func_74838_a((String)("flywheel." + this.name().toLowerCase(Locale.ENGLISH)));
    }

    public Object getRawMaterial() {
        switch (this) {
            case GOLD: {
                return Items.field_151043_k;
            }
            case IRON: {
                return Items.field_151042_j;
            }
            case STONE: {
                return Blocks.field_150348_b;
            }
            case TUNGSTEN: {
                return ItemStacks.springtungsten;
            }
            case WOOD: {
                return "plankWood";
            }
            case BEDROCK: {
                return ItemStacks.bedingot;
            }
            case DEPLETEDU: {
                return "depletedUranium";
            }
        }
        return null;
    }

    public static int[] getSpeedLimits() {
        int[] ret = new int[list.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = Flywheels.list[i].maxSpeed;
        }
        return ret;
    }

    public static String getLimitsForDisplay() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < list.length; ++i) {
            Flywheels set = list[i];
            sb.append(String.format("%s: %d rad/s", set.getName(), set.maxSpeed));
            if (i >= list.length - 1) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    static {
        list = Flywheels.values();
    }
}

