/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Auxiliary;

import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Instantiable.Interpolation;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModList;
import Reika.RotaryCraft.Auxiliary.Interfaces.TemperatureTE;
import Reika.RotaryCraft.Base.TileEntity.RotaryCraftTileEntity;
import Reika.RotaryCraft.Registry.MachineRegistry;
import buildcraft.api.power.IEngine;
import ic2.api.reactor.IReactor;
import ic2.api.reactor.IReactorChamber;
import net.minecraft.block.material.Material;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class TileEntityCoolingFin
extends RotaryCraftTileEntity
implements TemperatureTE {
    private int targetx;
    private int targety;
    private int targetz;
    private int temperature;
    public int ticks = 512;
    public FinSettings setting = FinSettings.FULL;
    private static final Interpolation reactorTemperatureEfficiency = new Interpolation(false);

    @Override
    public void updateTemperature(World world, int x, int y, int z, int meta) {
        int Tamb = ReikaWorldHelper.getAmbientTemperatureAt((World)world, (int)x, (int)y, (int)z);
        if (ReikaWorldHelper.checkForAdjMaterial((World)world, (int)x, (int)y, (int)z, (Material)Material.field_151586_h) != null) {
            Tamb -= 5;
        }
        if (ReikaWorldHelper.checkForAdjMaterial((World)world, (int)x, (int)y, (int)z, (Material)Material.field_151587_i) != null) {
            Tamb = 2600;
        }
        if (ReikaWorldHelper.checkForAdjMaterial((World)world, (int)x, (int)y, (int)z, (Material)Material.field_151588_w) != null) {
            Tamb -= 15;
        }
        this.temperature = Tamb > this.temperature ? ++this.temperature : Math.max(Tamb, this.temperature - 2);
    }

    public int[] getTarget() {
        return new int[]{this.targetx, this.targety, this.targetz};
    }

    @Override
    public int getThermalDamage() {
        return this.temperature / 200;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public MachineRegistry getTile() {
        return MachineRegistry.COOLINGFIN;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        int temp;
        TemperatureTE tr;
        ++this.tickcount;
        if (this.ticks > 0) {
            this.ticks -= 8;
        }
        this.getTargetSide(world, x, y, z, meta);
        TileEntity te = world.func_147438_o(this.targetx, this.targety, this.targetz);
        if (!world.field_72995_K) {
            if (ModList.IC2.isLoaded() && (te instanceof IReactor || te instanceof IReactorChamber)) {
                this.coolIC2Reactor(world, x, y, z, te);
            }
            if (!ModList.BCENERGY.isLoaded() || te instanceof IEngine) {
                // empty if block
            }
        }
        if (this.tickcount < this.setting.tickRate) {
            return;
        }
        this.tickcount = 0;
        this.updateTemperature(world, x, y, z, meta);
        if (te instanceof TemperatureTE && (tr = (TemperatureTE)te).canBeCooledWithFins() && (temp = tr.getTemperature()) > this.temperature) {
            ++this.temperature;
            tr.addTemperature(-1);
        }
    }

    @DependentMethodStripper.ModDependent(value={ModList.IC2})
    private void coolIC2Reactor(World world, int x, int y, int z, Object te) {
        IReactor r;
        int h;
        if (this.getTicksExisted() % 20 != 0) {
            return;
        }
        if (te instanceof IReactorChamber) {
            te = ((IReactorChamber)te).getReactor();
        }
        if ((h = (r = (IReactor)te).getHeat()) > 0) {
            int rem = Math.max(1, (int)Math.min((double)(20.0f * this.setting.rawMultiplier) * reactorTemperatureEfficiency.getValue((double)this.temperature), (double)h));
            r.addHeat(-rem);
            int net = 500 * h / r.getMaxHeat();
            this.temperature += Math.max(1, Math.min(net - this.temperature, rem));
        }
    }

    private void getTargetSide(World world, int x, int y, int z, int meta) {
        switch (meta) {
            case 0: {
                this.targetx = x;
                this.targety = y - 1;
                this.targetz = z;
                break;
            }
            case 1: {
                this.targetx = x;
                this.targety = y + 1;
                this.targetz = z;
                break;
            }
            case 2: {
                this.targetx = x;
                this.targety = y;
                this.targetz = z - 1;
                break;
            }
            case 3: {
                this.targetx = x - 1;
                this.targety = y;
                this.targetz = z;
                break;
            }
            case 4: {
                this.targetx = x;
                this.targety = y;
                this.targetz = z + 1;
                break;
            }
            case 5: {
                this.targetx = x + 1;
                this.targety = y;
                this.targetz = z;
            }
        }
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    @Override
    public void addTemperature(int temp) {
        this.temperature += temp;
    }

    @Override
    public int getTemperature() {
        return this.temperature;
    }

    @Override
    public void overheat(World world, int x, int y, int z) {
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("tick", this.ticks);
        NBT.func_74768_a("setting", this.setting.ordinal());
        NBT.func_74768_a("temp", this.temperature);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.ticks = NBT.func_74762_e("tick");
        this.setting = FinSettings.list[NBT.func_74762_e("setting")];
        this.temperature = NBT.func_74762_e("temp");
    }

    @Override
    public void onEMP() {
    }

    @Override
    public boolean canBeCooledWithFins() {
        return false;
    }

    public void setTemperature(int temp) {
        this.temperature = temp;
    }

    @Override
    public boolean allowExternalHeating() {
        return false;
    }

    @Override
    public boolean allowHeatExtraction() {
        return true;
    }

    @Override
    public int getMaxTemperature() {
        return 2500;
    }

    static {
        reactorTemperatureEfficiency.addPoint(-273.0, 4.0);
        reactorTemperatureEfficiency.addPoint(-100.0, 3.0);
        reactorTemperatureEfficiency.addPoint(-25.0, 2.5);
        reactorTemperatureEfficiency.addPoint(0.0, 2.0);
        reactorTemperatureEfficiency.addPoint(15.0, 1.5);
        reactorTemperatureEfficiency.addPoint(25.0, 1.25);
        reactorTemperatureEfficiency.addPoint(50.0, 1.0);
        reactorTemperatureEfficiency.addPoint(80.0, 0.75);
        reactorTemperatureEfficiency.addPoint(100.0, 0.5);
        reactorTemperatureEfficiency.addPoint(250.0, 0.25);
        reactorTemperatureEfficiency.addPoint(500.0, 0.125);
    }

    public static enum FinSettings {
        FULL(20),
        HALF(40),
        QUARTER(80);

        public final int tickRate;
        public final float rawMultiplier;
        private static final FinSettings[] list;

        private FinSettings(int n2) {
            this.tickRate = n2;
            this.rawMultiplier = 20.0f / (float)this.tickRate;
        }

        public FinSettings next() {
            return this.ordinal() == list.length - 1 ? list[0] : list[this.ordinal() + 1];
        }

        static {
            list = FinSettings.values();
        }
    }
}

