/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Decorative;

import Reika.DragonAPI.Base.OneSlotMachine;
import Reika.DragonAPI.Interfaces.TileEntity.GuiController;
import Reika.DragonAPI.Interfaces.TileEntity.InertIInv;
import Reika.DragonAPI.Libraries.Registry.ReikaDyeHelper;
import Reika.RotaryCraft.Base.TileEntity.TileEntitySpringPowered;
import Reika.RotaryCraft.Registry.MachineRegistry;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TileEntityDisplay
extends TileEntitySpringPowered
implements InertIInv,
GuiController,
OneSlotMachine {
    private float scroll;
    private int[] rgb = new int[3];
    private int[] Brgb = new int[3];
    private static final int[] ArRGB = new int[]{0, 128, 255};
    private static final int[] ArBRGB = new int[]{0, 255, 255};
    private String message = "";
    public static final int displayHeight = 12;
    public static final int displayWidth = 27;
    public static final int lineHeight = 12;
    public static final int charWidth = 10;
    private boolean display;
    private ReikaDyeHelper color;
    private boolean isArgonBlue = true;

    public ReikaDyeHelper getDyeColor() {
        return this.color != null ? this.color : ReikaDyeHelper.BLACK;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
        if (this.getMessageLength() <= 12) {
            return;
        }
        this.scroll += 0.05f;
        if (this.scroll > (float)this.getMessageLength()) {
            this.scroll = 0.0f;
        }
    }

    @Override
    public MachineRegistry getTile() {
        return MachineRegistry.DISPLAY;
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        this.updateCoil();
        ++this.tickcount;
    }

    private void updateCoil() {
        if (!this.hasCoil()) {
            this.display = false;
            return;
        }
        this.display = true;
        ++this.tickcount;
        if (this.tickcount > this.getUnwindTime()) {
            ItemStack is;
            this.inv[0] = is = this.getDecrementedCharged();
            this.tickcount = 0;
        }
    }

    public boolean canDisplay() {
        return this.display;
    }

    public boolean hasList() {
        if (this.message == null) {
            return false;
        }
        return !this.message.isEmpty();
    }

    public int getMessageLength() {
        return this.message.length();
    }

    public float getScrollPos() {
        return this.scroll;
    }

    public boolean isReadyToLoadNewLine() {
        float frac = this.scroll - (float)((int)this.scroll);
        return frac >= 0.5f;
    }

    public int getRoundedScroll() {
        float frac = this.scroll - (float)((int)this.scroll);
        if (frac >= 0.5f) {
            return (int)this.scroll + 1;
        }
        return (int)this.scroll;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public boolean hasSpace() {
        World world = this.field_145850_b;
        int x = this.field_145851_c;
        int y = this.field_145848_d;
        int z = this.field_145849_e;
        int meta = this.func_145832_p();
        for (int j = -2; j <= 2; ++j) {
            int a = 0;
            int b = 0;
            if (meta == 0 || meta == 1) {
                b = j;
            } else {
                a = j;
            }
            for (int i = 1; i <= 3; ++i) {
                Block bk = world.func_147439_a(x + a, y + i, z + b);
                if (bk.isAir((IBlockAccess)world, x + a, y + i, z + b)) continue;
                return false;
            }
        }
        return true;
    }

    public int getRed() {
        return this.rgb[0];
    }

    public int getGreen() {
        return this.rgb[1];
    }

    public int getBlue() {
        return this.rgb[2];
    }

    public int getBorderRed() {
        return this.Brgb[0];
    }

    public int getBorderGreen() {
        return this.Brgb[1];
    }

    public int getBorderBlue() {
        return this.Brgb[2];
    }

    public int getTextColor() {
        return 0xFFFFFF;
    }

    public void setMessage(String str) {
        this.message = str;
    }

    public void clearMessage() {
        this.message = "";
    }

    public void setDyeColor(ReikaDyeHelper dye) {
        this.color = dye;
        this.isArgonBlue = false;
    }

    public void loadColorData() {
        if (this.isArgonBlue) {
            this.loadArgonColor();
        } else {
            int r = this.getDyeColor().getRed();
            int g = this.getDyeColor().getGreen();
            int b = this.getDyeColor().getBlue();
            this.rgb[0] = r;
            this.rgb[1] = g;
            this.rgb[2] = b;
            this.Brgb[0] = r;
            this.Brgb[1] = g;
            this.Brgb[2] = b;
        }
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("dye", this.getDyeColor().ordinal());
        NBT.func_74757_a("argon", this.isArgonBlue);
        NBT.func_74778_a("msg", this.message);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.isArgonBlue = NBT.func_74767_n("argon");
        this.color = ReikaDyeHelper.dyes[NBT.func_74762_e("dye")];
        this.message = NBT.func_74779_i("msg");
    }

    public void setColorToArgon() {
        this.isArgonBlue = true;
    }

    public void loadArgonColor() {
        this.rgb[0] = ArRGB[0];
        this.rgb[1] = ArRGB[1];
        this.rgb[2] = ArRGB[2];
        this.Brgb[0] = ArBRGB[0];
        this.Brgb[1] = ArBRGB[1];
        this.Brgb[2] = ArBRGB[2];
    }

    public List<String> getMessageForDisplay() {
        FontRenderer f = Minecraft.func_71410_x().field_71466_p;
        return f.func_78271_c(this.message, 27 * f.field_78288_b);
    }

    @Override
    public int getBaseDischargeTime() {
        return 120;
    }
}

