/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Processing;

import Reika.RotaryCraft.Base.TileEntity.PoweredLiquidIO;
import Reika.RotaryCraft.Registry.MachineRegistry;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class TileEntityDistillery
extends PoweredLiquidIO {
    private int tickcount = 0;

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        this.getPowerBelow();
        Conversion conv = this.getConversion();
        if (this.tickcount >= 5) {
            if (this.canMake(conv)) {
                this.make(conv);
            }
            this.tickcount = 0;
        } else {
            ++this.tickcount;
        }
    }

    private void make(Conversion conv) {
        this.input.removeLiquid(conv.getRequiredAmount());
        this.output.addLiquid(conv.getProductionAmount(), conv.outputFluid);
    }

    private boolean canMake(Conversion conv) {
        if (conv == null) {
            return false;
        }
        if (this.power < conv.minPower) {
            return false;
        }
        if (this.torque < conv.minTorque) {
            return false;
        }
        return this.input.getLevel() >= conv.getRequiredAmount() && this.output.canTakeIn(conv.outputFluid, conv.getProductionAmount());
    }

    private Conversion getConversion() {
        if (this.input.isEmpty()) {
            return null;
        }
        for (int i = 0; i < Conversion.list.length; ++i) {
            Conversion c = Conversion.list[i];
            if (!c.validate() || !c.inputFluid.equals(this.input.getActualFluid())) continue;
            return c;
        }
        return null;
    }

    @Override
    public boolean canConnectToPipe(MachineRegistry m) {
        return m.isStandardPipe() || m == MachineRegistry.HOSE || m == MachineRegistry.FUELLINE;
    }

    @Override
    public Fluid getInputFluid() {
        return null;
    }

    @Override
    public boolean isValidFluid(Fluid f) {
        for (int i = 0; i < Conversion.list.length; ++i) {
            Conversion c = Conversion.list[i];
            if (!c.validate() || !c.inputFluid.equals(f)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canOutputTo(ForgeDirection to) {
        return to == ForgeDirection.UP;
    }

    @Override
    public boolean canReceiveFrom(ForgeDirection from) {
        return from != ForgeDirection.UP;
    }

    @Override
    public boolean canIntakeFromPipe(MachineRegistry p) {
        return p.isStandardPipe() || p == MachineRegistry.HOSE || p == MachineRegistry.FUELLINE;
    }

    @Override
    public boolean canOutputToPipe(MachineRegistry p) {
        return p == MachineRegistry.HOSE || p.isStandardPipe() || p == MachineRegistry.FUELLINE;
    }

    @Override
    public int getCapacity() {
        return 6000;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public MachineRegistry getTile() {
        return MachineRegistry.DISTILLER;
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    public static String getValidConversions() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < Conversion.list.length; ++i) {
            Conversion c = Conversion.list[i];
            if (!c.validate()) continue;
            sb.append(c.toString());
            if (i >= Conversion.list.length - 1) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    private static enum Conversion {
        OIL("oil", "rc lubricant", 6, 2048, 8192L),
        ETHANOL1("bioethanol", "rc ethanol", 1, 512, 131072L),
        ETHANOL2("biofuel", "rc ethanol", -2, 512, 131072L);

        public final Fluid inputFluid;
        public final Fluid outputFluid;
        private final int conversionFactor;
        public final long minPower;
        public final int minTorque;
        public static final Conversion[] list;

        private Conversion(String in, String out, int factor, int mint, long minp) {
            this.inputFluid = FluidRegistry.getFluid((String)in);
            this.outputFluid = FluidRegistry.getFluid((String)out);
            this.conversionFactor = factor;
            this.minTorque = mint;
            this.minPower = minp;
        }

        public int getProductionAmount() {
            return this.conversionFactor > 0 ? this.conversionFactor : 1;
        }

        public int getRequiredAmount() {
            return this.conversionFactor > 0 ? 1 : -this.conversionFactor;
        }

        public boolean validate() {
            return this.inputFluid != null && this.outputFluid != null;
        }

        public String toString() {
            String name1 = this.inputFluid.getLocalizedName();
            String name2 = this.outputFluid.getLocalizedName();
            return name1 + " (" + this.getRequiredAmount() + " mB) + [" + this.minTorque + " Nm & " + this.minPower + "W] -> " + name2 + " (" + this.getProductionAmount() + " mB)";
        }

        static {
            list = Conversion.values();
        }
    }
}

